//    FS-HELP.DCL
//
//    Based on DDIM.DCL v1.0, which contains the following copyright notice:
//      Copyright (C) 1991-1992 by Autodesk, Inc.
//         
//    And also includes the following permission notice:
//      Permission to use, copy, modify, and distribute this software
//      for any purpose and without fee is hereby granted, provided
//      that the above copyright notice appears in all copies and that
//      both that copyright notice and this permission notice appear in
//      all supporting documentation.
//
//    Modified for use with FS-HELP.PRG by Fitting Solutions


fs_help_button :button{
    width = 12;
    fixed_width = true;
}


fs_help :dialog {
    label = "FS Help";
    :column {
        :list_box {
            width = 73;
            height = 15;
            key = "fsh_list";
            multiple_select = true;
            tabs = "9 17 25 33 41 49 57 65 73 81";
            max_lines = 1000;         // Max lines per help item
        }
        :row {
            fixed_width = true;
            alignment = centered;
            :edit_box {
                key = "fsh_item";
                label = "Help Item:";
                mnemonic = "H";
                edit_width = 40;
                allow_accept = false;
            }
            :fs_help_button {
                key = "fsh_index";
                label = "Index...";
                mnemonic = "I";
            }
        }
    }
    :row {
        fixed_width = true;
        alignment = centered;
        :fs_help_button {
            key = "fsh_accept";
            label = "OK";
            is_default = true;
            is_cancel = true;
        }
        :fs_help_button {
            key = "fsh_top";
            label = "Top";
            mnemonic = "T";
        }
        :fs_help_button {
            key = "fsh_prev";
            label = "Previous";
            mnemonic = "P";
        }
        :fs_help_button {
            key = "fsh_next";
            label = "Next";
            mnemonic = "N";
        }
    }
    errtile;
}

fs_index :dialog {
    label = "Help Index";
    initial_focus = "fsh_pattern";
    :list_box {
        key = "fsh_index_list";
        width = 41;
        height = 15;
        allow_accept = true;
    }
    :edit_box {
        key = "fsh_pattern";
        label = "Pattern:";
        mnemonic = "P";
        edit_width = 20;
        fixed_width = true;
    }
    ok_cancel_err;
}

