bolthelp :dialog {
  label = "Bolter Help Menu";
  :boxed_row {
    :button {
      label = "Size";
      key = "h1";
      fixed_height = false;
    }
    :boxed_column {
      label = "Configuration";
      :button {label = "Bolt Type"         ;key = "h2";}
      :button {label = "Head Washers"      ;key = "h3";}
      :button {label = "Body Style"        ;key = "h4";}
      :button {label = "Nut Washers"       ;key = "h5";}
      :button {label = "Nut Type"          ;key = "h6";}
      :button {label = "Thread Style"      ;key = "h7";}
    }
    :boxed_column {
      label = "Options";
      :button {label = "View Orientation"  ;key = "h8";}
      :button {label = "Thread Charact."   ;key = "h9";}
      :button {label = "Assembly Type"     ;key = "h10";}
      :button {label = "Thru Hole Options" ;key = "h11";}
      :button {label = "Blind Tap Options" ;key = "h12";}
      :button {label = "General Settings"  ;key = "h13";}
    }
  }
  :boxed_column {
    :row {
    :column {
      :button {label = "Layer"               ;key = "h14";}
      :button {label = "About"               ;key = "h15";}
    }
    :column {
      :button {label = "Data"                ;key = "h16";}
      :button {label = "Tips"                ;key = "h17";}
    }
    :column {
      :button {label = " Save Options  "     ;key = "h18";}
      :button {label = "Basic Operation"     ;key = "h19";}
    }
    }
    :row {
      :button {label = "  Customizing  "     ;key = "h20";}
      :button {label = " General Info  "     ;key = "h21";}
    }
  }
  spacer;
  ok_only;
}

bolter :dialog {
  label = "Bolter -- (c)1994, 1995 Fitting Solutions";
  :row {
    vertical_margin = none;
    :boxed_column {
      label = "Size";
      mnemonic = "S";
      :list_box {
	key = "bltr-size";
        vertical_margin = none;
        height = 20;
      }
    }
    :boxed_column {
      width = 27;
      fixed_width = true;
      label = "Configuration";
      mnemonic = "C";
      spacer;
      :labtext {
        label = "Bolt Type";
      }
      :popup {
	key = "bltr-bolt";
        list = "Hex Bolt\nHeavy Hex Bolt\nHex Cap Screw\nHeavy Hex Screw\nSocket Head Screw\nFlat Head Cap Screw\nFlat Head Mach. Screw\nRound Head Mach. Screw\nPan Head Mach. Screw\nFil. Head Mach. Screw\nTruss Head Mach. Screw";
      }
      :labtext {label = "Head Washer #1 Type";}
      :popup {
        key = "bltr-hwsh";
      }
      :labtext {label = "Head Washer #2 Type";}
      :popup {
        key = "bltr-xwsh";
      }
      :labtext {label = "Body Style";}
      :popup {
	key = "bltr-body";
        list = "None\nSolid Bolt & Hole\nHidden Bolt\nHidden Bolt & Hole";
      }
      :labtext {label = "Nut Washer #1 Type";}
      :popup {
	key = "bltr-nwsh";
      }
      :labtext {label = "Nut Washer #2 Type";}
      :popup {
	key = "bltr-lwsh";
      }
      :labtext {label = "Nut Type";}
      :popup {
	key = "bltr-nuts";
      }
      :labtext {label = "Thread Style";}
      :popup {
	key = "bltr-thrd";
        list = "Simplified\nSchematic\nChamfered Only\nBlock\nNone";
      }
      spacer_0;
    }
    :boxed_column {
      label = "Options";
      :boxed_radio_row {
        key = "bltr-view";
        vertical_margin = none;
        label = "View Orientation";
        :radio_button {
          label = "Head End";
          key = "bltr-vhed";
          mnemonic = "H";
        }
        :radio_button {
          label = "Side";
          key = "bltr-vsid";
          mnemonic = "V";
        }
        :radio_button {
          label = "Nut End";
          key = "bltr-vnut";
          mnemonic = "N";
        }
      }
      spacer;
      :row {
        :boxed_column {
          vertical_margin = none;
          label = "Thread Characteristics";
          :radio_row {
            key = "bltr-ptch";
            :radio_button {
              label = "Coarse";
              key = "bltr-pch0";
              mnemonic = "C";
            }
            :radio_button {
              label = "Fine  ";
              key = "bltr-pch1";
              mnemonic = "F";
            }
          }
          :row {
            :labtext {label = "Threads Per Inch:";}
            :text {
              key = "bltr-thpi";
              width = 5;
              alignment = left;
              horizontal_margin = none;
            }
            spacer_0;
          }
        }
      }
      spacer_0;
      :boxed_column {
        label = "Assembly Type";
        :radio_row {
          vertical_margin = none;
          key = "bltr-assy";
          :radio_button {
            label = "Through Bolt";
            key = "bltr-ass0";
            mnemonic = "T";
          }
          :radio_button {
            label = "Blind Tapped";
            key = "bltr-ass1";
              mnemonic = "B";
          }
        }
        :row {
          :button {
            label = "Set Options";
            key = "thruopt";
            horizontal_margin = none;
            mnemonic = "O";
          }
          :button {
            label = "Set Options";
            key = "taphopt";
            horizontal_margin = none;
            mnemonic = "p";
          }
        }
      }
      spacer;
      :boxed_column {
        label = "General Settings";
        :stoggle {
          label = "Complex Nuts & Bolt Heads";
          key = "bltr-cmpl";
          mnemonic = "P";
        }
        spacer;
        :stoggle {
          label = "Show Centerline With Bolt";
          key = "bltr-clin";
          mnemonic = "W";
        }
        spacer;
        :stoggle {
          label = "Show Hex Shapes Across Flats";
          key = "bltr-acfl";
          mnemonic = "A";
        }
        spacer;
        :stoggle {
          label = "Confirm Bolt Lengths";
          key = "bltr-conf";
          mnemonic = "n";
        }
        spacer;
        :edit_box {
          edit_width = 4;
          edit_limit = 8;
          horizontal_margin = none;
          vertical_margin = none;
          label = "Scale Factor:";
          key = "bltr-scal";
          mnemonic = "r";
        }
      }
    }
  }
  spacer;
  ok_cancel_help_layer;
  spacer;
}

picklayer :dialog {
  label = "Pick Bolter Layers";
  :row {
    :laylist {
      label = "Object Lines";
      key = "objlayer";
    }
    :laylist {
      label = "Hidden Lines";
      key = "hidlayer";
    }
    :laylist {
      label = "Center Lines";
      key = "cenlayer";
    }
    :laylist {
      label = "Bolt Data";
      key = "datlayer";
    }
  }
  spacer;
  ok_help;
}

dataopt :dialog {
  label = "Bolter Data";
  :stoggle {
    label = "Employ Data Blocks";
    key = "bltr-data";
    alignment = centered;
  }
  spacer;
  :boxed_radio_row {
    key = "bltr-dfmt";
    label = "Size Format";
    :radio_button {
      label = "Fractional";
      key = "5";
    }
    :radio_button {
      label = "Decimal";
      key = "2";
    }
  }
  spacer;
  :row {
    :text {
      label = "File Name: ";
    }
    :text {
      key = "fname";
      width = 30;
    }
  }
  :button {
    key = "setfile";
    label = "Set File Name...";
  }
  :button {
    label = "Write Data";
    key = "wdata";
  }
  spacer;
  ok_help;
}

setthruopt :dialog {
  label = "Through Bolting Parameters";
  :sedit_box {
    label = "Clearance Hole Dia. Over Bolt OD: ";
    key = "bltr-hdia";
  }
  :sedit_box {
    label = "Minimum No. of Threads Beyond Nuts:";
    key = "bltr-prot";
  }
  :boxed_column {
    label = "Bolted Surface Thickness";
    :radio_row {
      key = "bltr-lcon";
      :radio_button {
        key = "bltr-lco0";
        label = "Predetermined";
      }
      :radio_button {
        key = "bltr-lco1";
        label = "Per Point Picks";
      }
    }
    :row {
      :sedit_box {
        label = "Surface Thickness:";
        key = "bltr-blen";
      }
    }
  }
  spacer;
  ok_help;
}

settaphopt :dialog {
  label = "Blind Tapping Parameters";
  :column {
    :stoggle {
      key = "bltr-ntap";
      label = "Draw Tapped Hole Beyond Bolt End   ";
    }
    :column {
      key = "bltr-btap";
      :sedit_box {
        key = "bltr-teng";
        label = "Minimum Thread Engagement (x Dia.):";
      }
      :row {
        :stoggle {
          label = "Fix Tap Depth To:                ";
          key = "bltr-tflt";
        }
        :sedit_box {
          key = "bltr-tfix";
        }
      }
      :sedit_box {
        label = "Minimum No. of Extra Threads:    ";
        key = "bltr-tdep";
      }
      :sedit_box {
        label = "Lock From Surface to Even Units Of:";
        key = "bltr-tlok";
      }
      :column {
        vertical_margin = none;
        key = "bltr-bpil";
        :sedit_box {
          label = "Pilot Hole Depth Beyond Tapping: ";
          key = "bltr-pdep";
        }
        :row {
          :labtext {label = "Pilot Hole Drill Size:      ";}
          :text {key = "bltr-pdia";}
        }
      }
    }
  }
  spacer;
  ok_help;
}

laylist :list_box {
  height = 10;
  width = 15;
  fixed_width = true;
}

labtext :text_part {}

popup :popup_list {
  vertical_margin = none;
}

sedit_box :edit_box {
  edit_width = 8;
  edit_limit = 8;
  horizontal_margin = none;
  vertical_margin = none;
}

stoggle :toggle {
  vertical_margin = none;
}

layer_button : button {
  label = "Layer...";
  key = "layer";
  mnemonic = "L";
}

save_button : button {
  label = "Save Opt's";
  key = "soption";
  mnemonic = "S";
}

data_button : button {
  label = "Data...";
  key = "doption";
  mnemonic = "D";
}

ok_cancel_help_layer : column {
  :row {
    fixed_width = true;
    alignment = centered;
    :ok_button     {width = 12; fixed_width = true;}
    :cancel_button {width = 12; fixed_width = true;}
    :help_button   {width = 12; fixed_width = true;}
    :layer_button  {width = 12; fixed_width = true;}
    :data_button   {width = 12; fixed_width = true;}
    :save_button   {width = 12; fixed_width = true;}
  }
}

ok_help : column {
  :row {
    fixed_width = true;
    alignment = centered;
    :cancel_button {
      label = "OK";
      key = "accept";
    }
    :spacer {width = 2;}
    help_button;
  }
}

