; DWGTIME.LSP function to write out a report of drawing times
;
; DWGTIME.LSP writes out a file with the creation date/time, time
; spend within the editor on the drawing and the last update
; date/time.  The file format is space deliminated so that it
; can be easily imported into other programs such as spreadsheets
; and databases.  The file is named DWGTIME.TXT as is written to
; the same subdirectory as the drawings processed.
;
; You'll need to delete DWGTIME.TXT if you do not want old data.
; On the other hand, you can move DWGTIME.TXT from subdirectory to
; subdirectory to get a cumulative report.
;
; NOTE: As of R13 C2 there is a bug in the system variables that
;       track the time within the editor and the last update
;       date/time.  If you're using R13 you'll just have to see
;       if it has been fixed in your version yet.
;       Works fine with R12.

(defun dateconv(jd)
	(setq time (* 86400.0 (- jd (setq j (fix jd)))))
	(setq j (- j 1721119.0))
	(setq y (fix (/ (1- (* 4 j)) 146097.0)))
	(setq j (- (* j 4.0) 1.0 (* 146097.0 y)))
	(setq d (fix (/ j 4.0)))
	(setq j (fix (/ (+ (* 4.0 d) 3.0) 1461.0)))
	(setq d (- (+ (* 4.0 d) 3.0) (* 1461.0 j)))
	(setq d (fix (/ (+ d 4.0) 4.0)))
	(setq m (fix (/ (- (* 5.0 d) 3) 153.0)))
	(setq d (- (* 5.0 d) 3.0 (* 153.0 m)))
	(setq d (fix (/ (+ d 5.0) 5.0)))
	(setq y (+ (* 100.0 y) j))
	(if (< m 10.0)
		(setq m (+ m 3))
		(progn	
			(setq m (- m 9))
			(setq y (1+ y))
		)
	)	
	(setq datefix (strcat (itoa(fix y)) "/" (pleft(itoa(fix m))) "/" (pleft(itoa(fix d)))))
	(setq hh (fix (/ time 3600.0)))
	(setq time (- time (* hh 3600.00)))
	(setq mm (fix (/ time 60.0)))
	(setq ss (fix(- time (* mm 60.0))))
	(setq timefix(strcat " " (pleft(itoa hh)) ":" (pleft(itoa mm)) ":" (pleft(itoa ss))))
	(setq tconv(strcat datefix timefix))
)

** subroutine to fix time **

(defun timeconv(time)
	(setq time (* time 86400.0))
	(setq hh (fix (/ time 3600.0)))
	(setq time (- time (* hh 3600.00)))
	(setq mm (fix (/ time 60.0)))
	(setq ss (fix(- time (* mm 60.0))))
	(setq timefix(strcat (pleft(itoa hh)) ":" (pleft(itoa mm)) ":" (pleft(itoa ss))))
);end defun

** subroutine to pad zero **

(defun pleft(strg)
	(if (= (strlen strg) 1)(setq strg(strcat "0" strg))(setq strg strg))
)

***  MAIN ROUTINE ***
(defun dwgtime()
;build the report path
	(setq cname(getvar "dwgname"))
	(setq count 1 flag nil)
	(repeat (strlen cname)
		(if (= (substr cname count 1) (chr 92))
			(setq mark (1- count))
		);end if
		(setq count (1+ count))
	);end repeat
	(if mark
		(setq nname(strcat (substr cname 1 mark) (chr 92) "DWGTIME.TXT"))
		(setq nname (strcat (getvar "DWGPREFIX") "DWGTIME.TXT"))
	);end if
	;if new file, write out header
	(if (findfile nname)
		(setq flag t)
	);end if
	(setq ofile(open nname "a"))
	(if (not flag)
		(write-line "Create_Day Cre_Time Dwg_Time Update_Day Upd_Time Drawing_Path/Name" ofile)
	);end if
	(write-line (strcat
								(dateconv(getvar "tdcreate")) " "
								(timeconv(getvar "tdindwg")) " "
								(dateconv(getvar "tdupdate")) " "
								(getvar "dwgname"))
		ofile
	);end write-line
	(close ofile)
);end defun
;make this program 'load & go' - do this for all BatchCMD LISP
;compatible programs
(dwgtime)
