// AStruct! Dialog definition file //

properties : dialog {
label = "Member Properties" ;
  : boxed_column {
    key = "col1" ;
    is_enabled = false ;
    is_tab_stop = false ;
    : edit_box {
      edit_limit = 24 ;
      edit_width = 24 ;
      key = "mem_id" ;
      label = "Member ID:" ;
      mnemonic = "M" ;
    }
    : edit_box {
      edit_limit = 12 ;
      edit_width = 8 ;
      key = "mod_e" ;
      label = "Modulus of Elasticity (ksi):" ;
      mnemonic = "E" ;
    }
    : edit_box {
      edit_limit = 12 ;
      edit_width = 8 ;
      key = "inertia" ;
      label = "Moment of Inertia (in^4):" ;
      mnemonic = "I" ;
    }
    : edit_box {
       edit_limit = 12 ;
       edit_width = 8 ;
       key = "area_xx" ;
       label = "Member Area (in^2):" ;
       mnemonic = "A" ;
    }
    : edit_box {
       edit_limit = 12 ;
       edit_width = 8 ;
       key = "shear_mod" ;
       label = "Shear Modulus (ksi):" ;
       mnemonic = "S" ;
    }
    : edit_box {
       edit_limit = 12 ;
       edit_width = 8 ;
       key = "area_yy" ;
       label = "sHear Area (in^2):" ;
       mnemonic = "H" ;
    } 
  }
  spacer ;
  : row {
    key = "row" ;
    is_enabled = false ;
    is_tab_stop = false ;
    : boxed_column {
      key = "b_col1" ;
      label = "Start Fixity:" ;
      is_tab_stop = false ;
      : radio_column {
        key = "stf_start" ;
        is_enabled = false ;
        is_tab_stop = false ;
        : radio_button {
          key = "pin_start" ;
          label = "Pinned" ;
        }
        : radio_button {
          key = "fix_start" ;
          label = "Fixed" ;
        }
      }
    }
    : boxed_column {
      key = "b_col2" ;
      label = "End Fixity:  " ;
      is_tab_stop = false ;
      : radio_column {
        key = "stf_end" ;
        is_enabled = false ;
        is_tab_stop = false ;
        : radio_button {
          key = "pin_end" ;
          label = "Pinned" ;
        }
        : radio_button {
          key = "fix_end" ;
          label = "Fixed" ;
        }
      }
    }
  }
  spacer ;
  ok_cancel_help ;
  errtile;
}


loads : dialog {
label = "Loading Types" ;
 : row {
    : boxed_radio_column {
      label = "Load Type:" ;
          key = "load_type" ;
      : radio_button {
        key = "concentrated" ;
        label = "Concentrated" ;
        mnemonic = "C" ;
      }
      : radio_button {
        key = "uniform" ;
        label = "Uniform" ;
        mnemonic = "U" ;
      }
      : radio_button {
        key = "trapezoidal" ;
        label = "Trapezoidal" ;
        mnemonic = "T" ;
      }
      : radio_button {
        key = "moment" ;
        label = "Moment" ;
        mnemonic = "M" ;
      }
    }
   : boxed_column {
    label = "Orientation:";
    : radio_column {
      key = "orientation";
      : radio_button {
       value = "1" ;
       key = "global" ;
       label = "Global" ;
       mnemonic = "G" ;
      }
      : radio_button {
       key = "local" ;
       label = "Local" ;
       mnemonic = "L" ;
      }
    }
    : text {
      label =  "(to member)";
    }
    spacer;
    : edit_box {
      edit_limit = 10 ;
      edit_width = 8 ;
      key = "angle_type" ;
      label = "aNgle:" ;
      mnemonic = "N" ;
    }
   }
  }
  : boxed_column {
    children_fixed_width = true ;
    label = "Load Case Information:" ;
    : row {
      : radio_column {
        spacer ;
        key = "load_case" ;
        : radio_button {
          key = "case_one";
        }
        : radio_button {
          key = "case_two" ;
        }
        : radio_button {
          key = "case_three" ;
        }
        spacer ;
      }
      : column {
        spacer ;
        : text {
          key = "lc_one" ;
          width = 10 ;
        }
        : text {
          key = "lc_two" ;
          width = 10 ;
        }
        : text {
          key = "lc_three" ;
          width = 10;
        }
        spacer ;
      }
      : column {
        spacer_1 ;
        : text {
          label = "Start:" ;
        }
        : text {
           key = "end_text";
           label = "End:" ;
        }
      }
      : column {
        : text {
           label = "Load:" ;
        }
        : edit_box {
           edit_limit = 15 ;
           edit_width = 9 ;
           key = "start_load" ;
        }
        : edit_box {
           edit_limit = 15 ;
           edit_width = 9 ;
           key = "end_load" ;
        }
      }
      : column {
        spacer_1 ;
        : text {
          key = "start_units" ;
           width = 6;
        }
        : text {
           key = "end_units" ;
           width = 6;
        }
      }
     }
  }
  : edit_box {
     edit_limit = 10 ;
     edit_width = 10 ;
     value = "1.00" ;
     key = "scale" ;
     label = "Load View Scale Factor:";
     mnemonic = "S";
  }  
  spacer ;
  apply_cancel_help ;
  errtile ;
}

apply_button  : retirement_button {
              label         =   "Apply <";
              key            = "apply";
              mnemonic   = "A";
}

                  
apply_cancel_help : column {
   : row {
      fixed_width = true;
      alignment = centered;
      : apply_button {is_default = true; }
      : spacer { width = 2; }
      cancel_button;
      : spacer { width = 2; }
      help_button;
      }
}

springs : dialog {
label = "Spring Stiffness";
  spacer_1 ;
  : row {
    is_tab_stop = false ;
    : row {
      : text {
        value = "Number of joints selected: " ;
        width = 27 ;
      }
      : text {
        key = "num_str";
        width = 5;
        fixed_width = true;
      }
    }
  }
  spacer_1 ;
  : boxed_column {
    children_fixed_width = true ;
    label = "Joint Stiffness:" ;
    fixed_width = true ;
    : row {
      : edit_box {
        edit_limit = 12 ;
        edit_width = 8 ;
        key = "x_stiff" ;
        label = "X Direction:" ;
        mnemonic = "X" ;
      }
      : text {
        value = "(k/ft)" ;
        width = 10 ;
      }
    }
    : row {
      : edit_box {
        edit_limit = 12 ;
        edit_width = 8 ;
        key = "y_stiff" ;
        label = "Y Direction:" ;
        mnemonic = "Y" ;
      }
      : text {
        value = "(k/ft)" ;
        width = 10 ;
      }
    }
    : row {
      : edit_box {
        edit_limit = 12 ;
        edit_width = 8 ;
        key = "z_stiff" ;
        label = "Rotational: " ;
        mnemonic = "R" ;
      }
      : text {
        value = "(k-ft/rad)" ;
        width = 10 ;
      }
    }
  }
  spacer ;
  ok_cancel_help ;
  errtile ;
}

analysis : dialog {
label = "Analysis Options";
  : boxed_column {
   children_fixed_height = true ;
   label = "Numbering System:" ;
   : row {
    : boxed_radio_column {
      key = "nodes" ;
      label = "Nodes:" ;
      : radio_button {
       key = "node_ad" ;
       label = "As selected." ;
       }
       : radio_button {
        key = "node_xa" ;
        label = "X axis." ;
       }
       : radio_button {
        key = "node_ya" ;
        label = "Y axis." ;
       }
      }
    : boxed_radio_column {
      key = "members" ;
      label = "Members:" ;
      : radio_button {
       key = "mem_ad" ;
       label = "As selected." ;
      }
      : radio_button {
       key = "mem_xa" ;
       label = "X axis." ;
      }
      : radio_button {
       key = "mem_ya" ;
       label = "Y axis." ;
      }
    }
   }
  }
  : boxed_column {
    children_fixed_height = true ;
    label = "Project Title:" ;
    : edit_box {
      edit_limit = 39 ;
      key = "title1" ;
    }
    : edit_box {
      edit_limit = 39 ;
      key = "title2" ;
    }
  }
  : row {
   : boxed_column {
    label = "Analysis Options:" ;
    : text {
      label = "Generate:" ;
    }
    : toggle {
      key = "input" ;
      label = "Input File." ;
    }
    : toggle {
      key = "output" ;
      label = "Output File." ;
    }
    : toggle {
      key = "coords" ;
      label = "Joint Ordinates." ;
    }
    : toggle {
      key = "deflect" ;
      label = "Deformed Shape." ;
    }
    : edit_box {
      label = "Scale:" ;
      is_enabled = false ;
      edit_limit = 10 ;
      edit_width = 10 ;
      key = "def_scale" ;
    }
   }
  : boxed_row {
   label = "Load Information:" ;
   : column {
     spacer_1 ;
     : radio_column {
       children_alignment = right ;
       key = "lc_save" ;
       : radio_button {
        label = " ";
        key = "lc_one_s";
       }
       spacer ;
       : radio_button {
         label = " ";
         key = "lc_two_s" ;
       }
       spacer ;
       : radio_button {
         label = " ";
         key = "lc_three_s" ;
       }
       spacer ;
       : radio_button {
         label = " " ;
         key = "lc_four_s" ;
       }
       spacer ;
     }
   }
   : column {
    children_fixed_width = true ;
    : text {
      label = "Titles:" ;
    }
    : edit_box {
      edit_limit = 10 ;
      edit_width = 10 ;
      key = "lc_one" ;
    }
    : edit_box {
      edit_limit = 10 ;
      edit_width = 10 ;
      key = "lc_two" ;
    }
    : edit_box {
      edit_limit = 10 ;
      edit_width = 10 ;
      key = "lc_three" ;
    }
    spacer ;
    : text {
      label = "TOTAL" ;
    }
   }
  }
  } 
  spacer ;  
  ok_cancel_help ;
  errtile ;
}

config : dialog {
label = "Configuration Options";
  spacer ;
  : column {
    : button {
     key = "save" ;
     label = "Save .CFG File" ;
     mnemonic = "S" ;
     width = 22 ;
     fixed_width = true ;
     alignment = centered ;
    }
    : button {
     key = "analysis" ;
     label = "Analysis Options..." ;
     mnemonic = "A" ;
     width = 22 ;
     fixed_width = true ;
     alignment = centered ;
    }
    : button {
     key = "print_cont" ;
     label = "Printout Control..." ;
     mnemonic = "P" ;
     width = 22 ;
     fixed_width = true ;
     alignment = centered ;
    }
  }
  spacer ;
  : row {
    : boxed_column {
      key = "text_setup" ;
      label = "Text Setup:" ;
      fixed_width = true ;
      width = 18 ;
      : text {
        label = "Style:" ;
      }
      : popup_list {
        key = "popup_text" ;
        fixed_width = true ;
        width = 18 ;
      }
      spacer ;
      : column {
        : edit_box {
          allow_accept = true ;
          edit_limit = 12 ;
          edit_width = 6 ;
          key = "text_ht" ;
          label = "Height:" ;
          mnemonic = "H" ;
          width = 14 ;
        }
        : edit_box {
          allow_accept = true ;
          edit_limit = 12 ;
          edit_width = 6 ;
          key = "oblique" ;
          label = "oBlique:" ;
          mnemonic = "B" ;
          width = 14 ;
        }
        : edit_box {
          allow_accept = true ;
          edit_limit = 12 ;
          edit_width = 6 ;
          key = "text_offset" ;
          label = "Offset:" ;
          mnemonic = "O" ;
          width = 14 ;
        }
      }
    }
    : boxed_column {
      children_fixed_width = true ;
      label = "Drawing Setup:" ;
      spacer_0 ;
      : edit_box {
        alignment = right ;
        allow_accept = true ;
        edit_limit = 12 ;
        edit_width = 6 ;
        key = "node_rad" ;
        label = "Node Radius:" ;
        mnemonic = "R" ;
      }
      spacer_1 ;
      spacer_0 ;
      : boxed_radio_column {
        key = "member_orient" ;
        label = "Member Orientation:" ;
        fixed_width = true ;
        width = 17 ;
        : radio_button {
          key = "o_asdrawn" ;
          label = "As Drawn." ;
        }
        : radio_button {
          key = "o_x_axis" ;
          label = "X Axis." ;
        }
        : radio_button {
          key = "o_y_axis" ;
          label = "Y Axis." ;
        }
      }
    }
  }
  spacer ;
  ok_cancel_help ;
  errtile ;
}

member_list : dialog {
label = "Member Information" ;
   : row {
    : text {
      label = "Name:" ;
       width = 6 ;
    }
    : text {
      key = "memb_id" ;
      width = 25 ;
    }
   }
   : row {
    : text {
      value = "Member Number:" ;
      width = 15 ;
    }
    : text {
      key = "memb_num" ;
      width = 6;
    }
   : text {
      label = "Member Handle:" ;
      width = 15 ;
    }
    : text {
      key = "handle" ;
      width = 10 ;
    }
   }
  : boxed_row {
    children_fixed_width = true ;
    label = "Properties:" ;
    : column {
      : text {
        label = "Area-xx:" ;
        width = 16 ;
      }
      : text {
        label = "Inertia:" ;
        width = 16 ;
      }
      : text {
        label = "Elastic Modulus:" ;
        width = 16 ;
      }
      : text {
        label = "Area-yy:" ;
        width = 16 ;
      }
      : text {
        label = "Shear Modulus:" ;
        width = 16 ;
      }
    }
    : column {
      : text {
        key = "area_x_v" ;
        width = 10 ;
      }
      : text {
        key = "inertia_v" ;
        width = 10 ;
      }
      : text {
        key = "e_mod_v" ;
        width = 10 ;
      }
      : text {
        key = "area_y_v" ;
        width = 10 ;
      }
      : text {
        key = "s_mod_v" ;
        width = 10 ;
      }
    }
    : column {
      : text {
        value = "(in^2)" ;
        width = 6 ;
      }
      : text {
        value = "(in^4)" ;
        width = 6 ;
      }
      : text {
        value = "(ksi)" ;
        width = 6 ;
      }
      : text {
        value = "(in^2)" ;
        width = 6 ;
      }
      : text {
        value = "(ksi)" ;
        width = 6 ;
      }
    }
  }
  : boxed_column {
    spacer ;
    label = "Member Geometry:" ;
    : row {
      : text {
        value = "Member Length:" ;
        width = 15 ;
      }
      : text {
        key = "length" ;
        width = 15 ;
      }
    }
    : row {
      children_fixed_width = true ;
      : text {
        value = "X:" ;
        width = 8 ;
      }
      : text {
        key = "x_s" ;
        width = 12 ;
      }
      : text {
        key = "x_e" ;
        width = 12 ;
      }
    }
    : row {
      children_fixed_width = true ;
      : text {
        value = "Y:" ;
        width = 8 ;
      }
      : text {
        key = "y_s" ;
        width = 12 ;
      }
      : text {
        key = "y_e" ;
        width = 12 ;
      }
    }
    : row {
      children_fixed_width = true ;
      : text {
        value = "Z:" ;
        width = 8 ;
      }
      : text {
        key = "z_s" ;
        width = 12 ;
      }
      : text {
        key = "z_e" ;
        width = 12 ;
      }
    }
    : row {
      children_fixed_width = true ;
      : text {
        value = "Fixity:" ;
        width = 8 ;
      }
      : text {
        key = "fix_s" ;
        width = 12 ;
      }
      : text {
        key = "fix_e" ;
        width = 12 ;
      }
    }
  }
  : row {
    fixed_width = true ;
    alignment = centered ;
    : button {
     key = "forces" ;
     label = "Reactions..." ;
    }
  }
  flip_buttons ;
}


member_nest : dialog {
label = "Member Reactions" ;
    spacer ;
    : row {
      : text {
        value = "Member Number:" ;
      }
      : text {
        key = "memb_num" ;
        width = 6;
      }
    }
    : row {
      : column {
        : text {
          value = "Location:" ;
        }
        : text {
          value = "Joint:" ;
        }
      }
      : column {
        : text {
          value = "Start:" ;
        }
        : text {
          key = "jnt_s" ;
        }
      }
      : column {
        : text {
          value = "End:" ;
        }
        : text {
          key = "jnt_e" ;
        }
      }
    }
    spacer ;
    : boxed_column {
      children_alignment = right;
      children_fixed_width = true ;
      label = "Member Forces:" ;
      spacer ;
      : row {
        : text {
          alignment = centered ;
          value = "Shear:" ;
          width = 12 ;
        }
        : text {
          key = "shear_s" ;
          width = 12 ;
      }
      : text {
        key = "shear_e" ;
        width = 12 ;
      }
      : text {
        value = "(kips)" ;
        width = 6 ;
      }
    }
    : row {
      : text {
        value = "Axial:" ;
        width = 12 ;
      }
      : text {
        key = "axial_s" ;
        width = 12 ;
      }
      : text {
        key = "axial_e" ;
        width = 12 ;
      }
      : text {
        value = "(kips)" ;
        width = 6 ;
      }
    }
    : row {
      : text {
        value = "Moment:" ;
        width = 12 ;
      }
      : text {
        key = "moment_s" ;
        width = 12 ;
      }
      : text {
        key = "moment_e" ;
        width = 12 ;
      }
      : text {
        value = "(k-ft)" ;
        width = 6 ;
      }
    }
   }
   ok_only ;
}

node_list : dialog {
label = "Joint Information" ;
  spacer_1 ;
  : column {
    children_alignment = centered ;
    : row {
      children_fixed_width = true ;
      fixed_width = true ;
      width = 40 ;
      : text {
        label = "Joint Number:" ;
        key = "jnt_num" ;
        width = 14 ;
      }
      : text {
        key = "j_num" ;
        width = 5 ;
      }
      : text {
        label = "Joint Handle:" ;
        width = 14 ;
      }
      : text {
        key = "handle" ;
        width = 10 ;
      }
    }
  }
  spacer ;
  : row {
    : column {
      spacer ;
      spacer_1 ;
      : text {
        label = "X:" ;
      }
      : text {
        label = "Y:" ;
      }
      : text {
        label = "Z:" ;
      }
    }
    : boxed_column {
      label = "Location:" ;
      : text {
        alignment = right ;
        key = "x_pnt" ;
        fixed_width = true ;
        width = 14 ;
      }
      : text {
        alignment = right ;
        key = "y_pnt" ;
        fixed_width = true ;
        width = 14 ;
      }
      : text {
        alignment = right ;
        key = "z_pnt" ;
        fixed_width = true ;
        width = 14 ;
      }
    }
    spacer ;
    : boxed_column {
      key = "frdms" ;
      label = "Freedoms:" ;
      : text {
       alignment = centered ;
       key = "x_frdm" ;
       width = 5;
      }
      : text {
       alignment = centered ;
       key = "y_frdm" ;
       width = 5 ;
      }
      : text {
       alignment = centered ;
       key = "z_frdm" ;
       width = 5 ;
      }
    }
    spacer ;
    : boxed_column {
      label = "Spring Stiffnesses:" ;
      : row {
        : text {
          alignment = bottom ;
          key = "x_stfns" ;
          fixed_width = true ;
          width = 12 ;
        }
        : text {
          label = "(k/ft)" ;
          fixed_width = true ;
          width = 9 ;
        }
      }
      : row {
        : text {
          alignment = bottom ;
          key = "y_stfns" ;
          fixed_width = true ;
          width = 12 ;
        }
        : text {
          label = "(k/ft)" ;
          fixed_width = true ;
          width = 9 ;
        }
      }
      : row {
        : text {
          alignment = bottom ;
          key = "z_stfns" ;
          fixed_width = true ;
          width = 12 ;
        }
        : text {
          label = "(kft/rad)" ;
          fixed_width = true ;
          width = 9 ;
        }
      }
    }
    spacer ;
  }
  : row {
    fixed_width = true ;
    alignment = centered ;
    : button {
     key = "disp" ;
     label = "Displacements..." ;
    }
  }
  spacer ;
  flip_buttons ;
}

node_nest : dialog {
label = "Joint Displacements" ;
  spacer_1 ;
    : row {
      : text {
        label = "Joint Number:" ;
        fixed_width = true ;
        width = 14 ;
      }
      : text {
        key = "j_num" ;
        fixed_width = true ;
        width = 5 ;
      }
    }
  : row {
    : column {
      spacer ;
      spacer_1 ;
      : text {
        label = "X:" ;
      }
      : text {
        label = "Y:" ;
      }
      : text {
        label = "Z:" ;
      }
    }
    : boxed_column {
      children_fixed_width = true ;
      key = "disp" ;
      label = "Displacements:" ;
      : row {
        : text {
          key = "x_mvmnt" ;
          width = 12 ;
        }
        : text {
          label = "(in)" ;
          width = 5 ;
        }
      }
      : row {
        : text {
          key = "y_mvmnt" ;
          width = 12 ;
        }
        : text {
          label = "(in)" ;
          width = 5 ;
        }
      }
      : row {
        : text {
          key = "z_mvmnt" ;
          width = 12 ;
        }
        : text {
          label = "(rad)" ;
          width = 5 ;
        }
      }
    }
    : boxed_column {
      children_fixed_width = true ;
      key = "react" ;
      label = "Reactions:" ;
      : row {
        : text {
          key = "x_rctn" ;
          width = 12 ;
        }
        : text {
          label = "(kips)" ;
          width = 6 ;
        }
      }
      : row {
        : text {
          key = "y_rctn" ;
          width = 12 ;
        }
        : text {
          label = "(kips)" ;
          width = 6 ;
        }
      }
      : row {
        : text {
          key = "z_rctn" ;
          width = 12 ;
        }
        : text {
          label = "(k-ft)" ;
          width = 6 ;
        }
      }         
     }
  }
  spacer ;
  ok_only ;
}

loads_list : dialog {
label = "Loading List" ;
  : row {
    children_fixed_width = true ;
    : text {
     label = "Load Type:" ;
    }
    : text {
     key = "type" ;
     width = 16 ;
    }
    : text {
     label = "Load Case:" ;
    }
    : text {
     key = "case" ;
     width = 10 ;
    }
  }
  : row {
    children_fixed_width = true ;
    : text {
     label = "Load Angle to Member:" ;
    }
    : text {
     key = "angle" ;
     width = 8 ;
    }
    : text {
     label = "Global Load Angle:" ;
    }
    : text {
     key = "global_angle" ;
     width = 8 ;
    }
  }
  spacer_1 ;
  : row {
    : column {
     spacer ;
     spacer_1 ;
     : text {
      label = "Start:" ;
     }
     : text {
      label = "End:" ;
     }
    }
    : boxed_column {
     label = "Loads:" ;
     children_fixed_width = true ;
     : row {
      : text {
        key = "start_l" ;
        width = 12 ;
      }
      : text {
        key = "units_start" ;
        width = 6 ;
      }
     }
      : row {
        : text {
          key = "end_l" ;
          fixed_width = true ;
          width = 12 ;
        }
        : text {
          key = "units_end" ;
          fixed_width = true ;
          width = 6 ;
        }
      }
    }
    : boxed_column {
      label = "X Location:" ;
      : text {
        key = "load_start_x" ;
        fixed_width = true ;
        width = 15 ;
      }
      : text {
        key = "load_end_x" ;
        fixed_width = true ;
        width = 15 ;
      }
    }
    : boxed_column {
      label = "Y Location:" ;
      : text {
        key = "load_start_y" ;
        fixed_width = true ;
        width = 15 ;
      }
      : text {
        key = "load_end_y" ;
        fixed_width = true ;
        width = 15 ;
      }
    }
  }
  spacer_1 ;
  : boxed_column {
    children_fixed_width = true ;
    label = "Entity Information:" ;
    : row {
     : text {
      label = "Entity Handle:" ;
     }
     : text {
      key = "handle" ;
      width = 10 ;
     }
     : text {
      key = "num" ;
      label = "Number:" ;
     }
     : text {
      key = "number" ;
      width = 5 ;
     }
     : text {
      label = "Entity Type:" ;
     }
     : text {
      key = "ent_type" ;
      width = 8 ;
     }
    }
    : boxed_column {
     alignment = centered ;
     key = "memb_info" ;
     label = "Load to Member Location:" ;
     : row {
      : text {
        label = "Member Length:" ;
      }
      : text {
        key = "length" ;
        width = 15 ;
      }
     }
     : row {
      : text {
        label = "a/Length:" ;
      }
      : text {
        key = "start_loc" ;
        width = 8 ;
      }
      : text {
        label = "b/Length:" ;
      }
      : text {
        key = "end_loc" ;
        width = 8 ;
      }
     }
    }
    spacer_1 ;
  }
  spacer_1 ;
  flip_buttons ;
  errtile ;
}

flip_buttons : column {
  : row {
    alignment = centered ;
    fixed_width = true ;
    : button {
      key = "done" ;
      label = "Done" ;
      mnemonic = "D" ;
      width = 9 ;
      is_default = true;
      is_cancel = true ;
    }
    : spacer {width = 3; }
    : button {
      key = "back" ;
      label = "Back..." ;
      mnemonic = "B" ;
    }
    : button {
      key = "next" ;
      label = "Next..." ;
      mnemonic = "N" ;
    }
    : spacer { width = 3; }
    help_button;
    }
}

query : dialog {
label = "Query Dialog" ;
  spacer ;
  : column {
    : text {
      label = "Really cancel the" ;
    }
    : text {
      label = "AStruct! analysis?" ;
    }
  }
  spacer ;
  ok_cancel;
  spacer ;
}

printer : dialog {
label = "Printer Configuration" ;
    : boxed_column {
    label = "Printer Control:" ;
    : edit_box {
      edit_limit = 127 ;
      edit_width = 20 ;
      key = "print_str" ;
      label = "Initializer:" ;
      mnemonic = "I" ;
    }
    : edit_box {
      edit_limit = 5 ;
      edit_width = 5 ;
      key = "page_len" ;
      label = "Page Length:" ;
      mnemonic = "P" ;
    }
  }
  ok_cancel_help ;
  errtile ;
}

info : dialog {
label = "AStruct! Info" ;
  : row { 
    children_alignment = top ;
    children_fixed_height = true;
    : image {
      aspect_ratio = 1 ;
      color = dialog_background ;
      key = "image" ;
      width = 20 ;
      height = 7 ;
    }
    : column {
      children_alignment = centered;
      : text {
        key = "title1" ;
        width = 36 ;
      }
      : text {
        key = "title2" ;
        width = 43 ;
      }
      : text {
        key = "title3" ;
        width = 19;
      }
      spacer ;
      : text {
        key = "title4" ;
        width = 12 ;  
      }
      
    }
  }
  : list_box {
    key = "info" ;
    value = "" ;
  }
  register_cancel ;
}

register_button  : retirement_button {
             label         =   "Register...";
             key            = "register";
             mnemonic   = "R";
}

handles : dialog {
label = "Turn on Handles" ;
  spacer ;
  : column {
    children_alignment = centered ;
    spacer ;
    : text {
      label = "AStruct! requires handles to be enabled." ;
    }
    : text {
      label = "Do you want to turn handles on?" ;
    }
  }
  spacer ;
  ok_cancel;
  spacer ;
}

register_cancel : column {
   : row {
      fixed_width = true;
      alignment = centered;
      : register_button { is_default = true; }
      : spacer { width = 2; }
      : cancel_button 
      : spacer { width = 2 ; }
   }
}        

register : dialog {
label = "AStruct! Registration" ;
  : row {
   : column {
    children_alignment = right ;
    children_fixed_width = true ;
    : edit_box {
      edit_limit = 30 ;
      edit_width = 20 ;
      key = "name" ;
      label = "Name:" ;
      mnemonic = "N" ;
    }
    : edit_box {
      edit_limit = 30 ;
      edit_width = 20 ;
      key = "company" ;
      label = "Company:" ;
      mnemonic = "C" ;
      fixed_width = true ;
    }
    : edit_box {
      edit_limit = 30 ;
      edit_width = 20 ;
      key = "add" ;
      label = "Address:" ;
      mnemonic = "A" ;
    }
    : edit_box {
      edit_limit = 30 ;
      edit_width = 20 ;
      key = "add2" ;
    }
   }
   : column {
    : edit_box {
      edit_limit = 15 ;
      edit_width = 8 ;
      key = "city" ;
      label = "cIty:" ;
      mnemonic = "i" ;
    }
    : edit_box {
      edit_limit = 8 ;
      edit_width = 8 ;
      key = "state" ;
      label = "State/Prov:" ;
      mnemonic = "S" ;
    }
    : edit_box {
      edit_limit = 15 ;
      edit_width = 8 ;
      key = "zip" ;
      label = "Zip: " ;
      mnemonic = "Z" ;
    }
    : edit_box {
      edit_limit = 8 ;
      edit_width = 8 ;
      key = "country" ;
      label = "cOuntry:" ;
      value = "USA" ;
      mnemonic = "O" ;
    }
   }
  }
  : row {
    : boxed_radio_column {
      label = "Disk size:" ;
      : radio_button {
        key = "flop1" ;
        label = "1.44" ;
      }
      : radio_button {
        key = "flop2" ;
        label = "1.2" ;
        value = "1" ;
      }
    }
    : boxed_radio_column {
      label = "Units:" ;
      : radio_button {
        key = "unit1" ;
        label = "Metric" ;
      }
      : radio_button {
        key = "unit2" ;
        label = "English" ;
        value = "1" ;
      }
    }
    : boxed_radio_column {
      label = "Invoice Output:" ;
      : radio_button {
        key = "lpt1" ;
        label = "LPT1" ;
        value = "1" ;
      }
      : radio_button {
        key = "file" ;
        label = "REGISTER.TXT" ;
      }
    }
  }
  : boxed_row {
    : text {  
      label = "DESCRIPTION:" ;
      width = 25 ;
    }
    : text {  
      label = "QTY:";
    }
    : text {  
      label = "PRICE:";
    }
    : text {  
      label = "TOTAL:" ;
    }
  }
  : column { 
    children_alignment = right ;
    : row {
      children_fixed_width = true ;
      : text {
        label = "AStruct! Frame Analysis   " ;
      }
      : edit_box {
        edit_limit = 3 ;
        edit_width = 3 ;
        value = "1" ;
        key = "qty1" ;
      }
      : text {
        label = "$89.00" ;
      }
      : text {
        value = "$89.00" ;
        key = "tot1" ;
        width = 10 ;
      }
    }
    : text {
      label = "Software for AutoCAD" ;
    }
    : row {
      children_fixed_width = true ;
      : text {
        label = "AStruct! Stand-Alone Frame" ;
      }
      : edit_box {
        edit_limit = 3 ;
        edit_width = 3 ;
        value = "0" ;
        key = "qty2" ;
      }
      : text {
        label = "$59.00" ;
      }
      : text {
        value = "$0.00" ;
        key = "tot2" ;
        width = 10 ;
      }
    }
    : text {
      label = "Analysis program." ;
    }
    : row {
      children_fixed_width = true ;
      : toggle {
        key = "tax" ;
        label = "Washington State Residents add 8.2%" ;
      }
      : text {
        key = "vat" ;
        value = "$0.00" ;
        width = 10 ;
      }
    }
    : row {
      children_fixed_width = true ;
      : text {
        label = "Shipping and Handling ($15 outside US):" ;
      }
      : text {
        key = "sh" ;
        value = "$5.00" ;
        width = 10 ;
      }  
    }
    : row {
      children_fixed_width = true ;
      : text {
        label = "TOTAL (US):" ;
      }
      : text {
         key = "total" ;
        value = "$94.00" ;
        width = 10 ;
      }
    }
  } 
  ok_cancel_help_errtile ;
}
