;;;   ASMENU.LSP
;;;   Copyright (C) 1992-94 by Autodesk, Inc.
;;;   Version 1.1 for Release 12 DOS, Unix, and Windows (12/7/93)
;;;
;;;   Permission to use, copy, modify, and distribute this software
;;;   for any purpose and without fee is hereby granted, provided
;;;   that the above copyright notice appears in all copies and that
;;;   both that copyright notice and this permission notice appear in
;;;   all supporting documentation.
;;;
;;;   THIS SOFTWARE IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED
;;;   WARRANTY.  ALL IMPLIED WARRANTIES OF FITNESS FOR ANY PARTICULAR
;;;   PURPOSE AND OF MERCHANTABILITY ARE HEREBY DISCLAIMED.
;;;
;;;   Note:  This file is loaded automatically by ASTRUCT.MNL at the start
;;;          of each editing session.  It establishes an autoloader and
;;;          other utility functions.

;;;=== General Utility Functions ===

(defun *merr* (msg)
  (setq *error* m:err m:err nil)
  (princ)
)

(defun *merrmsg* (msg)
  (princ msg)
  (setq *error* m:err m:err nil)
  (princ)
)

;;;=== ASE Functions ===

;;;  AI_ASEGREY is used to enable/disable the ASE items in the "File" (POP1)
;;;  pulldown menu, based on whether ASE has been loaded.  If you move
;;;  "File" to a different pulldown menu, change the "P1" string
;;;  accordingly.  If you add items to the "File" menu prior to the "->ASE"
;;;  item, adjust the "base" value accordingly.

(defun ai_asegrey (action / base)

  ;; Identify "->ASE" item number
  (setq base (if (= (getvar "platform") "Microsoft Windows")
                 (list "P1" 10)
                 (list "P1" 9)
             )
  )

  (foreach a '(2   4 5   7 8   10 11 12   14 15   17 18 19 20  21 22 23 24
               25 26 27 28 29  30 31 32 33  34 35 36 37 38  39 40   42)
    (menucmd (strcat (car base) "." (itoa (+ (cadr base) a)) "=" action))
  )
  (if (= action "~")
    (setq ai_aseinit_yet nil)
  )
  (setq action (if (= action "~") " " "~"))  ; Invert action for "Initialize"
  (menucmd (strcat (car base) "." (itoa (+ 1 (cadr base))) "=" action))
)

(defun ai_bitmaps ()                  ; used only for Windows
  (princ "\nLoading menu bitmaps...")
  (foreach a '(5 6 7 8)
    (menucmd (strcat "p" (itoa a) "=p" (itoa a) "bitmaps"))
  )
  (ai_redo_grey)
)

(defun ai_text ()                     ; used only for Windows
  (princ "\nUnloading menu bitmaps...")
  (foreach a '(5 6 7 8)
    (menucmd (strcat "p" (itoa a) "=p" (itoa a) "text"))
  )
  (ai_redo_grey)
)

(defun ai_redo_grey ()                ; used only for Windows
  (if (not ai_aseinit_yet) (ai_asegrey "~") (ai_asegrey " "))
  (if ai_isamegrey (ai_amegrey "~") (ai_amegrey " "))
  (princ)
)

(defun ai_aseinit_chk ()
  (menucmd "S=X")
  (if ai_aseinit_yet
    (menucmd "S=ASE")
    (menucmd "S=ASEINIT0")
  )
  (princ)
)

(defun ai_aseinit ()
  (setq m:err *error* *error* *merrmsg*)
  (if (= nil c:aseinit)
    (progn
      (princ "\nAutoCAD SQL Extension")
      (if (and (or (/= nil (findfile "ase"))
                   (/= nil (findfile "ase.exp"))
                   (/= nil (findfile "ase.exe"))
               )
               (/= nil (findfile "ase.lsp"))
          )
        (progn
          (xload "ase")
          (load "ase.lsp")
          (ai_asegrey " ")
          (menucmd "S=X")
          (menucmd "S=ASE")
          (setq ai_aseinit_yet T)
          (princ " loaded.")
          (c:aseinit)
        )
        (progn
          (princ " not loaded.")
          (princ "\nThe ASE files were not found in your search path directories.")
          (princ "\nCheck the installation of the SQL Extension and try again.")
        )
      )
    )
    (progn
      (ai_asegrey " ")
      (menucmd "S=X")
      (menucmd "S=ASE")
      (if (not ai_aseinit_yet)
        (progn
          (if (findfile "ase.lsp")
            (load "ase.lsp")
            (princ "\nASE.LSP not found.  'Quick' commands not available.")
          )
          (c:aseinit)
        )
      )
      (setq ai_aseinit_yet T)
    )
  )
  (setq *error* m:err m:err nil)
  (princ)
)

(defun ai_aseterm ()
  (setq m:err *error* *error* *merrmsg*)
  (if (= ase_errno 0)
    (progn
      (xunload "ase")
      (ai_asegrey "~")
      (menucmd "S=X")
      (menucmd "S=S")
      (princ "\nAutoCAD SQL Extension unloaded.")
    )
  )
  (setq *error* m:err m:err nil)
  (princ)
)

;;	Okay, now for the AStruct! menu manipulation
;;
;;

(defun astruct_init ()
  (setq m:err *error* *error* *merrmsg*)
  (princ "\nAStruct! Frame Analysis")
  (if (= nil c:asinfo)
    (progn
      (if (/= nil (findfile "ASTRUCT.EXP"))
        (progn
          (xload "ASTRUCT.EXP")
          (astructgrey " ")
          (princ " loaded.")
        )
        (progn
          (princ " not loaded.")
          (princ "\nThe AStruct! files were not found in your search path directories.")
          (princ "\nCheck the installation of AStruct! and try again.")
        )
      )
    )
    (progn
      (princ " is already loaded!")
      (astructgrey " ")
    )
  )
  (setq *error* m:err m:err nil)
  (princ)
)

(defun astruct_term ()
  (setq m:err *error* *error* *merrmsg*)
  (princ "\nAStruct! Frame Analysis")
  (astructgrey "~")
  (if (= nil c:asinfo)
    (princ " hasn't been loaded.")
    (progn
      (xunload "astruct")
      (princ " unloaded.")
    )
  )
  (setq *error* m:err m:err nil)
  (princ)
)

(defun astructgrey (action / base)

  ;; Identify top of "ASTRUCT" menu
  (setq base (list "P16" 0))

  (foreach a '(1 3 6 8 10 11 21 25 30 32)
    (menucmd (strcat (car base) "." (itoa (+ (cadr base) a)) "=" action))
  )
  (setq action (if (= action "~") " " "~"))
  (menucmd (strcat (car base) "." (itoa (+ 5 (cadr base))) "=" action))
)

;;; ===== AutoLoad =====

(defun _autoqload (quoi app cmdliste / qapp symnam)
  (setq qapp (strcat "\"" app "\""))
  (mapcar
   '(lambda (cmd / nom_cmd)
      (progn
        (setq nom_cmd (strcat "C:" cmd))
        (if (not (eval (read nom_cmd)))
            (eval
             (read (strcat
                    "(defun " nom_cmd "( / rtn)"
                    "(setq m:err *error* *error* *merrmsg*)"
                    "(if (ai_ffile " qapp ")"
                    "(progn (princ \"\nInitializing...\")"
                    "(_auto" quoi "load " qapp ") (setq rtn (" nom_cmd ")))"
                    "(ai_nofile " qapp "))"
                    "(setq *error* m:err m:err nil)"
                    "rtn)"
                    ))))))
   cmdliste)
  nil
)

(defun autoload (app cmdliste)
  (_autoqload "" app cmdliste)
)

(defun autoxload (app cmdliste)
  (_autoqload "x" app cmdliste)
)

(defun _autoload (app)
; (princ "Auto:(load ") (princ app) (princ ")") (terpri)
  (load app)
)

(defun _autoxload (app)
; (princ "Auto:(xload ") (princ app) (princ ")") (terpri)
  (if (= app "region") (ai_select))
  (xload app)
  (if (= app "region") (ai_amegrey "~"))
)

(defun ai_ffile (app)
  (or (findfile (strcat app ".lsp"))
      (findfile (strcat app ".exp"))
      (findfile (strcat app ".exe"))
      (findfile app)
  )
)

(defun ai_nofile (filename)
  (princ
    (strcat "\nThe file "
            filename
            "(.lsp/.exp/.exe) was not found in your search path directories."
    )
  )
  (princ "\nCheck the installation of the Support Files and try again.")
  (princ)
)


;;;===== AutoLoad LISP Applications =====

(autoload "appload" '("appload"))

(autoload "filter" '("filter"))

(autoload "dline" '("dline" "dl"))

(autoload "3d" '("3d" "ai_box" "ai_pyramid" "ai_wedge" "ai_dome"
                 "ai_mesh" "ai_sphere" "ai_cone" "ai_torus" "ai_dish")
)

(autoload "ddinsert" '("ddinsert"))

(autoload "asctext" '("asctext"))

(autoload "ddattdef" '("ddattdef"))

(autoload "ddattext" '("ddattext"))

(autoload "3darray" '("3darray"))

(autoload "ddmodify" '("ddmodify"))

(autoload "ddchprop" '("ddchprop"))

(autoload "ddview" '("ddview"))

(autoload "ddvpoint" '("ddvpoint"))

(autoload "mvsetup" '("mvsetup"))

(autoload "ddosnap" '("ddosnap"))

(autoload "ddptype" '("ddptype"))

(autoload "dducsp" '("dducsp"))

(autoload "ddunits" '("ddunits"))

(autoload "ddgrips" '("ddgrips"))

(autoload "ddselect" '("ddselect"))

(autoload "ddrename" '("ddrename"))

(autoload "rman_dcl" '("rmmenu"))

(autoload "ddsolprm" '("ddsolprm"))

(autoload "plud" '("plud"))

;;;===== AutoXLoad ADS Applications =====

(autoxload "rasterin" '("gifin" "pcxin" "riaspect" "ribackg"
                        "riedge" "rigamut" "rigrey" "rithresh" "tiffin")
)

(autoxload "geomcal" '("cal"))

(autoxload "geom3d" '("mirror3d" "rotate3d" "align"))

(princ)


