;TIP1214B.LSP:    RAYTR.LSP    Dynamic Ray-tracing   (c)1996, Marlo Johanson

(defun cross (P3 P4 CROSSENT / P1 P2 TP2 TP3 REFLENT)
  (setq TP2 nil)
  (setq QUAN (sslength CROSSENT))
  (while (and (= TP2 nil) (> QUAN 0))
    (setq QUAN (1- QUAN))
    (setq REFLENT (entnext (ssname crossent quan)))
    (setq P2 (cdr (assoc '10 (entget reflent))))
    (setq REFLENT (entnext REFLENT))
    (setq TP3 (cdr (assoc '10 (entget REFLENT))))
    (while (and (= TP2 nil) 
      (/= (cdr (assoc '0 (entget REFLENT))) "SEQEND"))
      (setq P1 P2)
      (setq P2 TP3)
      (setq TP2 (inters P1 P2 P3 P4 T))
      (setq REFLENT (entnext REFLENT))
      (setq TP3 (cdr (assoc '10 (entget REFLENT))))
    )
  )
  (cons (angle P1 P2) TP2)
)
(defun C:RAYTR ()
  (setq WP1 (getpoint "\nLower left corner of surface view: "))
  (setq WP4 (getpoint "\nUpper right corner of surface view: "))
  (setq WP2 (getpoint "\nLower left corner of fixture view: "))
  (setq WP3 (getpoint "\nUpper right corner of fixture view: "))
  (command "zoom" "w" WP1 WP4)
  (prompt "\nDefine lit surface polyline.")
  (setq LITSURF (ssget))
  (command "zoom" "w" WP2 WP3)
  (prompt "\nDefine reflecting surface polyline.")
  (setq REFLSURF (ssget))
  (setq EXIT "F")
  (while (= EXIT "F")
    (setq SP (getpoint "\nSource point: "))
    (command "zoom" "p" "" "p")
    (if (= SP nil) (setq EXIT "T"))
    (while (/= SP nil) 
      (setq TP1 SP TP4 SP EP SP RP SP IP SP TP SP)
      (setq CODE 5 TRACK "T")
      (while (= CODE 5)
        (grdraw SP EP -1)
        (setq EP TP1)
        (grdraw SP EP -1)
        (setq TP2 (cross SP EP REFLSURF))
        (setq RANGLE (car TP2) TP2 (cdr TP2))
        (if (/= TP2 nil) 
          (progn
            (setq SANGLE (angle EP SP))
            (setq IANGLE (- SANGLE (* 2.0 (- SANGLE (+ RANGLE 1.5708)))))
            (setq MP (polar TP2 IANGLE 1000.0))
            (setq TP3 (cross TP2 MP LITSURF))
            (setq RANGLE (car TP3) TP3 (cdr TP3))
            (if (= TP3 nil) 
              (progn 
                (setq TP2 (polar SP (angle SP EP) (- (distance SP TP2) 0.01)))
                (setq TP3 (cross TP2 MP REFLSURF))
                (setq RANGLE (car TP3) TP3 (cdr TP3))
                (if (/= TP3 nil) 
                  (progn 
                    (setq SANGLE (anGLE MP TP2))
                    (setq IANGLE (- SANGLE (* 2.0 (- SANGLE (+ RANGLE 1.5708)))))
                    (setq MP (polar TP3 IANGLE 1000.0))
                    (setq TP4 (cdr (cross TP3 MP LITSURF)))
                    (if (= TP4 nil)
                      (setq TP4 (polar TP3 IANGLE (distance TP2 TP3)))
                    )
                  )
                  (setq TP3 (polar TP2 IANGLE (distance SP TP2)) TP4 TP3)
                )
              )
              (setq TP4 TP3)
            )
          )
          (setq TP2 SP TP3 SP TP4 SP)
        )
        (grdraw RP IP -1)
        (grdraw IP TP -1)
        (setq RP TP2 IP TP3 TP TP4)
        (grdraw RP IP -1)
        (grdraw IP TP -1)
        (setq GRDATA (grread TRACK))
        (setq CODE (car GRDATA) TP1 (cadr GRDATA))
      )
      (grdraw SP RP -1)
      (grdraw RP IP -1)
      (grdraw IP TP -1)
      (if (= CODE 3)
        (if (= IP TP)
          (command "pline" sp rp ip "")
          (command "pline" sp rp ip tp "")
        )
        (setq SP nil)
      )
    )
  )
);end raytr.lsp
