;TIP1214C.LSP:    REFL.LSP    Dynamic Ray-tracing   (c)1996, Marlo Johanson

(defun C:REFL ()
  (setq WP1 (getpoint "\nBottom of surface view: "))
  (setq WP4 (getpoint "\nTop of surface view: "))
  (setq WP2 (getpoint "\nBottom of fixture view: "))
  (setq WP3 (getpoint "\nTop of fixture view: "))
  (command "zoom" "w" WP1 WP4)
  (prompt "\nDefine lit surface polyline.")
  (setq LITSURF (ssget))
  (setq SP '(0 0 0))
  (setq LEN 1.0)
  (while (/= SP nil)
    (command "zoom" "W" WP2 WP3)
    (setq SP (getpoint "\nSource point: "))
    (if (/= SP nil) 
      (progn
        (setq RP '(0 0 0))
        (while (/= RP nil)
          (command "zoom" "W" WP1 WP3)
          (setq RP (getpoint SP "\nReflection point: "))
          (if (/= Rp nil) 
            (progn
              (prompt "\nDefine reflector angle and length")
              (setq SDIST (distance SP RP))
              (setq SANGLE (angle RP SP))
              (setq CODE 5 TRACK "T")
              (setq EP RP OP RP BP RP TP1 RP IP RP)
              (grdraw SP RP -1)
              (while (= CODE 5)
                (grdraw OP EP -1)
                (setq EP TP1)
                (setq RANGLE (angle RP EP))
                (grtext -2 (angtos RANGLE 0 2))
                (setq OP (polar RP (+ RANGLE pi) (distance RP EP)))
                (grdraw OP EP -1)
                (setq IANGLE (- SANGLE (* 2.0 (- SANGLE (+ RANGLE 1.5708)))))
                (setq BP (polar RP IANGLE SDIST))
                (setq MP (polar RP IANGLE (* SDIST 50.0)))
                (setq TP2 nil)
                (setq QUAN (sslength LITSURF))
                (while (and (= TP2 nil) (> QUAN 0))
                  (setq QUAN (1- QUAN))
                  (setq LITENT (entnext (ssname LITSURF QUAN)))
                  (setq LP1 (cdr (assoc '10 (entget LITENT))))
                  (setq LITENT (entnext LITENT))
                  (setq LP2 (cdr (assoc '10 (entget LITENT))))
                  (while (and (= TP2 nil) 
                    (/= (cdr (assoc '0 (entget LITENT))) "SEQEND"))
                    (setq TP2 (inters RP MP LP1 LP2 T))
                    (setq LP1 LP2)
                    (setq LITENT (entnext LITENT))
                    (setq LP2 (cdr (assoc '10 (entget LITENT))))
                  )
                )
                (grdraw RP IP -1)
                (if (/= TP2 nil) (setq IP TP2) (setq IP BP))
                (grdraw RP IP -1)
                (setq IDIST (distance RP IP))
                (setq GRDATA (grread TRACK))
                (setq CODE (car GRDATA) TP1 (cadr GRDATA))
              )
              (command)
              (setq TMP (getreal (strcat "\nLength of reflector <"
              (rtos LEN 2 2) ">: ")))
              (if (= TMP nil) (setq TMP LEN))
              (if (>= TMP 0.0) (progn 
                  (setq LEN TMP)
                  (setq TMP (getreal (strcat "\nAngle of reflector <"
                  (angtos rangle 0 2) ">: ")))
                  (grdraw RP IP -1)
                  (if (/= TMP nil) 
                    (progn 
                      (setq RANGLE (* (/= TMP 360) 2 pi))
                      (setq IANGLE(- SANGLE (* 2.0 (- SANGLE (+ RANGLE 1.5708)))))
                      (setq BP (polar RP IANGLE SDIST ))
                      (setq LITENT (entnext LITSURF))
                      (setq LP1 (cdr (assoc '10 (entget LITENT))))
                      (setq LITENT (entnext LITENT))
                      (setq LP2 (cdr (assoc '10 (entget LITENT))))
                      (while (and (= TP2 nil)
                        (/= (cdr (assoc '0 (entget LITENT))) "SEQEND"))
                        (setq TP2 (inters RP (polar RP IANGLE (* SDIST 50.0)) lp1 lp2 T))
                        (setq LP1 LP2)
                        (setq LITENT (entnext LITENT))
                        (setq LP2 (cdr (assoc '10 (entget LITENT))))
                      )
                      (if (/= TP2 nil) (setq IP TP2) (setq IP BP))
                  ))
                  (grdraw SP RP -1)
                  (grdraw OP EP -1)
                  (setq EP (polar RP RANGLE (* LEN 0.5)))
                  (setq OP (polar RP (+ RANGLE pi) (* LEN 0.5)))
                  (command "line" OP EP "")
                  (command "pline" SP RP IP "")
              ))
          ))
        )
    ))
  )
  (command "zoom" "p")
);end refl.lsp













