;TIP1214A.LSP:    RAYDR.LSP    Dynamic Ray-tracing     (c)1996, Marlo Johanson

(defun cross (P3 P4 CROSSENT / P1 P2 TP2 TP3 REFLENT)
  (setq TP2 nil)
  (setq QUAN (sslength CROSSENT))
  (while (and (= TP2 nil) (> QUAN 0))
    (setq QUAN (1- QUAN))
    (setq REFLENT (entnext (ssname crossent quan)))
    (setq P2 (cdr (assoc '10 (entget reflent))))
    (setq REFLENT (entnext REFLENT))
    (setq TP3 (cdr (assoc '10 (entget REFLENT))))
    (while (and (= TP2 nil) 
      (/= (cdr (assoc '0 (entget REFLENT))) "SEQEND"))
      (setq P1 P2)
      (setq P2 TP3)
      (setq TP2 (inters P1 P2 P3 P4 T))
      (setq REFLENT (entnext REFLENT))
      (setq TP3 (cdr (assoc '10 (entget REFLENT))))
    )
  )
  (cons (angle P1 P2) TP2)
)
(defun C:RAYDR ()
  (setq WP1 (getpoint "\nLower left corner of surface view: "))
  (setq WP4 (getpoint "\nUpper right corner of surface view: "))
  (setq WP2 (getpoint "\nLower left corner of fixture view: "))
  (setq WP3 (getpoint "\nUpper right corner of fixture view: "))
  (command "zoom" "w" WP1  WP4)
  (prompt "\nChoose lit surface polylines.")
  (setq LITSURF (ssget))
  (command "zoom" "w" WP2  WP3)
  (prompt "\nChoose reflecting surface polylines.")
  (setq REFLSURF (ssget))
  (setq SP (getpoint "\nPick source point: "))
  (setq PANGLE (/ (* 2.0 pi) 90))
  (setq XANGLE 0)
  (setq INDEX 91)
  (setq CM_ORG (getvar "CMDECHO"))  
  (setvar "CMDECHO" 0) 
  (while (> INDEX 0)
    (setq INDEX (1- INDEX))
    (setq XANGLE (+ XANGLE PANGLE))
    (setq EP (polar SP XANGLE 1000.0)) 
    (setq TP0 (cross SP EP REFLSURF))
    (setq TANGLE0 (car TP0) TP0 (cdr TP0))
    (setq TP1 (cross SP EP LITSURF))
    (setq TANGLE1 (car TP1) TP1 (cdr TP1))
    (if (or (/= TP0 nil) (/= TP1 nil))
      (progn
        (if (= TP0 nil) (setq TP0 '(8000 8000 0)))
        (if (= TP1 nil) (setq TP1 '(8000 8000 0)))
        (if (< (distance SP TP0) (distance SP TP1))
          (progn
            (setq AP (polar SP (angle SP EP) (- (distance SP TP0) 0.001)))
            (setq SANGLE (angle EP SP))
            (setq IANGLE (- SANGLE (* 2.0 (- SANGLE (+ TANGLE0 1.5708)))))
            (setq EP (polar AP IANGLE 1000.0))
            (setq TP0 (cross AP EP REFLSURF))
            (setq TANGLE0 (car TP0) TP0 (cdr TP0))
            (setq TP1 (cross AP EP LITSURF))
            (setq TANGLE1 (car TP1) TP1 (cdr TP1))
            (if (or (/= TP0 nil) (/= TP1 nil))
              (progn
                (if (= TP0 nil) (setq TP0 '(8000 8000 0)))
                (if (= TP1 nil) (setq TP1 '(8000 8000 0)))
                (if (< (distance AP TP0) (distance AP TP1))
                  (progn
                    (setq BP (polar AP (angle AP EP) (- (distance AP TP0) 0.001)))
                    (setq SANGLE (angle EP AP))
                    (setq IANGLE (- SANGLE (* 2.0 (- SANGLE (+ TANGLE0 1.5708)))))
                    (setq EP (polar BP IANGLE 1000.0))
                    (setq TP1 (cross BP EP LITSURF))
                    (setq TANGLE1 (car TP1) TP1 (cdr TP1))
                    (if (/= TP1 nil)
                      (command "pline" SP AP BP TP1 "")
                      (command "pline" SP AP BP (polar BP IANGLE 4) "")
                    )
                  )
                  (command "pline" SP AP TP1 "")
                )
              )
              (command "pline" SP AP (polar AP IANGLE 4) "")
            )
          )
          (command "pline" SP TP1 "")
        )
      )
      (command "pline" SP (polar SP XANGLE 4.0) "")
    )
  )
  (command "zoom" "p" "" "p")
  (setvar "CMDECHO" CM_ORG) 
);end raydr.lsp
