;TIP1211A.LSP:    LTP.LSP    Change Linetype    (c)1996, Sam Lerman 

(defun dxf (FLD ELST)
  (cdr (assoc FLD ELST))
)

(defun rd_ltp (LNE / S CNT)
  (setq L "" S "" CNT 0)
  (while (/= S ",")
    (setq L (strcat L S))
    (setq S (substr LNE (setq CNT (+ 1 CNT)) 1))
    (if (not S) (setq S ","))
  )
  L
)

(defun ltlst (FLE / F FLE LST LN)
  (setq F (open (findfile FLE) "r") LST nil)
  (setq LN t)
  (while LN 
    (setq LN (read-line F))
    (if LN
      (setq LST (cond
          ((and (not LST) (/= (substr LN 1 1) "*")) nil)
          ((and LST (/= (substr LN 1 1) "*")) LST)
          (t (cons (RD_LTP (substr LN 2)) LST))
        )
      )
    )
  )
  (close F)
  (setq LST (cons "CONTINUOUS" LST))
  (reverse LST)
)

(defun acad_ltp (LAR LTP ID / ID ATTYP)
  (defun upd_ltp ()
    (setq LTP (nth (atoi ATTYP) LTP_LIST))
    (done_dialog)
  )
  (defun upd_til ()
    (start_list "ltpe")
    (mapcar 'add_list LTP_LIST)
    (end_list)
    (SET_TILE "ltpe" attyp)

  )
  (if (not ID)
    (setq ID (load_dialog "Ltp.dcl"))
  )
  (if (not LTP_LIST)
    ;;;If you use linetypes file different than ACAD.LIN,
    ;;;change the "ACAD.LIN" in the next row to your file name
    (setq LTP_LIST (acad_strlsort (ltlst "acad.lin")))
  )
  (if (not (member LTP LTP_LIST))
    (setq LTP_LIST (acad_strlsort (cons LTP LTP_LIST)))
  )
  (setq attyp (itoa (- (length LTP_LIST)
    (length (member LTP LTP_LIST))))
  )  
  (IF (new_dialog "ltp" id)
    (progn
      (start_list "ltpe")
      (mapcar 'add_list LTP_LIST)
      (end_list)
      (set_tile "ltpe" attyp)
      (set_tile "lr_name" lar)
      (action_tile "ltpe" "(setq attyp $value)(upd_til)")
      (action_tile "accept" "(upd_ltp)")
      (action_tile "cancel" "(done_dialog)")
      (START_DIALOG)
      ltp
    )
  )
) 

(defun C:CHLTPL ( / S1 OLEXP OLLTYP CHLR NLTYP)
  (setvar "cmdecho" 0)
  (setq OLEXP (getvar "expert"))
  (setq S1 t)
  (while S1
    (setq S1 (entsel "\nSelect entity on layer: "))
    (if S1
      (progn
        (setq OLLTP 
          (cdr 
            (assoc 6 
              (tblsearch "Layer" 
                (setq CHLR 
                  (dxf 8 
                    (entget (car S1)
                    )
                  )
                )
              )
            )
          )
        )
        (setq NLTYP (acad_ltp CHLR OLLTP nil))
        (if (= nil (tblsearch "ltype" NLTYP))
          (progn
            (setvar "expert" 3)
            (command "linetype" "l" NLTYP "/acad/acad" "")
          )
        )
        (command "layer" "lt" NLTYP CHLR "")
      )
    )
  )
  (setvar "expert" OLEXP)
  (princ)
)

(defun C:CHLTP ( / S1 OLEXP OLLTYP ELST NLTYP)
  (setvar "cmdecho" 0)
  (setq OLEXP (getvar "expert"))
  (setq S1 t)
  (while S1
    (setq S1 (entsel "\nSelect entity: "))
    (if S1
      (progn
        (setq OLLTP 
          (cond
            ((not (dxf 6 (setq ELST (entget (car S1))))) (cdr (assoc 6 (tblsearch "Layer" (setq CHLR (dxf 8 ELST))))))
            (t (dxf 6 ELST))
          )
        )
        (setq NLTYP (acad_ltp " " OLLTP nil))
        (if (= nil (tblsearch "ltype" nltyp))
          (progn
            (setvar "expert" 3)
            (command "linetype" "l" NLTYP "/acad/acad" "")
          )
        )
        (command "_chprop" (dxf -1 ELST) "" "lt" NLTYP "")
      )
    )
  )
  (setvar "expert" OLEXP)
  (princ)
);end ltp.lsp
