// Next available MSG number is    54 
// MODULE_ID DDVIEW_DCL_
/* Next available MSG number is  61 */

//----------------------------------------------------------------------------
//
//     ddview.dcl
//
//     Copyright (C) 1992, 1994 by Autodesk, Inc.
//
//     Permission to use, copy, modify, and distribute this software
//     for any purpose and without fee is hereby granted, provided
//     that the above copyright notice appears in all copies and
//     that both that copyright notice and the limited warranty and
//     restricted rights notice below appear in all supporting
//     documentation.
//
//     AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
//     AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
//     MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
//     DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
//     UNINTERRUPTED OR ERROR FREE.
//
//     Use, duplication, or disclosure by the U.S. Government is subject to
//     restrictions set forth in FAR 52.227-19 (Commercial Computer
//     Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
//     (Rights in Technical Data and Computer Software), as applicable.
//
//     Modified by Phil Kreiker, Looking Glass Microproduct,
//     to remove "Restore" button, and allow double-clicking 
//     on list box and new view name.
//.
//----------------------------------------------------------------------------
//
//  Dialogue interface to VIEW command.  Used with DDVIEW.LSP
//
//----------------------------------------------------------------------------

//dcl_settings : default_dcl_settings { audit_level = 3; }

view : dialog {
    label = "View Control";
    initial_focus = "edit_view";
    : list_box {
        label = "Views";
        mnemonic = "V";
        width = 42;
        tabs = "34";
        key = "list_view";
        tab_truncate = true;
        allow_accept = true;
    }
    : concatenation {
        : text_part {
            label = "Restore View: ";
        }
        : text_part {
            key = "res_text";
            width = 32;
        }
    }
    : row {
        : button {
            label = "New...";
            mnemonic = "N";
            key = "new_view";
        }
        : button {
            label = "Delete";
            mnemonic = "D";
            key = "delete";
        }
        : button {
            label = "Description...";
            mnemonic = "e";
            key = "describe";
        }
    }
    spacer_0;
    ok_cancel_help;
}

new_view : dialog {
    label = "Define New View";
    : edit_box {
        key = "new_view_name";
        allow_accept = true;
        label = "New Name:";
        mnemonic = "N";
        edit_width = 26;
    }
    : radio_column {
        : radio_button {
            label = "Current Display";
            mnemonic = "C";
            key = "r_current";
        }
        : radio_button {
            label = "Define Window";
            mnemonic = "D";
            key = "r_window";
        }
    }
    : button {
        label = "Window <";
        mnemonic = "W";
        width = 10;
        key = "window";
        horizontal_alignment = left;
        fixed_width = true;
    }
    : row {
        : boxed_column {
            label = "First Corner";
            key = "fc";
            : concatenation {
                : text_part {
                    label = "X: ";
                    key = "x1_label";
                }
                : text_part {
                    key = "x1_text";
                    width = 10;
                }
            }
            : concatenation {
                : text_part {
                    label = "Y: ";
                    key = "y1_label";
                }
                : text_part {
                    key = "y1_text";
                    width = 10;
                }
            }
        }
        : boxed_column {
            label = "Other Corner";
            key = "oc";
            : concatenation {
                : text_part {
                    label = "X: ";
                    key = "x2_label";
                }
                : text_part {
                    key = "x2_text";
                    width = 10;
                }
            }
            : concatenation {
                : text_part {
                    label = "Y: ";
                    key = "y2_label";
                }
                : text_part {
                    key = "y2_text";
                    width = 10;
                }
            }
        }
    }
    : row {
        fixed_width = true;
        alignment = centered;
        : button {
            label = "Save View";
            mnemonic = "S";
            key = "save_view";
            fixed_width = true;
            is_default = true;
        }
        : spacer { width = 2; }
        cancel_button;
    }
    errtile;
}


valert : dialog {
    label = "Alert";
    : paragraph {
        : text_part {
            label = "A View with this name already exists in this";
        }
        : text_part {
            label = "drawing.  Do you want to redefine it?";
        }
    }
    : row {
        fixed_width = true;
        alignment = centered;
        : button {
            label           = "Redefine";
            key             = "accept";
            mnemonic        = "R";
            is_default      = true;
            width           = 8;
        }
        : spacer {
            width = 2;
        }
        : button {
            label           = "Cancel";
            key             = "cancel";
            mnemonic        = "C";
            is_cancel       = true;
            width           = 6;
        }
    }
}

vinquiry : dialog {
    label = "View Description";
    : concatenation {
        : text {
            label = "View Name:";
        }
        : text {
            key = "v_name";
            width = 31;
        }
    }
    spacer_1;
    : row {
        : row {
            : column {
                spacer_1;
                : text {
                    label = "Width:";
                }
                : text {
                    label = "Height:";
                }
                : text {
                    label = "Twist:";
                }
            }
            : column {
                spacer_1;
                : text {
                    key = "v_width";
                    width = 10;
                }
                : text {
                    key = "v_height";
                    width = 10;
                }
                : text {
                    key = "v_twist";
                    width = 10;
                }
            }
        }
        spacer_1;
        : column {
            : text {
                key = "cen_tar";
                width = 15;
            } 
            : concatenation {
                : text_part {
                    label = "X: ";
                }
                : text_part {
                    key = "vtar_x";
                    width = 10;
                }
            }
            : concatenation {
                : text_part {
                    label = "Y: ";
                }
                : text_part {
                    key = "vtar_y";
                    width = 10;
                }
            }
            : concatenation {
                : text_part {
                    label = "Z: ";
                }
                : text_part {
                    key = "vtar_z";
                    width = 10;
                }
            }
        }
        : column {
            : text {
                key = "direction";
                width = 15;
            } 
            : concatenation {
                : text_part {
                    label = "X: ";
                }
                : text_part {
                    key = "vdir_x";
                    width = 10;
                }
            }
            : concatenation {
                : text_part {
                    label = "Y: ";
                }
                : text_part {
                    key = "vdir_y";
                    width = 10;
                }
            }
            : concatenation {
                : text_part {
                    label = "Z: ";
                }
                : text_part {
                    key = "vdir_z";
                    width = 10;
                }
            }
        }
    }
    spacer_1;
    : row {
        children_fixed_width = true;
        : column {
            : row {
                : column {
                    : text {
                        label = "Perspective:";
                    }
                    : text {
                        label = "Front Clipping:";
                    }
                    : text {
                        label = "Back Clipping:";
                    }
                }
                : column {
                    : text {
                        key = "persp";
                        width = 4;
                    }
                    : text {
                        key = "fclipon";
                        width = 4;
                    }
                    : text {
                        key = "bclipon";
                        width = 4;
                    }
                }
            }
        }
        : column {
            children_fixed_width = true;
            : row {
                : column {
                    : text {
                        label = "Lens Length:";
                    }
                    : text {
                        label = "Offset:";
                    }
                    : text {
                        label = "Offset:";
                    }
                }
                : column {
                    : text {
                        key = "lens";
                        width = 8;
                    }
                    : text {
                        key = "fclip";
                        width = 8;
                    }
                    : text {
                        key = "bclip";
                        width = 8;
                    }
                }
            }
        }
    }
    spacer_1;
    ok_only;
}



