; TIP1097.LSP: DDARRAY.LSP   Dialog Box for Array   (c)1995,  Ken Leseberg

;;  The companion ".dcl" routine required is "DDARRAY.DCL".

;;  Set up the defaults function.
(defun defaults ()             

   (set_tile "x_pt" x_pt)        
   (set_tile "y_pt" y_pt)
   (set_tile "z_pt" z_pt)

   (set_tile "how_many"
      (if (/= selection_set nil)
         (rtos (sslength selection_set) 2 0)
      "0" )
   )              

   (setq n_temp (atoi n_items))
   (setq n_items (rtos n_temp 2 0))
   (set_tile "n_items" n_items)

   (set_tile "fill_deg" fill_deg)

   (if (= 0 rot_item)
      (set_tile "rot_item" "0")
      (progn
         (set_tile "rot_item" "1")
         (setq rot_item 1)
      )
   )

   (if (= 0 pol_rect)
      (set_tile "rect" "1")
      ()
   )

   (if (= 1 pol_rect)
      (set_tile "polr" "1")
      ()
   )

   (setq r_temp (atoi rows))
   (setq rows (rtos r_temp 2 0)) 
   (set_tile "rows" rows)

   (setq c_temp (atoi cols))
   (setq cols (rtos c_temp 2 0))
   (set_tile "cols" cols)

   (set_tile "r_dist" r_dist)
   (set_tile "c_dist" c_dist)
)                                  
;;  End of defaults function.

;;  Set up the p_switch function.
(defun p_switch ()
   (setq pol_rect 1)
   (mode_tile "pick_pt" 0)
   (mode_tile "pick_xy" 1)   
   (mode_tile "x_pt" 0)   
   (mode_tile "y_pt" 0)
   (mode_tile "z_pt" 0)
   (mode_tile "n_items" 0)
   (mode_tile "fill_deg" 0)
   (mode_tile "rot_item" 0)
   (mode_tile "rows" 1)
   (mode_tile "cols" 1)
   (mode_tile "r_dist" 1)
   (mode_tile "c_dist" 1)
)
;;  End of the p_switch function.

;;  Set up the r_switch function.
(defun r_switch ()
   (setq pol_rect 0)
   (mode_tile "pick_pt" 1)
   (mode_tile "pick_xy" 0)   
   (mode_tile "x_pt" 1)   
   (mode_tile "y_pt" 1)
   (mode_tile "z_pt" 1)
   (mode_tile "n_items" 1)
   (mode_tile "fill_deg" 1)
   (mode_tile "rot_item" 1)
   (mode_tile "rows" 0)
   (mode_tile "cols" 0)
   (mode_tile "r_dist" 0)
   (mode_tile "c_dist" 0)
)
;;  End of the r_switch function.


;;  Set up the run_it function.

(defun run_it ()

   (if (< (setq dcl_id (load_dialog "ddarray.dcl")) 0) (exit))

   (setq x_pt "0.0")           ; initialize various items for the
   (setq y_pt "0.0")           ; first time that the dialog box is used.
   (setq z_pt "0.0")           ; x, y, & z all = 0.
   (setq n_items "4")          ; polar array for 4 items.
   (setq fill_deg "360.00")    ; polar array for fill of 360 degress.
   (setq rot_item 1)           ; rotate items during polar array.
   (setq rows "2")             ; 2 rows for rectangular array.
   (setq cols "2")             ; 2 columns for rectangular array.
   (setq r_dist "0.0")         ; row distance = 0
   (setq c_dist "0.0")         ; column distance = 0
   (setq pol_rect 1)           ; start dialog as polar array.
   (setq selection_set nil)   
   (setq what_next 5)         

   (while (< 2 what_next)
      (if (not (new_dialog "ddarray" dcl_id)) (exit))

      (defaults)

      (if (= 1 pol_rect)        ;  If statement used to enable / disable
         (p_switch)              ;  tiles the first time through.  Also 
         (r_switch)              ;  runs thru here each time thru loop.
      )                         ;  End of "if" statement.

      (action_tile "pick_pt"    "(done_dialog 4)")
      (action_tile "sel_objs"   "(done_dialog 3)")
      (action_tile "pick_xy"    "(done_dialog 6)")
      (action_tile "x_pt"       "(setq x_pt $value)")         
      (action_tile "y_pt"       "(setq y_pt $value)")       
      (action_tile "z_pt"       "(setq z_pt $value)")
      (action_tile "n_items"    "(setq n_items $value)")       
      (action_tile "fill_deg"   "(setq fill_deg $value)")   
      (action_tile "rot_item"   "(setq rot_item (atoi $value))")
      (action_tile "rows"       "(setq rows $value)")
      (action_tile "cols"       "(setq cols $value)")
      (action_tile "r_dist"     "(setq r_dist $value)")
      (action_tile "c_dist"     "(setq c_dist $value)")
      (action_tile "polr"       "(p_switch)")
      (action_tile "rect"       "(r_switch)")

      (setq what_next (start_dialog))       ; Throw up the dialogue.

      (cond                                 ; Decide what to do next.
         ;; If select objects was picked...
         ((= what_next 3)
            (setq selection_set (ssget))
            (setq ssflag 1)
         )

         ;; If pick to show x,y row and column distances...
         ((= what_next 6)
            (initget 1)
            (setq pick_1st (getpoint "Pick first point: "))
            (setq pick_2nd (getcorner pick_1st "Pick second point: "))
            (setq r_dist (rtos (- (cadr pick_2nd) (cadr pick_1st)) 2 4))
            (setq c_dist (rtos (- (car pick_2nd) (car pick_1st)) 2 4))
         )

         ;; If the base point was picked...
         ((= what_next 4)
            (initget 1)
            (setq pick_pt (getpoint "Polar array base point: "))
            (setq x_pt (rtos (car pick_pt) 2 4))
            (setq y_pt (rtos (cadr pick_pt) 2 4))
            (setq z_pt (rtos (caddr pick_pt) 2 4))
         )
      )                                  ; end of decide "cond" 
   )                                     ; end of while loop. 

   (action_tile "accept"    "(done_dialog)")

   (start_dialog)
   (unload_dialog dcl_id)
)                                       
;; end of run_it function.


;; Set up the MAIN FUNCTION

(defun C:DDARRAY (/ x_pt y_pt z_pt n_items fill_deg rot_item rows cols
      r_dist c_dist pol_rect selection_set what_next
   how_many pick_pt n_temp r_temp c_temp y_or_n )

   (setq scmde (getvar "cmdecho"))
   (setvar "cmdecho" 0)
   (run_it)   
   (defaults)    ;  After exiting dialog, run the default function here
   ;  to force input for rows, cols, n_items, etc. to integer.

   ;  IF / AND statement to only allow array command access
   ;  IF OK was picked AND the selection_set was not nil.
   (if (and (= 1 what_next) (/= selection_set nil))  
      (if (= 1 pol_rect)
         (progn
            (if (= 1 rot_item)
               (setq y_or_n "y")
               (setq y_or_n "n")
            )
            (setq pick_pt (list (atof x_pt) (atof y_pt) (atof z_pt)))
            (command "array" "prev" "" "p" pick_pt n_items fill_deg y_or_n)
         )
         (progn
            (if (= "1" rows)
               (command "array" "prev" "" "r" rows cols c_dist)
            )
            (if (= "1" cols)
               (command "array" "prev" "" "r" rows cols r_dist)
            )
            (if (and (/= "1" rows) (/= "1" cols))
               (command "array" "prev" "" "r" rows cols r_dist c_dist)
            )
         )
      )                     ; end of pol_rect if statement.
      ()                       ; end of what_next = 1 'OK' and 
   )                        ; end of selection_set /= nil if statements. 
   (setvar "cmdecho" scmde)
   (princ)
)
;; End of the main function.
