; TIP1096.LSP:  CUT.LSP    Cookie Cutter     (c)1995, Joe Stillman

;       NOTE: Due to the limitation in Windows of only two mouse buttons, 
;       you must press the 'C', 'c', or <Enter> key to initiate the cut. 

;            J.L. Stillman, Wick Fisher White
;       This function will cut a small window out of
;       a larger drawing.  A draggable cookie cutter
;       shows the extent of the window to be cut.  The
;       cookie cutter can be sized to an A size sheet,
;       B size sheet or WINDOW'ed to a user size.  The
;       cutter can be scaled (as in ZOOM D) or rotated.
;       Once the cutter is positioned, pressing RETURN or C
;       will TRIM all of the TRIMmable entities crossing
;       the window's edge.  A WBLOCK of everything
;       CROSSING the window is then written to a user
;       specified file.  Finally, UNDO automatically returns
;       the parent drawing to its original state.


(defun c:cut(/ N PR S XSZ YSZ I J LOOPING SCALOOPING
               P P0 P1 P2 P4 PP XL XH YL YH)
(defun cerror(MSG)
   (princ "error: ")
   (princ MSG)
   (setq *error* olderr)
   (redraw)
   (princ)
 )

 (setq olderr *error* *error* cerror)
 (princ (setq PR "A size/B size/Rotate/Scale/Window/<Cut>"))
 (setq S (getvar "DIMSCALE"))
 (setq XSZ 3.8125 YSZ 4.5625)
 (setq J 0 P0 nil LOOPING 1)
 (setvar "CMDECHO" 0)

 (while LOOPING
  (cond ((= J 2) (keyinput))
        ((= J 3) (scale))
        ((= J 5) (track))
        ((= J 6) (buttons))
  ); cond
  (setq I (grread 1 4 1) J (car I))
 ); while
 (setq *error* olderr)
 (redraw)
 (princ)
); defun

(defun keyinput(/ N)
 (if PP (progn
  (setq N (cadr I))
  (cond ((or (= N 65) (= N 97)) (asize))
        ((or (= N 66) (= N 98)) (bsize))
        ((or (= N 32) (= N 13) (= N 67) (= N 99)) (clip))
        ((or (= N 82) (= N 114)) (rotate))
        ((or (= N 83) (= N 115)) (setq I (grread 1 4 1)) (scale))
        ((or (= N 87) (= N 119)) (windo))
        ((= N 27) (princ "\nFunction cancelled") (setq LOOPING nil))
  ); cond
 )); progn, if
); defun

(defun scale(/ SCALOOPING YANCHOR ANCHORPT)
 (princ "\nIndicate scale point:")
 (setq SCALOOPING 1
       YANCHOR (cadr PP)
       ANCHORPT (list (car P1) YANCHOR)
       P0 nil
 )
 (drawbox PP)
 (while SCALOOPING
   (setq PP (cadr I))
    (if (not (equal P0 PP)) (progn
        (if P0 (progn
          (drawscbox P0)
          (setq ANCHORPT (list (car P1) (cadr PP))
                S (/ (distance PP ANCHORPT) XSZ))
          )); progn, if
        (drawscbox PP)
        (setq P0 PP)
        )); progn, if
    (setq I (grread 1 4 1) J (car I))
  (if (= J 3) (setq SCALOOPING nil))
 ); while
 (drawscbox PP)
 (setq P0 nil)
 (princ (strcat "\n" PR))
); defun

(defun track()
    (setq PP (cadr I))
    (if (not (equal P0 PP)) (progn
        (if P0 (drawbox P0))
        (drawbox PP)
        (setq P0 PP)
        )); progn, if
); defun

(defun buttons()
  (setq N (cadr I))
  (cond ((= N 0) (clip))
        ((= N 1) (princ))
        ((= N 2) (princ "\nFunction cancelled") (setq LOOPING nil))
  ); cond
)

(defun asize()
 (drawbox PP)
 (setq P0 nil XSZ 3.8125 YSZ 4.5625 S (getvar "DIMSCALE"))
 (princ "A size sheet selected\N")
 (princ PR)
)

(defun bsize()
 (drawbox PP)
 (setq P0 nil XSZ 7.5626 YSZ 5.0625 S (getvar "DIMSCALE"))
 (princ "B size sheet selected\N")
 (princ PR)
)

(defun windo(/ XPA YPA XPP YPP WINDOLOOPING)
 (drawbox PP)
 (setq WINDOLOOPING 1
       ANCHORPT (getpoint "\nFirst corner:")
       XPA (car ANCHORPT) YPA (cadr ANCHORPT)
       XSZ 0.0 YSZ 0.0
       S (getvar "DIMSCALE")
 )
 (setq I (grread 1 4 1) J (car I))
 (princ "Second corner:")
 (while WINDOLOOPING
   (setq PP (cadr I)
         XPP (car PP) YPP (cadr PP)
   )
    (if (not (equal P0 PP)) (progn
        (drawwbox P0)
        (setq XSZ (/ (- XPA XPP) S)
              YSZ (/ (- YPA YPP) S)
        )
        (drawwbox PP)
        (setq P0 PP)
        )); progn, if
    (setq I (grread 1 4 1) J (car I))
  (if (= J 3) (setq WINDOLOOPING nil P0 nil))
 ); while
 (drawwbox PP)
 (princ (strcat "\n" PR))
); defun

(defun rotate(/ SWAP)
 (princ " Rotating...\N")
 (drawbox PP)
 (setq SWAP XSZ XSZ YSZ YSZ SWAP)
 (drawbox PP)
 (princ PR)
)

(defun drawbox(P / X Y XP YP PX1 PX2 PX3 PX4 PXL PXH PYL PYH)
  (setq X (abs (* XSZ S))
        Y (abs (* YSZ S))
        XP (car P) YP (cadr P)
        P1 (list (setq XL (- XP X)) (setq YH (+ YP Y)))
        P2 (list (setq XH (+ XP X)) YH)
        P3 (list XH (setq YL (- YP Y)))
        P4 (list XL YL)
        PX1 (list (setq PXL (- XP (setq DS (/ (getvar "DIMSCALE") 4.0))))
                  (setq PYH (+ YP DS)))
        PX2 (list (setq PXH (+ XP DS)) (setq PYL (- YP DS)))
        PX3 (list PXH PYH)
        PX4 (list PXL PYL)
  )
  (grdraw P1 P2 -1)
  (grdraw P2 P3 -1)
  (grdraw P3 P4 -1)
  (grdraw P4 P1 -1)
  (grdraw PX1 PX2 -1)
  (grdraw PX3 PX4 -1)
)

(defun drawscbox(P / DS X Y XP YP PA1 PA2 PA3 PA4)
  (setq X (abs (* XSZ S))
        Y (abs (* YSZ S))
        XP (car P) YP (cadr P)
        P1 (list (setq XL (- XP X)) (setq YH (+ YP Y)))
        P2 (list (setq XH (+ XP X)) YH)
        P3 (list XH (setq YL (- YP Y)))
        P4 (list XL YL)
        PA1 (list XH YP)
        PA2 (list (- XH (setq DS (/ (getvar "DIMSCALE") 2.0))) YP)
        PA3 (polar PA1 (* 5 (/ PI 4.0)) DS)
        PA4 (polar PA1 (* 3 (/ PI 4.0)) DS)
  )
  (grdraw P1 P2 -1)
  (grdraw P2 P3 -1)
  (grdraw P3 P4 -1)
  (grdraw P4 P1 -1)
  (grdraw PA2 PA1 -1)
  (grdraw PA3 PA1 -1)
  (grdraw PA4 PA1 -1)
)

(defun drawwbox(P / X Y XP YP P1 P2 P3 P4)
  (setq X (abs (* XSZ S))
        Y (abs (* YSZ S))
        XP (car P) YP (cadr P)
        P1 (list (setq XL (- XP X)) (setq YH (+ YP Y)))
        P2 (list (setq XH (+ XP X)) YH)
        P3 (list XH (setq YL (- YP Y)))
        P4 (list XL YL)
  )
  (grdraw P1 P2 -1)
  (grdraw P2 P3 -1)
  (grdraw P3 P4 -1)
  (grdraw P4 P1 -1)
)

(defun clip(/ A45 CRP1 CRP2 CRP3 CRP4 CRSET TL BRKSET EN E T FN
              FNUM FP1 FP2 FP3 FP4 DWGFN BLOCKSET HAP QAP)
  (setq HAP (/ (getvar "APERTURE") 2.0)
        QAP (/ (getvar "APERTURE") 4.0)
        A45 (/ PI 4.0)
        FP1 (polar P1 (* 3.0 A45) HAP)
        FP2 (polar P2 A45 HAP)
        FP3 (polar P3 (* 7.0 A45) HAP)
        FP4 (polar P4 (* 5.0 A45) HAP)
        CRP1 (polar P1 (* 3.0 A45) QAP)
        CRP2 (polar P2 A45 QAP)
        CRP3 (polar P3 (* 7.0 A45) QAP)
        CRP4 (polar P4 (* 5.0 A45) QAP)
        CRSET (ssget "F" (list CRP1 CRP2 CRP3 CRP4 CRP1))
  )
  (command "UNDO" "M")
  (command "PLINE" P1 "W" 0.0 0.0 P2 P3 P4 P1 "")
  (setq TL (entlast))

  (while CRSET
    (cutit)
    (setq CRSET (ssget "F" (list CRP1 CRP2 CRP3 CRP4 CRP1)
                            '((-4 . "<NOT")
                               (-4 . "<OR")
                                 (0 . "SOLID")
                                 (0 . "POINT")
                                 (0 . "TRACE")
                                 (0 . "ATTRIB")
                                 (0 .  "ATTDEF")
                                 (0 . "INSERT")
                                 (0 . "TEXT")
                               (-4 . "OR>")
                             (-4 . "NOT>")
                            ); filter out untrimmable entities
    )); ssget, setq
  ); while
  (entdel TL)
  (command "SELECT"  "")
  (setq BLOCKSET (ssget "C" P1 P3)
        FN (getstring "\nFile name: ")
        DWGFN (strcat FN ".dwg")
  )
  (setq FNUM (open DWGFN "w"))
  (close FNUM)
  (command "WBLOCK" FN "Y" "" P3 BLOCKSET "")
  (command "UNDO" "END" "UNDO" "B")
  (princ)
  (setq LOOPING nil)
)                                       ; defun clip

(defun cutit()
  (command "TRIM" TL ""
           "F" FP1 FP2 ""
           "F" FP2 FP3 ""
           "F" FP3 FP4 ""
           "F" FP4 FP1 "" ""
  ); command
)
