; TIP1094.LSP:  ARROW.LSP    Arrowheads    (c)1995, Stephen R. Schneider

(defun SRSERR (S)                     
   ;C  while this command is active...
   (if (/= S "Function cancelled")
      (princ (strcat "\nError: " s))
   )                                  
   (setvar "CMDECHO" OCE)             
   (setvar "OSMODE" OSM)              
   (setq *ERROR* OLDERR)              
   (princ)
);defun srserr 


(defun C:UHEAD (/ OLDERR *ERROR* OCE OSM DIMS PT1 )
   (prompt "C:UHEAD... Inserts ARROW block pointing up. (osnap end,int active)")
   (setq OLDERR *ERROR*)        
   (setq *ERROR* SRSERR)
   (setq OCE (getvar "CMDECHO"))         ;  store present cmddia value
   (setq OSM (getvar "OSMODE"))          ;  store present osnap mode
   (setvar "CMDECHO" 0)                  ;  to run cleanly
   (command "osnap" "end,int")           ;  Command used for user customization
   (setq DIMS (getvar "dimscale"))

   (while                     
      (setq PT1 (getpoint "\nPick, type insert point or Return to exit: "))  
      (command "insert" "arrow" PT1) (command DIMS "" 270)
   );while
   (princ)

   (setvar "CMDECHO" OCE)              ;C  restore old cmdecho value
   (setvar "OSMODE" OSM)               ;   restore old osnap mode
   (setq *ERROR* OLDERR)               ;C  restore old *error* handler
   (princ)
);defun uhead
(princ)
;********************************************************************
;This function inserts a down arrow head with user pick . SRS 6-22-94

(defun c:dhead (/ olderr *error* oce osm dims pt1 )
   (prompt "C:DHEAD... Inserts ARROW block pointing down. (osnap end,int active)")
   (setq OLDERR *ERROR*)        
   (setq *ERROR* SRSERR)
   (setq OCE (getvar "CMDECHO"))         ;  store present cmddia value
   (setq OSM (getvar "OSMODE"))          ;  store present osnap mode
   (setvar "CMDECHO" 0)                  ;  to run cleanly
   (command "osnap" "end,int")           ;  Command used for user customization
   (setq DIMS (getvar "dimscale"))

   (while                     
      (setq PT1 (getpoint "\nPick, type insert point or Return to exit: "))  
      (command "insert" "arrow" PT1) (command DIMS "" 90)
   );while
   (princ)

   (setvar "CMDECHO" OCE)              ;C  restore old cmdecho value
   (setvar "OSMODE" OSM)               ;   restore old osnap mode
   (setq *ERROR* OLDERR)               ;C  restore old *error* handler
   (princ)
);defun dhead
(princ)
;********************************************************************
;This function inserts a left arrow head with user pick . SRS 6-22-94

(defun C:LHEAD (/ OLDERR *ERROR* OCE OSM DIMS PT1 )
   (prompt "C:LHEAD... Inserts ARROW block pointing left. (osnap end,int active)")
   (setq OLDERR *ERROR*)        
   (setq *ERROR* SRSERR)
   (setq OCE (getvar "CMDECHO"))         ;  store present cmddia value
   (setq OSM (getvar "OSMODE"))          ;  store present osnap mode
   (setvar "CMDECHO" 0)                  ;  to run cleanly
   (command "osnap" "end,int")           ;  Command used for user customization
   (setq DIMS (getvar "dimscale"))

   (while                     
      (setq PT1 (getpoint "\nPick, type insert point or Return to exit: "))  
      (command "insert" "arrow" PT1) (command DIMS "" 0)
   );while
   (princ)

   (setvar "CMDECHO" OCE)              ;C  restore old cmdecho value
   (setvar "OSMODE" OSM)               ;   restore old osnap mode
   (setq *ERROR* OLDERR)               ;C  restore old *error* handler
   (princ)
);defun lhead
(princ)
;****************************************************************
;This function inserts an arrow head with user pick . SRS 6-22-94

(defun C:RHEAD (/ OLDERR *ERROR* OCE OSM DIMS PT1 )
   (prompt "C:RHEAD... Inserts ARROW block pointing right. (osnap end,int active)")
   (setq OLDERR *ERROR*)        
   (setq *ERROR* SRSERR)
   (setq OCE (getvar "CMDECHO"))         ;  store present cmddia value
   (setq OSM (getvar "OSMODE"))          ;  store present osnap mode
   (setvar "cmdecho" 0)                  ;  to run cleanly
   (command "osnap" "end,int")           ;  Command used for user customization
   (setq DIMS (getvar "dimscale"))

   (while                     
      (setq PT1 (getpoint "\nPick, type insert point or Return to exit: "))  
      (command "insert" "arrow" PT1) (command DIMS "" 180)
   );while
   (princ)

   (setvar "CMDECHO" OCE)              ;C  restore old cmdecho value
   (setvar "OSMODE" OSM)               ;   restore old osnap mode
   (setq *ERROR* OLDERR)               ;C  restore old *error* handler
   (princ)
);defun rhead
(princ)
;*****************************************************************
;This function inserts a scalable rotatable arrow head SRS 6-22-94

(defun BIWERR (S)
   (if (/= s "Function cancelled")   ;C If an error (such as CTRL-C) occurs
      (princ (strcat "\nError: " S)) ;C while this command is active...
   )
   (setvar "CMDECHO" CEO)
   (setvar "OSMODE" OSM)
   (setq *ERROR* OLDERR)             ;C Restore old *error* handler
   (princ)
)
; ------- Start of Main Program ----------------------------------------------
(defun C:SHEAD ()
   (setq OLDERR  *ERROR*             ;C Initialize variables
   *ERROR* BIWERR)
   (setq CEO (getvar "CMDECHO"))
   (setq OSM (getvar "OSMODE"))
   (command "CMDECHO" "0") (terpri)(terpri)
   (command "osnap" "end,int")
   (prompt "Enter scale relative to standard arrowhead< ") 
   (princ (getvar "userr1"))
   (setq PD (getreal ">:  "))
   (if (= PD nil)
      (setq PD (getvar "USERR1" ))
      (setvar "USERR1" PD)
   )  
   (terpri)
   (if (= PD  1.0)
      (progn
         (setq SCAD  (* (getvar "userr1") (getvar "dimscale")))
         (setq PT1  (getpoint "\nEnter or pick insert point (END and INT osnap active for 1st pick; NEA for 2nd pick): "))
         (command "insert" "arrow" PT1 SCAD "" "NEA" pause) 
      );progn
      (progn
         (setq SCAD  (* (getvar "userr1") (getvar "dimscale")))
         (setq PT1  (getpoint "\nEnter or pick insert point (END and INT osnap active for 1st pick; NEA for 2nd pick): "))
         (command "insert" "*arrow" PT1 SCAD  "NEA" pause)
         (command "chprop" "l" "" "la" (getvar "clayer") "")
      );progn
   );if
   (princ)

   (setvar "CMDECHO" CEO)
   (setvar "OSMODE"  OSM)
   (setq *ERROR* OLDERR)             ;C Restore old *error* handler
   (princ)
);defun
(princ "\nType Uhead (up arrow), Dhead (down arrow), Lhead (left arrow), Rhead (right arrow), or Shead (scale arrow). ")
(princ);end of Arrow.lsp
