;
;  ALS - Copyright (C) 1993-1995  by Brad Bylls
;
;This routine is for changing sheet/layer
;	using the data in "ALS.DAT"
;	If the layer does not exist, it is created
;	and then becomes the current layer. If it is a different
;	sheet number, the old sheet is frozen and the new sheet thawed.
;
(defun layermgt ()
  (setq tclay nil laynotes nil cl (getvar "clayer") commaloc 1 nl "" nextcomma 1)
  (setq filnam (findfile "als.dat"))
  (setq lf (open filnam "r"))
  (while (setq mll (read-line lf))
    (while (/= (substr mll commaloc 1) ",")
      (setq commaloc (1+ commaloc))
    )
    (setq ml (strcase (substr mll 1 (1- commaloc))))
    (setq tclay (cons ml tclay) nextcomma (1+ commaloc))
    (while (/= (substr mll nextcomma 1) ",")
      (setq nextcomma (1+ nextcomma))
    )
    (setq mlll (strcase (substr mll (1+ commaloc) (- nextcomma commaloc 1))))
    (setq laynotes (cons mlll laynotes) commaloc 1 nextcomma commaloc)
  )
  (close lf)
  (setq ml "")
  (setq dcl_id (load_dialog "Als.dcl"))
  (if(not(new_dialog "als" dcl_id))(exit))
  (start_list "names")
  (mapcar 'add_list laynotes)
  (end_list)
  (setq ml "")
  (action_tile "one" "(setq nl(strcat nl \"1\"))")
  (action_tile "two" "(setq nl(strcat nl \"2\"))")
  (action_tile "three" "(setq nl(strcat nl \"3\"))")
  (action_tile "four" "(setq nl(strcat nl \"4\"))")
  (action_tile "five" "(setq nl(strcat nl \"5\"))")
  (action_tile "six" "(setq nl(strcat nl \"6\"))")
  (action_tile "seven" "(setq nl(strcat nl \"7\"))")
  (action_tile "eight" "(setq nl(strcat nl \"8\"))")
  (action_tile "nine" "(setq nl(strcat nl \"9\"))")
  (action_tile "zero" "(setq nl(strcat nl \"0\"))")
  (action_tile "names" "(setq NL(strcat nl(nth(atoi $value)tclay)))(done_dialog 1)")
  (action_tile "accept" "(done_dialog 1)")
  (action_tile "cancel" "(done_dialog 0)")
  (setq what_next (start_dialog))
  (unload_dialog dcl_id)
)
;
;
(defun c:als ()
  (layermgt)
  (if (= NL "") (setq NL CL))
  (if (> (ascii (substr nl 2 1)) 64) (setq NL(strcat "0" NL)))
  (setq CLS (substr CL 1 2)) (setq NLS (substr NL 1 2))
  (if (= (tblsearch "LAYER" NL) nil) (layermake))
  (if (= NLS CLS) (command "LAYER" "S" NL "")
    (progn
      (if (> (atoi (substr NL 1 2)) 00)
        (progn
          (if (= (atoi (substr CL 1 2)) 00)
            (command "LAYER" "T" (strcat NLS "*") "S" NL "")
          (command "LAYER" "T" (strcat NLS "*") "S" NL "F" (strcat CLS "*") ""))
          (setq CL NL)
        )
      )
      (if (= (atoi (substr NL 1 2)) 00)
        (command "LAYER" "S" NL "")
      )
    )
  )
  (menucmd "s=")
  (princ)
)
;
;
(defun layermake ()
  (setq filnam (findfile "als.dat"))
  (setq LF (open filnam "r"))
  (while (/= (substr NL 3) ML)
    (setq MLL (read-line LF)
      LNL (- (strlen NL) 2)
      ML (strcase (substr MLL 1 LNL))
    )
  )
  (setq LF (close LF) commaloc 1)
  (while (/= (substr mll commaloc 1) ",")
    (setq commaloc (1+ commaloc))
  )
  (setq nextcomma (1+ commaloc))
  (while (/= (substr mll nextcomma 1) ",")
    (setq nextcomma (1+ nextcomma))
  )
  (command "LAYER" "N" NL
    "C" (substr MLL (1+ nextcomma) 3) NL
    "L" (substr MLL (+ nextcomma 5)) NL ""
  )
)
(defun c:alscopy ( / sset1)
  (princ "\nSelect objects to copy. ")
  (menucmd "s=x")(menucmd "s=sobjects")
  (setq sset1 (ssget))
  (if (= sset1 nil) (^C))
  (command "copy" sset1 "" "0,0,0" "0,0,0")(princ)
  (progn
    (setq clay (prompt "\nName of layer to change object(s) to? "))
    (layermgt)
    (if (> (ascii (substr nl 2 1)) 64) (setq NL(strcat "0" NL)))
    (setq clay nl)
    (if (and (= clay "") (/= nil cclay))(setq clay cclay)(setq cclay clay))
  );End of PROGN.
  (if (or (= clay nil)(= clay ""))(progn (princ "No layer name specified.")(^C)))
  (if (= nil (tblsearch "layer" clay)) 
    (progn
      (princ (strcat "\nLayer " (strcase clay) " does not exist.")) 
      (initget 6 "Yes No") 
      (if (not yesnolay) (setq yesnolay "Yes")) 
      (setq answr (getkword (strcat "\nDo you want to create it? <" yesnolay ">: ")))
      (if (= answr nil) (setq answr yesnolay))
      ;; Create a new layer
      (if (= "Yes" answr) (layermake)
        (progn
          (command "erase" "P" "")
          (prompt "\nEntities not copied")
        );End of PROGN
      );End of if for YES to create new layer.
    );End of PROGN.
  );End of IF for new layer existance.
  (command "chprop" sset1 "" "layer" clay "")(princ)
  (initget 6 "Yes No") 
  (if (not yesnolay2) (setq yesnolay2 "Yes")) 
  (menucmd "s=x")(menucmd "s=yesno") 
  (setq onlayer (getkword (strcat (strcat "\nLeave layer " (strcase clay) " ON?" ) " <" yesnolay2 ">: ")))
  (if (= onlayer nil)(setq onlayer yesnolay2))(setq yesnolay2 onlayer)
  (if (= onlayer "No")(command "layer" "f" clay "")) 
  (if (= onlayer "Yes")(command "layer" "t" clay "on" clay "")) 
  (menucmd "s=")(menucmd "s=")
  (redraw)(princ)
)

(prompt "\nPlease Wait ... loading ALS ")
(princ)
