				program adi2tek

!				ADI2TEK file   (no extension in filename)
!			input file extension must be .PLT
!			output file extension will be .TEK
!			Jeff Casey    10/24

!			Translates output file from ACAD R10 generic ADI
!			    plotter driver to Tektronix 12bit format.
!			Configure ADI driver to X:  390 dots/in, 10.5in
!			                        Y:  390 dots/in, 7.875in
!			Don't forget to map pen colors (ignored here).

	integer*1 i1
	integer*2 i2, ilen
	character*1 esc, gs
	character*15 f1, f2, file
	logical apen, tpen

	esc  = char(27)
	gs   = char(29)

	narg = nargs()				! get input parameters
	if (narg .ne. 2) call error

	call getarg (int2(1),file,ilen)		! get filename
	if (ilen .lt. 1) call error

	f1(1:ilen) = file(1:ilen)		! open input file
	f1(ilen+1:ilen+5) = '.plt'C
	open (1,file=f1,status='old',iostat=ierr,form='binary')
	if (ierr .ne. 0) call error

	iflen = ilen+4
	f2 = f1					! open output file
	f2(ilen+2:ilen+4) = 'tek'

	write (*,' ('' Generic ADI Plotfile to Tektronix translator.''/
     +	        '' Translating file:  "'',a,''"  to file  "'',a,''".'')')
     +	           f1(1:iflen), f2(1:iflen)

	open (2,file=f2,status='new',iostat=ierr,form='binary')
	if (ierr .ne. 0) then
	  write (*,*)
	  write (*,'('' Output file "'',a,''" exists.'')') f2(1:iflen)
	  write (*,'('' Hit (CR) to overwrite, (^C) to cancel. '',$)')
	  read (*,*)
	  open (2,file=f2,status='old',iostat=ierr,form='binary')
	  if (ierr .ne. 0) call error
	end if

	write (2) gs			! initialize TEK, turn on vector mode
	apen = .false.
	tpen = .false.
	nx = 0
	ny = 0
	lx = 0
	ly = 0

	do while (.true.)                       ! read input
	  read (1,iostat=iend) i1               ! read function
	  if (iend .eq. 1) call eof
	  if (i1 .eq. 1) then			! begin plot (single byte)
	    continue
	  else if (i1 .eq. 2) then		! end plot (single byte)
	    exit
	  else if ((i1 .eq. 3) .or. (i1 .eq. 4)) then  ! (move/draw)
	    apen = .false.		    ! move, pen up      (byte,word,word)
	    if (i1 .eq. 4) apen = .true.    ! draw, pen down    (byte,word,word)
	    read (1,iostat=iend) i2
	    if (iend .eq. 1) call eof
	    nx = i2
	    if (nx .lt. 0) nx = nx + 64*1024
	    read (1,iostat=iend) i2
	    if (iend .eq. 1) call eof
	    ny = i2
	    if (ny .lt. 0) ny = ny + 64*1024
	    if (apen .and. .not. tpen) call plot (lx,ly)
	    if (tpen .and. .not. apen) write (2) gs
	    call plot (nx,ny)
	    tpen = .true.
	    lx = nx
	    ly = ny
	  else if (i1 .eq. 5) then		! newpen (byte,byte)
	    read (1,iostat=iend) i1               ! read function
	    if (iend .eq. 1) call eof
	  else if (i1 .eq. 6) then		! setspeed (byte,byte)
	    read (1,iostat=iend) i1
	    if (iend .eq. 1) call eof
	  else if (i1 .eq. 7) then		! setlinetype (byte byte)
	    read (1,iostat=iend) i1
	    if (iend .eq. 1) call eof
	  else if (i1 .eq. 8) then		! penchange (single byte)
	    continue
	  else if (i1 .eq. 9) then		! abort (single byte)
	    stop 'abort command in ADI file'
	  else
	    write (*,*) 'unknown command in ADI file:  ',i1
	    stop  'abnormal termination.'
	  end if

	end do

	write (2) esc,'[','!','p'
	end


	subroutine eof
	write (*,*) '  '
	write (*,*) 'Abnormal termination - unexpected end of file.'
	write (*,*) '  '
	stop
	return
	end

	subroutine error
	write (*,*) '  '
	write (*,*) 'Intended use:  convert an AutoCAD plotter .PLT file'
	write (*,*) 'into a .TEK (high density tektronix) file.'
	write (*,*) '  '
	write (*,*) 'Configure AutoCAD to Generic ADI driver, 390 DPI,',
     +	                         ' 10.5x7.874 in.'
	write (*,*) '  '
	write (*,*) 'Useage:  ADI2TEK file'
	write (*,*) '   input file extension must be .PLT'
	write (*,*) '   output file extension will be .TEK'
	write (*,*) '  '
	write (*,*) '                   Jeff Casey (last mod 10/24/90)'
	stop ' '
	return
	end

	subroutine plot (nx,ny)
	if (nx .lt. 0) nx = 0
	if (ny .lt. 0) ny = 0
	if (nx .gt. 4095) nx = 4095
	if (ny .gt. 3071) ny = 3071
	write (2) int1(ishft(ny,-7)+32),
     +	          int1(ishft(iand(ny,3),2)+iand(nx,3)+96),
     +	          int1(ishft(iand(ny,124),-2)+96),
     +	          int1(ishft(nx,-7)+32),
     +	          int1(ishft(iand(nx,124),-2)+64)
	return
	end
