(defun C:LINTC (); V1.01
  ; By John S. Burningham, Memphis State University
  ; Draws a line tangent to two circles, from the first
  ; circle in a clockwise direction to the second
  (setvar "CMDECHO" 0)
  (setq BM (getvar "BLIPMODE"))
  (command "BLIPMODE" "OFF")
  (terpri)
  (setq PIC1 (osnap (getpoint "SELECT FIRST CIRCLE (or ARC)      ")"nea"))
  (setq PIC2 (osnap (getpoint "SELECT SECOND CIRCLE (or  ARC) ")"nea"))
  (terpri)
  (setq CEN1 (osnap PIC1 "cen"))
  (setq RAD1 (distance PIC1 CEN1))
  (setq CEN2 (osnap PIC2 "cen"))
  (setq RAD2 (distance PIC2 CEN2))
  (setq CANG (angle CEN1 CEN2))
  (setq CDIST (distance CEN1 CEN2))
  (setq RDIF (abs (- RAD1 RAD2)))
  (if (> (- (expt CDIST 2) (expt RDIF 2)) 0.0) (setq B (sqrt (- (expt CDIST 2) (expt RDIF 2)))) (setq B 0.0))
  (setq TANG (atan (/ B RDIF)))
  (if (< RAD1 RAD2) (setq TANG (- 0.0 TANG)))
  (if (< RAD1 RAD2) (setq CANG (+ CANG PI)))
  (if (= RAD1 RAD2) (= TANG (+ CANG (/ PI 2.0))) (setq TANG (+ TANG CANG)))
  (setq TAN1 (polar CEN1 TANG RAD1))
  (setq TAN2 (polar CEN2 TANG RAD2))
  (if (> B 0.0) (command "LINE" TAN1 TAN2))
  (if (> B 0.0) (command ""))
  (if (= B 0.0) (prompt "***NO TANGENT LINE***"))
  (if (= BM 1) (command "BLIPMODE" "ON"))
  (terpri)
  (setvar "CMDECHO" 1)
  (command)
)
                                                                                                        