;THIS PROGRAM DRAWS A 3D WIDE-FLANGE BEAM AND CLIP ANGLES
;WRITTEN BY TUCKER SWEENEY, STUDENT MSU-B COT (FORMERLY BILLINGS VO-TECH)
;
(DEFUN C:3DBEAM1()
(TEXTSCR)
(PRINC "\n   ")
(PRINC "\n   ")
(PRINC "\n   ")
(PRINC "\n**********")
(PRINC "\n**********")
(PRINC "\n**********")
(PRINC "\n   ")
(PRINC "\n   ")
(PRINC "\n3DBeam1 creates a wide-flange beam and clip anles.")
(PRINC "\n   ")
(PRINC "\nThis program was meant to be used in unison with 3dcolum1.lsp.")
(PRINC "\n   ")
(PRINC "\nYou will want to use vpoint for a good 3d view of the columns' tops.")
(PRINC "\n   ")
(PRINC "\nYou will want to use midpoint to locate tops of steel.")
(PRINC "\n   ")
(PRINC "\nPRESS SPACEBAR TO CLEAR THIS SCREEN.")
(PRINC "\n   ")
(PRINC "\n**********")
(PRINC "\n**********")
(PRINC "\n**********")
(PRINC "\n   ")
(PRINC "\n   ")
(PRINC "\n   ")
(setq n (getstring "\n"))
(GRAPHSCR)

 (SETVAR "CMDECHO" 0)
;INFORMATION GATHERING IS NEXT
  (SETQ P1 (GETPOINT "\nLEFT END CENTER TOP OF STEEL: "))
  (SETQ P3 (GETPOINT "\nRIGHT END CENTER TOP OF STEEL: "))
  (SETQ WT (GETDIST  "\nWEB THICKNESS: "))
  (SETQ WD (GETDIST  "\nWEB DEPTH: "))
  (SETQ FT (GETDIST  "\nFLANGE THICKNESS: "))
  (SETQ FW (GETDIST  "\nFLANGE WIDTH: "))
  (SETQ BH (GETDIST  "\nBEAM CLEARANCE HOLD BACK: "))
  (SETQ AT (GETDIST  "\nANGLE THICKNESS: "))
  (SETQ AB (GETDIST  "\nANGLE LEG ON BEAM: "))
  (SETQ AC (GETDIST  "\nANGLE LEG ON CONNECTING MEMBER: "))
  (SETQ AL (GETDIST  "\nANGLE LENGTH: ")) 
   (SETQ CL (GETVAR "CLAYER"))
   (SETQ J1 (- WD WT))
;FINISHED COLLECTING INFORMATION --- POINT SETTING IS NEXT
   (SETQ P2  (POLAR P1 (DTR 0.0) BH))
   (SETQ P4  (POLAR P3 (DTR 180.0) BH))
    (SETQ BD (DISTANCE P2 P4))
   (SETQ P5  (POLAR P2 (DTR 270.0) (* FW 0.5)))
   (SETQ P6  (POLAR P5 (DTR 90.0) FW))
   (SETQ P7  (POLAR P6 (DTR 0.0) BD))
   (SETQ P8  (POLAR P7 (DTR 270.0) FW))
   (SETQ PA  (POLAR P2 (DTR 90.0) (* FT 0.5)))
   (SETQ PB  (POLAR PA (DTR 270.0) FT))
    (SETQ P19 (LIST (CAR P6) (CADR P6) (- (caddr p6) WT)))
    (SETQ P23 (LIST (CAR P6) (CADR P6) (- (caddr p6) WD)))
    (SETQ P22 (LIST (CAR P6) (CADR P6) (- (caddr p6) J1)))
    (SETQ P20 (LIST (CAR PA) (CADR PA) (- (caddr pA) WT)))
    (SETQ P21 (LIST (CAR PA) (CADR PA) (- (caddr pA) J1)))
    (SETQ P27 (LIST (CAR PB) (CADR PB) (- (caddr pB) WT)))
    (SETQ P26 (LIST (CAR PB) (CADR PB) (- (caddr pB) J1)))
    (SETQ P28 (LIST (CAR P5) (CADR P5) (- (caddr p5) WT)))
    (SETQ P24 (LIST (CAR P5) (CADR P5) (- (caddr p5) WD)))
    (SETQ P25 (LIST (CAR P5) (CADR P5) (- (caddr p5) J1)))
   (SETQ P18 (POLAR P19 (DTR 0.0) BD))
   (SETQ P15 (POLAR P22 (DTR 0.0) BD))
   (SETQ P14 (POLAR P23 (DTR 0.0) BD))
   (SETQ P17 (POLAR P20 (DTR 0.0) BD))
   (SETQ P16 (POLAR P21 (DTR 0.0) BD))
   (SETQ P11 (POLAR P26 (DTR 0.0) BD))
   (SETQ P10 (POLAR P27 (DTR 0.0) BD))
   (SETQ P9  (POLAR P28 (DTR 0.0) BD))
   (SETQ P12 (POLAR P25 (DTR 0.0) BD))
   (SETQ P13 (POLAR P24 (DTR 0.0) BD))
;FINISHED SETTING BEAM POINTS --- DRAWING BEAM NEXT
	(COMMAND "LAYER" "M" "BEAM" "C" "CYAN" "" "")
	(COMMAND "3DFACE" P5 P6 P7 P8 "")
	(COMMAND "3DFACE" P23 P14 P13 P24 "")
	(COMMAND "3DFACE" P6 P19 P18 P7 "")
	(COMMAND "3DFACE" P19 P20 P17 P18 "")
	(COMMAND "3DFACE" P20 P21 P16 P17 "")
	(COMMAND "3DFACE" P21 P22 P15 P16 "")
	(COMMAND "3DFACE" P22 P23 P14 P15 "")
	(COMMAND "3DFACE" P24 P25 P12 P13 "")
	(COMMAND "3DFACE" P25 P26 P11 P12 "")
	(COMMAND "3DFACE" P26 P27 P10 P11 "")
	(COMMAND "3DFACE" P27 P28 P9 P10 "")
	(COMMAND "3DFACE" P28 P5 P8 P9 "")
	(COMMAND "3DFACE" P6 P19 P28 P5 "")
	(COMMAND "3DFACE" P20 P27 P26 P21 "")
	(COMMAND "3DFACE" P23 P22 P25 P24 "")
	(COMMAND "3DFACE" P7 P18 P9 P8 "")
	(COMMAND "3DFACE" P17 P10 P11 P16 "")
	(COMMAND "3DFACE" P15 P14 P13 P12 "")
;END OF THE BEAM DRAWING --- CLIP ANGLES ARE NEXT
;POINT SETTING FOR CLIP ANGLES
    (SETQ J2 (* FT 0.5)) 
    (SETQ J3 (- AB AT))
    (SETQ J4 (- AC AT))
    (SETQ P1A (LIST (CAR P1) (CADR P1) (- (CADDR P1) 1.5)))
    (SETQ A1 (POLAR P1A (DTR 270) J2))
    (SETQ A2 (POLAR A1 (DTR 0) AB))
    (SETQ A3 (POLAR A2 (DTR 270) AT))
    (SETQ A4 (POLAR A3 (DTR 180) J3))
    (SETQ A5 (POLAR A4 (DTR 270) J4))
    (SETQ A6 (POLAR A5 (DTR 180) AT))
     (SETQ A7 (LIST (CAR A1) (CADR A1) (- (CADDR A1) AL)))
     (SETQ A8 (POLAR A7 (DTR 0) AB))
     (SETQ A9 (POLAR A8 (DTR 270) AT))
     (SETQ A10 (POLAR A9 (DTR 180) J3))
     (SETQ A11 (POLAR A10 (DTR 270) J4))
     (SETQ A12 (POLAR A11 (DTR 180) AT))
    (SETQ P3A (LIST (CAR P3) (CADR P3) (- (CADDR P3) 1.5)))
    (SETQ B1 (POLAR P3A (DTR 270) J2))
    (SETQ B2 (POLAR B1 (DTR 180) AB))
    (SETQ B3 (POLAR B2 (DTR 270) AT))
    (SETQ B4 (POLAR B3 (DTR 0) J3))
    (SETQ B5 (POLAR B4 (DTR 270) J4))
    (SETQ B6 (POLAR B5 (DTR 0) AT))
     (SETQ B7 (LIST (CAR B1) (CADR B1) (- (CADDR B1) AL)))
     (SETQ B8 (POLAR B7 (DTR 180) AB))
     (SETQ B9 (POLAR B8 (DTR 270) AT))
     (SETQ B10 (POLAR B9 (DTR 0) J3))
     (SETQ B11 (POLAR B10 (DTR 270) J4))
     (SETQ B12 (POLAR B11 (DTR 0) AT))
    (SETQ C1 (POLAR P1A (DTR 90) J2))
    (SETQ C2 (POLAR C1 (DTR 0) AB))
    (SETQ C3 (POLAR C2 (DTR 90) AT))
    (SETQ C4 (POLAR C3 (DTR 180) J3))
    (SETQ C5 (POLAR C4 (DTR 90) J4))
    (SETQ C6 (POLAR C5 (DTR 180) AT))
     (SETQ C7 (LIST (CAR C1) (CADR C1) (- (CADDR C1) AL)))
     (SETQ C8 (POLAR C7 (DTR 0) AB))
     (SETQ C9 (POLAR C8 (DTR 90) AT))
     (SETQ C10 (POLAR C9 (DTR 180) J3))
     (SETQ C11 (POLAR C10 (DTR 90) J4))
     (SETQ C12 (POLAR C11 (DTR 180) AT))
    (SETQ D1 (POLAR P3A (DTR 90) J2))
    (SETQ D2 (POLAR D1 (DTR 180) AB))
    (SETQ D3 (POLAR D2 (DTR 90) AT))
    (SETQ D4 (POLAR D3 (DTR 0) J3))
    (SETQ D5 (POLAR D4 (DTR 90) J4))
    (SETQ D6 (POLAR D5 (DTR 0) AT))
     (SETQ D7 (LIST (CAR D1) (CADR D1) (- (CADDR D1) AL)))
     (SETQ D8 (POLAR D7 (DTR 180) AB))
     (SETQ D9 (POLAR D8 (DTR 90) AT))
     (SETQ D10 (POLAR D9 (DTR 0) J3))
     (SETQ D11 (POLAR D10 (DTR 90) J4))
     (SETQ D12 (POLAR D11 (DTR 0) AT))
;END OF CLIP ANGLE POINT GETTING --- NOW COMES CLIP ANGLE DRAWING
	  (COMMAND "LAYER" "M" "ANGLE" "C" "RED" "" "")
	  (COMMAND "3DFACE" A1 A2 A3 A4 "")
	  (COMMAND "3DFACE" A1 A4 A5 A6 "")
	  (COMMAND "3DFACE" A5 A6 A12 A11 "")
	  (COMMAND "3DFACE" A2 A3 A9 A8 "")
	  (COMMAND "3DFACE" A7 A8 A9 A10 "")
	  (COMMAND "3DFACE" A7 A10 A11 A12 "")
	  (COMMAND "3DFACE" A3 A4 A10 A9 "")
	  (COMMAND "3DFACE" A4 A5 A11 A10 "")
	  (COMMAND "3DFACE" A1 A6 A12 A7 "")
	  (COMMAND "3DFACE" A1 A2 A8 A7 "")
	   (COMMAND "3DFACE" B1 B2 B3 B4 "")
	   (COMMAND "3DFACE" B1 B4 B5 B6 "")
	   (COMMAND "3DFACE" B5 B6 B12 B11 "")
	   (COMMAND "3DFACE" B2 B3 B9 B8 "")
	   (COMMAND "3DFACE" B7 B8 B9 B10 "")
	   (COMMAND "3DFACE" B7 B10 B11 B12 "")
	   (COMMAND "3DFACE" B3 B4 B10 B9 "")
	   (COMMAND "3DFACE" B4 B5 B11 B10 "")
	   (COMMAND "3DFACE" B1 B6 B12 B7 "")
	   (COMMAND "3DFACE" B1 B2 B8 B7 "")
	  (COMMAND "3DFACE" C1 C2 C3 C4 "")
	  (COMMAND "3DFACE" C1 C4 C5 C6 "")
	  (COMMAND "3DFACE" C5 C6 C12 C11 "")
	  (COMMAND "3DFACE" C2 C3 C9 C8 "")
	  (COMMAND "3DFACE" C7 C8 C9 C10 "")
	  (COMMAND "3DFACE" C7 C10 C11 C12 "")
	  (COMMAND "3DFACE" C3 C4 C10 C9 "")
	  (COMMAND "3DFACE" C4 C5 C11 C10 "")
	  (COMMAND "3DFACE" C1 C6 C12 C7 "")
	  (COMMAND "3DFACE" C1 C2 C8 C7 "")
	   (COMMAND "3DFACE" D1 D2 D3 D4 "")
	   (COMMAND "3DFACE" D1 D4 D5 D6 "")
	   (COMMAND "3DFACE" D5 D6 D12 D11 "")
	   (COMMAND "3DFACE" D2 D3 D9 D8 "")
	   (COMMAND "3DFACE" D7 D8 D9 D10 "")
	   (COMMAND "3DFACE" D7 D10 D11 D12 "")
	   (COMMAND "3DFACE" D3 D4 D10 D9 "")
	   (COMMAND "3DFACE" D4 D5 D11 D10 "")
	   (COMMAND "3DFACE" D1 D6 D12 D7 "")
	   (COMMAND "3DFACE" D1 D2 D8 D7 "")


;END OF PROGRAM
(SETVAR "CLAYER" CL)
)
(DEFUN DTR (A) (* PI (/ A 180.0)))


(PRINC "\n3DBEAM1 CREATES A WIDE FLANGE BEAM AND CLIP ANGLES IN 3D")\
(PRINC)
(PRINC "\nTYPE 3DBEAM1 TO START PROGRAM")
(PRINC)
