//
//              VPECOMON.H
//              ==========
//
// Common definitions for the "Virtual Print Engine"
//
// 01/95 by IDEAL Software, T. Radde
//



#ifndef _MODULE_VPECOMON
#define _MODULE_VPECOMON



// VpeOpenDoc() Flag Parameters:
// =============================
#define VPE_GRID_INBACKGROUND  1        // Grid in Background
#define VPE_GRID_INFOREGROUND  2        // Grid in Foreground
#define VPE_GRID_TOOLBARBUTTON 4        // Grid Toolbar-Button visible
#define VPE_GRID_VISIBLE       8        // Actually Grid visible

#define VPE_NO_RULER           16       // Ruler NOT visible
#define VPE_NO_TOOLBAR         32       // Toolbar NOT visible
#define VPE_NO_USER_CLOSE      64       // User can't close VPE -
                    // Stop-Button INVISIBLE and Sys-Menu
                    // disabled (if not embedded)
                    // VpeCloseDoc() works!
#define VPE_NO_USER_MOVE       128      // User can't leaf through the document
                    // in future: then no Page-Seg in Statusbar
#define VPE_NO_MOUSE_SCALE     256      // User can't scale with the MOUSE (VpeSetScale() works!)
#define VPE_NO_USER_SCALE      (512 | VPE_NO_MOUSE_SCALE)     // User can't scale (VpeSetScale() works!)
                    // in future: then no Scale-Seg in Statusbar

#define VPE_NO_STATBAR        1024      // Statusbar invisible

#define VPE_NO_PRINTBUTTON    2048      // Print-Button invisible
                    // VpePrintDoc() works

#define VPE_EMBEDDED          4096      // Document Window is embedded within
                    // a window of the calling application
#define VPE_LANDSCAPE         8192      // Document will be printed in Landscape-Format
#define VPE_DIRECT_PRINT     16384      // Printer Setup done at VpeOpenDoc,
                    // only one page in Memory, each will be printed
                    // immediately after VpePageBreak (NOT implemented yet!)

#define VPE_GRID_POSSIBLE      (VPE_GRID_INFOREGROUND | VPE_GRID_TOOLBARBUTTON)
#define VPE_GRID_ON            (VPE_GRID_INFOREGROUND | VPE_GRID_TOOLBARBUTTON | VPE_GRID_VISIBLE)
#define VPE_GRID_BKGON         (VPE_GRID_INBACKGROUND | VPE_GRID_TOOLBARBUTTON | VPE_GRID_VISIBLE)
#define VPE_GRID_OFF           0





// VpePreviewDoc() Flag Parameters:
// ===============================
enum
{
   VPE_SHOW_NORMAL = 1,
   VPE_SHOW_MAXIMIZED,
   VPE_SHOW_HIDE,
};





// Text-Formatting Attributes:
// ===========================
enum
{
    ALIGN_LEFT,
    ALIGN_RIGHT,
    ALIGN_CENTER,
    ALIGN_JUSTIFIED,
    ALIGN_PRINT,               // wie ALIGN_LEFT, x2 und y2 werden berechnet
};




// Frame Attributes:
// ================
enum
{
    FRAME_INSIDE,
    FRAME_OUTSIDE,
    FRAME_ONCENTER,
};





// Bild Attribute:
// ===============
#define VPE_PIC_KEEP    1        // keep in memory (don't discard Bitmap after drawing)
#define VPE_PIC_EXACT   2        // draw exact (and slow) to avoid seldom arising pixel-problem
                 // due to wysiwyg coordinate-rounding problem
#define VPE_PIC_MERGE   4        // SRCAND statt SRCCOPY




// ========================================================================
//                        Notification Messages:
// ========================================================================
enum
{
   VPE_DESTROYWINDOW = WM_USER+2306,   // VPE was destroyed
   
   VPE_PRINT,                          // printing: wParam = 1: started
                       //                  = 0: ended
                       // lParam = Doc-Handle
                             
   VPE_PRINTCANCEL,                    // printing: Setup-Dialog aborted
                       // lParam = Doc-Handle
                             
   VPE_HELP,                           // User requests help (NOT implemented yet)
};




// barcode types:
#define BCT_EAN13           1
#define BCT_EAN8            2
#define BCT_UPCA            3
#define BCT_CODABAR         5
#define BCT_CODE39          6
#define BCT_2OF5            7
#define BCT_INTERLEAVED2OF5 8  
#define BCT_UPCE            9
#define BCT_EAN13_2         10
#define BCT_EAN13_5         11
#define BCT_EAN8_2          12
#define BCT_EAN8_5          13
#define BCT_UPCA_2          14
#define BCT_UPCA_5          15
#define BCT_UPCE_2          16
#define BCT_UPCE_5          17
#define BCT_EAN128A         18
#define BCT_EAN128B         19
#define BCT_EAN128C         20
#define BCT_CODE93          21
#define BCT_POSTNET         22



#endif      // _MODULE_VPECOMON
