//
//              VPIFACE.H
//              =========
//
// The DLL-Interface for the "Virtual Print Engine".
//
// To be used by the calling applications.
//
// external Macro-Definitions:
// WINDOWS_DLL     generates Windows DLL-Code, else Windows static library
//
// 11/94 by IDEAL Software, T. Radde
//



#ifndef _MODULE_VPIFACE
#define _MODULE_VPIFACE


#ifdef WINDOWS_DLL
   #define EXPORT    FAR PASCAL _export
#else
   #define EXPORT
#endif   



extern "C"
{
   int  EXPORT VpeGetVersion();
   long EXPORT VpeOpenDoc(HWND hwndParent, char *title, long flags);
   int  EXPORT VpeCloseDoc(long hDoc);
   HWND EXPORT VpeWindowHandle(long hDoc);
   int  EXPORT VpeGetY(long hDoc);
   int  EXPORT VpeGetX(long hDoc);
   void EXPORT VpeSetScale(long hDoc, double scale);
   void EXPORT VpePrintDoc(long hDoc);
   int  EXPORT VpeIsPrinting(long hDoc);
   void EXPORT VpePreviewDoc(long hDoc, RECT *rc, int show_hide);
   void EXPORT VpeSetUpdate(long hDoc, int yes_no);
   void EXPORT VpeRefreshDoc(long h);
   void EXPORT VpeSetPen(long hDoc, int pen_size, int pen_style, COLORREF color);
   void EXPORT VpeNoPen(long hDoc);
   void EXPORT VpeLine(long hDoc, int x, int y, int x2, int y2);
   long EXPORT VpePolyLine(long h, POINT *p, unsigned int size);
   void EXPORT VpeAddPolyPoint(long h, long p,  int x, int y);
   void EXPORT VpeSetBkgColor(long hDoc, COLORREF color);
   void EXPORT VpeSetTransparentMode(long hDoc, int on_off);
   void EXPORT VpeBox(long hDoc, int x, int y, int x2, int y2);
   void EXPORT VpeSetBarcodeParms(long hdoc, int orientation, BYTE top_bottom,
                                   BYTE add_top_bottom);
   void EXPORT VpeBarcode(long h, int x, int y, int x2, int y2, 
                           int code_type, LPSTR code, LPSTR add_code);
   void EXPORT VpeKeepBitmapAspect(long hdoc, int on_off);
   void EXPORT VpeDefaultBitmapDPI(long hdoc, int dpix, int dpiy);
   void EXPORT VpeBitmap(long hDoc, int x, int y, int x2, int y2, LPSTR file_name, int flags);
   void EXPORT VpeSelectFont(long hDoc, char *name, int size);
   void EXPORT VpeSetFontAttr(long hDoc, int alignment, int bold, int underlined, int italic);
   void EXPORT VpeSetAlign(long hDoc, int alignment);
   void EXPORT VpeSetBold(long hDoc, int bold);
   void EXPORT VpeSetUnderlined(long hDoc, int underlined);
   void EXPORT VpeSetItalic(long hDoc, int italic);
   void EXPORT VpeSetTextColor(long hdoc, COLORREF color);
   int  EXPORT VpePrint(long h, int x, int y, char *s);
   int  EXPORT VpePrintBox(long h, int x, int y, char *s);
   int  EXPORT VpeWrite(long h, int x, int y, int x2, int y2, char *s);
   int  EXPORT VpeWriteBox(long hDoc, int x, int y, int x2, int y2, char *s);
   void EXPORT VpeDefineHeader(long hDoc, int x, int y, int x2, int y2, char *s);
   void EXPORT VpeDefineFooter(long hDoc, int x, int y, int x2, int y2, char *s);
   void EXPORT VpePageBreak(long hDoc);
   int  EXPORT VpeGetPageCount(long hdoc);
   int  EXPORT VpeGetCurrentPage(long hDoc);
   void EXPORT VpeGotoPage(long hDoc, int page);
   void EXPORT VpeStoreSet(long hDoc, int id);
   void EXPORT VpeUseSet(long hDoc, int id);
   void EXPORT VpeRemoveSet(long hDoc, int id);
}


#endif          // _MODULE_VPIFACE
