Option Compare Database
Option Explicit

Public Const ATTR_NORMAL = 0
Public Const ATTR_READONLY = 1
Public Const ATTR_HIDDEN = 2
Public Const ATTR_SYSTEM = 4
Public Const ATTR_LABEL = 8
Public Const ATTR_SUBDIR = 16
Public Const ATTR_ARCHIVE = 32

Type FILETIME
    dwLowDateTime As Long
    dwHighDateTime As Long
End Type
Type WIN32_FIND_DATA
    dwFileAttributes As Long
    ftCreationTime As FILETIME
    ftLastAccessTime As FILETIME
    ftLastWriteTime As FILETIME
    nFileSizeHigh As Long
    nFileSizeLow As Long
    dwReserved0 As Long
    dwReserved1 As Long
    cFileName As String * 260
    cAlternateFileName As String * 14
End Type
Type SYSTEMTIME
    wYear As Integer
    wMonth As Integer
    wDayOfWeek As Integer
    wDay As Integer
    wHour As Integer
    wMinute As Integer
    wSecond As Integer
    wMilliseconds As Integer
End Type

Declare Function apiGetDiskFreeSpace& Lib "Kernel32" Alias "GetDiskFreeSpaceA" _
  (ByVal lpRootPathName As String, lpSectorsPerCluster As Long, _
   lpBytesPerSector As Long, lpNumberOfFreeClusters As Long, _
   lpTotalNumberOfClusters As Long)
Declare Function apiFindFirstFile& Lib "Kernel32" Alias "FindFirstFileA" _
  (ByVal lpFileName As String, lpFindFileData As WIN32_FIND_DATA)
Declare Function apiFindNextFile& Lib "Kernel32" Alias "FindNextFileA" _
  (ByVal handle As Long, lpFindFileData As WIN32_FIND_DATA)
Declare Function apiFindClose& Lib "Kernel32" Alias "FindClose" (ByVal handle As Long)
Declare Function apiSetFileTime& Lib "Kernel32" Alias "SetFileTime" _
  (ByVal hFile As Long, lpCreationTime As FILETIME, lpLastAccessTime As FILETIME, _
   lpLastWriteTime As FILETIME)
Declare Function apiSystemTimeToFileTime& Lib "Kernel32" Alias "SystemTimeToFileTime" _
  (lpSystemTime As SYSTEMTIME, lpFileTime As FILETIME)
Declare Function apiFileTimeToSystemTime& Lib "Kernel32" Alias "FileTimeToSystemTime" _
  (lpFileTime As FILETIME, lpSystemTime As SYSTEMTIME)
Declare Function apiCreateFile& Lib "Kernel32" Alias "CreateFileA" _
  (ByVal strFileName As String, ByVal dwDesiredAccess As Long, _
   ByVal dwShareMode As Long, ByVal lpSecurityAttributes As Long, _
   ByVal dwCreationDistribution As Long, ByVal dwFlagsAndAttributes As Long, _
   ByVal hTemplateFile As Long)
Declare Function apiCloseHandle& Lib "Kernel32" Alias "CloseHandle" (ByVal handle As Long)
Function GetFileAttr(strFileName As String) As Integer
    On Error GoTo Err_GetFileAttr
    GetFileAttr = GetAttr(strFileName)
    Exit Function
Err_GetFileAttr:
    Select Case Err
    Case 53:
        GetFileAttr = -2
    Case Else
        GetFileAttr = -5
    End Select
    Exit Function
End Function
Function SetFileAttr(strFileName As String, intAttrib As Integer)
    On Error GoTo Err_SetFileAttr
    SetAttr strFileName, intAttrib
    SetFileAttr = intAttrib
    Exit Function
Err_SetFileAttr:
    Select Case Err
    Case 53:
        SetFileAttr = -2
    Case Else
        SetFileAttr = -5
    End Select
    Exit Function
End Function
Function GetFileSize(strFileName As String)
    On Error Resume Next
    GetFileSize = FileLen(strFileName)
    If Err <> 0 Then GetFileSize = -1
End Function
Function GetDiskFree(nDrive As Integer)
    Dim sec As Long, byt As Long, clu As Long, tot As Long, ret As Long
    Dim drv As String
    If nDrive = 0 Then nDrive = Asc(Mid(CurDir, 1, 1)) - 64
    drv = Chr(nDrive + 64) & ":\"
    ret = apiGetDiskFreeSpace(drv, sec, byt, clu, tot)
    GetDiskFree = clu * sec * byt
    If ret = 0 Then GetDiskFree = -1
End Function
Function GetFileDateTime(strFileName)
    On Error Resume Next
    GetFileDateTime = FileDateTime(strFileName)
    If Err <> 0 Then GetFileDateTime = -1
End Function
Function SetFileDateTime(strFileName As String, intYear, intMonth, intDay, intHour, intMinute, intSecond)
    Dim lngHandle As Long, ret As Long, cc As Long
    Dim st As SYSTEMTIME, ft As FILETIME
    lngHandle = apiCreateFile(strFileName, &H40000000, 0, 0, 3, &HA0, 0)
    cc = 0
    If lngHandle <> -1 Then
        st.wYear = intYear
        st.wMonth = intMonth
        st.wDay = intDay
        st.wHour = intHour
        st.wMinute = intMinute
        st.wSecond = intSecond
        ret = apiSystemTimeToFileTime(st, ft)
        cc = apiSetFileTime(lngHandle, ft, ft, ft)
        If cc <> 0 Then cc = -1
        ret = apiCloseHandle(lngHandle)
    End If
    SetFileDateTime = cc
End Function
Function SetFileDate(strFileName As String, varDate As Variant)
    Dim intYear, intMonth, intDay, intHour, intMinute, intSecond
    intYear = Year(varDate)
    intMonth = Month(varDate)
    intDay = Day(varDate)
    intHour = Hour(varDate)
    intMinute = Minute(varDate)
    intSecond = Second(varDate)
    SetFileDate = SetFileDateTime(strFileName, intYear, intMonth, intDay, intHour, intMinute, intSecond)
End Function
Function DosFindFirst(strFileSpec As String, ffStruct As WIN32_FIND_DATA) As Long
    DosFindFirst = apiFindFirstFile(strFileSpec, ffStruct)
End Function
Function DosFindNext(handle As Long, ffStruct As WIN32_FIND_DATA) As Long
    Dim ret As Long
    DosFindNext = apiFindNextFile(handle, ffStruct)
    If DosFindNext = 0 Then
       ret = apiFindClose(handle)
       DosFindNext = -1
    Else
       DosFindNext = handle
    End If
End Function
Function ConvertDosTime(ftime As FILETIME)
    Dim st As SYSTEMTIME, ret As Long
    ret = apiFileTimeToSystemTime(ftime, st)
    ConvertDosTime = CDate(st.wMonth & "/" & st.wDay & "/" & st.wYear & " " & st.wHour & ":" & st.wMinute & ":" & st.wSecond)
End Function
Function WhereIs(strDirSpec As String, strSpec As String)
    Dim ff As WIN32_FIND_DATA
    Dim lngHandle As Long
    Dim varRetval As Variant
    Dim varTemp As Variant

    'look for subdirectories first
    lngHandle = DosFindFirst(strDirSpec & "*.*", ff)
    Do While (lngHandle <> -1)
        If (ff.dwFileAttributes And ATTR_SUBDIR) And (Left(ff.cFileName, 1) <> ".") Then
            'clean ff.cFileName
            If (InStr(ff.cFileName, Chr(0)) > 0) Then
                varTemp = Left(ff.cFileName, InStr(ff.cFileName, Chr(0)) - 1)
            Else
                varTemp = ff.cFileName
            End If
            varRetval = WhereIs(strDirSpec & varTemp & "\", strSpec)
        End If
        lngHandle = DosFindNext(lngHandle, ff)
    Loop

    'look specifically for a file type
    Debug.Print "Searching " & strDirSpec & strSpec
    lngHandle = DosFindFirst(strDirSpec & strSpec, ff)
    Do While (lngHandle <> -1)
        If Not (ff.dwFileAttributes And ATTR_SUBDIR) Then
            If (InStr(ff.cFileName, Chr(0)) > 0) Then
                varTemp = Left(ff.cFileName, InStr(ff.cFileName, Chr(0)) - 1)
            Else
                varTemp = ff.cFileName
            End If
            Debug.Print varTemp, ConvertDosTime(ff.ftLastWriteTime)
        End If
        lngHandle = DosFindNext(lngHandle, ff)
    Loop
    'allow other things to happen
    DoEvents
End Function
Function TestAttrib()
    ' Print out a list of files in your root
    ' directory, along with the file attribute of each.

    Dim strName As String

    ' Tell Dir we want to see ALL files
    strName = Dir("C:\", vbNormal + vbHidden + vbSystem + vbVolume + vbDirectory)
    Do While strName <> ""
        Debug.Print strName, GetFileAttr("C:\" & strName)
        strName = Dir
    Loop
End Function

