unit Main;
{This program uses the new cross-platform connection model APIs.  It provides a
list of servers the client is attached to.  A server name can then be selected
from the server list and information about the server will be displayed.
Additionally, a list of all users actively attached to the server will be shown.
The user can then select any user and get logintime, network address and node
address.  The DoDiagnostics function is not currently implemented, the transport
api calls have not been ported to Delphi's DCUs.}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls,calcon16,calmis16,clxwin16,calsrv16,ExtCtrls;

type
  TMainForm = class(TForm)
    ListBox1: TListBox;
    ListBox2: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    Memo1: TMemo;
    Label3: TLabel;
    Memo2: TMemo;
    Label4: TLabel;
    Bevel1: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure ListBox2DblClick(Sender: TObject);
  private
    { Private declarations }
  public
    procedure getinfo;
    procedure DoDiagnostics;
    { Public declarations }
  end;

var
  MainForm: TMainForm;
  ConnHandle:NWCONN_HANDLE;
  addr:NWINET_ADDR;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
var
  ccode:NWCCODE;
  lpNULL:nptr;
  scanIterator:nuint32;
  ecode, rcode: NWRCODE;
  connRef:nuint32;
  ConnInfo:NWCCConnInfo;
begin

{First initialize the API calls.}
ccode := NWCallsInit (lpNull,lpNULL);
	if not (ccode=0)then
         ShowMessage('NWCallsInit Failed!!'+#13+'Error Code: '+inttostr(ccode));

{Get the Connection List and store in ListBox1}
scanIterator:=0;
ecode:=0;
while ecode=0 do
begin
  ecode:=NWCCScanConnRefs(@scanIterator, @connRef);
  NWCCOpenConnByRef(connRef,NWCC_OPEN_LICENSED,NULL,@ConnHandle);
         {memset(&ConnInfo,0,sizeof(NWCCConnInfo));}
  ccode:= NWCCGetAllConnInfo(connHandle,NWCC_INFO_VERSION,@ConnInfo);
  if not (ccode=0)then
    ShowMessage('NWCCOpenConnByRef Failed!'+#13+'Error Code: '+inttostr(ccode));
  if ecode=0 then
    listbox1.items.add(strpas(ConnInfo.servername));
  NWCCCloseConn(connHandle);
end;
end;

procedure TMainForm.getinfo;
var
  ccode:NWCCODE;
  ConnInfo:NWCCConnInfo;
  rcode:NWRCODE;
begin

ccode:= NWCCGetAllConnInfo(connHandle,NWCC_INFO_VERSION,@ConnInfo);
	if not (ccode=0)then
          ShowMessage('NWCCOpenConnByRef Failed!'+#13+'Error Code: '+inttostr(rcode));

         {memset(&ConnInfo,0,sizeof(NWCCConnInfo));}
ccode:= NWCCGetAllConnInfo(connHandle,NWCC_INFO_VERSION,@ConnInfo);
       if not(ccode=0)then
          ShowMessage('NWCCGetAllConnInfo Failed!'+#13+'Error Code: '+inttostr(ccode));
       Memo1.Lines.Add('Server Name:'+#9+strpas(ConnInfo.servername));
       if(BOOLEAN(ConnInfo.authenticationState and NWCC_AUTHENT_STATE_NDS))then
          Memo1.Lines.Add('Authentication:'+#9+'NDS')
       else if(BOOLEAN(ConnInfo.authenticationState and NWCC_AUTHENT_STATE_BIND)) then
          Memo1.Lines.Add('Authentication:'+#9+'BINDERY')
       else if(BOOLEAN(ConnInfo.authenticationState = 0))then
          Memo1.Lines.Add('Authentication:'+#9+'NONE')
       else
          Memo1.Lines.Add('Authentication:'+#9+'UNRECOGNIZED');

       if(BOOLEAN(ConnInfo.broadcastState and NWCC_BCAST_PERMIT_SYSTEM))then
          Memo1.Lines.Add('Broadcast State:'+#9+'SYSTEM')
       else if(BOOLEAN(ConnInfo.broadcastState and NWCC_BCAST_PERMIT_NONE))then
          Memo1.Lines.Add('Broadcast State:'+#9+'NONE')
       else if(BOOLEAN(ConnInfo.broadcastState and NWCC_BCAST_PERMIT_POLL))then
          Memo1.Lines.Add('Broadcast State:'+#9+'POLL')
       else if(BOOLEAN(ConnInfo.broadcastState = 0))then
          Memo1.Lines.Add('Broadcast State:'+#9+'PERMIT ALL')
       else
          Memo1.Lines.Add('Broadcast State:'+#9+'UNRECOGNIZED');

       if(ConnInfo.treeName='')then
          Memo1.Lines.Add('Tree Name:'+#9+'NO VALUE DEFINED');

       if(BOOLEAN(ConnInfo.NDSState and NWCC_NDS_NOT_CAPABLE))then
          Memo1.Lines.Add('NDS State:'+#9+'Not Capable')
       else if(BOOLEAN(ConnInfo.NDSState and NWCC_NDS_CAPABLE))then
          Memo1.Lines.Add('NDS State:'+#9+'Capable')
       else
          Memo1.Lines.Add('NDS State:'+#9+'NO VALUE');

       if(BOOLEAN(ConnInfo.licenseState and NWCC_NOT_LICENSED))then
          Memo1.Lines.Add('License State:'+#9+'Not Licensed')
       else if(BOOLEAN(ConnInfo.licenseState and NWCC_CONNECTION_LICENSED))then
          Memo1.Lines.Add('License State:'+#9+'Connection Licensed')
       else if(BOOLEAN(ConnInfo.licenseState and NWCC_HANDLE_LICENSED))then
          Memo1.Lines.Add('Licnese State:'+#9+'Handle Licensed')
       else
          Memo1.Lines.Add('License State:'+#9+#9+'No Value');

       Memo1.Lines.Add('Max Packet Size:'+#9+inttostr(ConnInfo.maxPacketSize));
       Memo1.Lines.Add('Distance:'+#9+#9+inttostr(ConnInfo.distance));
end;

procedure TMainForm.ListBox1DblClick(Sender: TObject);
var
  lpNULL:nptr;
  servername:string;
  serConnString:nstr8;
  nameFormat, openState:nuint;
  ccode:NWCCODE;
  res:nuint;
  majorVer : nuint8;
  minVer : nuint8;
  rev : nuint8;
  maxConns : nuint16;
  maxConnsUsed : nuint16;
  connsInUse : nuint16;
  numVolumes : nuint16;
  SFTLevel : nuint8;
  TTSLevel : nuint8;
  i:integer;
  loginid:array [0..100] of nstr8;
  pObjType : pnuint16;
  pObjID : nuint32;
  pLoginTime : array [0..6] of byte;

begin
    memo2.lines.Clear;
    nameFormat := NWCC_NAME_FORMAT_BIND;   {0x002}
    openState := NWCC_OPEN_UNLICENSED;           { 0x0002 }
    servername:=Listbox1.Items[Listbox1.ItemIndex];
    strpcopy(@serconnstring,servername);
    ccode:=NWCCOpenConnByName(0,@serconnstring,nameFormat,openState,res,@connhandle);
    if not (ccode=0) then
         ShowMessage('WARNING: NWCCOpenConnByName returned:  '+inttostr(ccode));
    ccode := NWGetFileServerInformation (connHandle,@serverName,@majorVer,@minVer,@rev,
         @maxConns,@maxConnsUsed,@connsInUse,@numVolumes,@SFTLevel,@TTSLevel);

    listBox2.Items.Clear;
    for i := 1 to maxconns do
    begin
         ccode:= NWGetConnectionInformation(connHandle,i,@loginid,@pObjType,@pObjID,@pLoginTime);
         if (ccode = 0) and not (inttohex(pObjId,2) = '0L') then
         begin
           listBox2.Items.Add(strpas(loginid)+' '+'('+inttostr(i)+')');
         end;
    end;
    label2.Caption:='Active Connections: '+inttostr(ListBox2.Items.Count);
    memo1.Lines.clear;
    getinfo;
    NWCCCloseConn(connHandle);
    Memo1.Lines.Add('Max Connections:'+#9+inttostr(maxconns));
    Memo1.Lines.Add('NetWare Version:'+#9+inttostr(majorVer)+inttostr(minVer));
    Memo1.Lines.Add('SFT Level:'+#9+inttostr(SFTLevel));

    end;

procedure TMainForm.ListBox2DblClick(Sender: TObject);
var
   Selected: String;
   connNum, startchar, endchar: Integer;
   ccode:NWCCODE;
   loginid:array [0..100] of nstr8;
   pObjType : pnuint16;
   pObjID : nuint32;
   pLoginTime : array [0..6] of byte;

begin
   Memo2.Lines.Clear;
   Selected:=Listbox2.Items[Listbox2.ItemIndex];
   startchar:=Pos('(',Selected);
   endchar:=Pos(')',Selected);
   connNum:=strtoint(Copy(Selected,startchar+1,endchar-startchar-1));

   ccode:= NWGetConnectionInformation(connHandle,connNum,@loginid,@pObjType,@pObjID,@pLoginTime);
   if not(ccode=0) then
      ShowMessage('NWGetConnectionInformation Failed!'+#13+'Error Code: '+inttostr(ccode));
   Memo2.Lines.Add('Login ID:'+#9+#9+strpas(loginid));
   Memo2.Lines.Add('Connection #:'+#9+inttostr(connNum));
   Memo2.Lines.Add('Login Time:'+#9+inttostr(pLoginTime[1])+'\'+inttostr(pLoginTime[2])
   +'\'+inttostr(pLoginTime[0])+' '+inttostr(pLoginTime[3])+':'+inttostr(pLoginTime[4])
   +':'+inttostr(pLoginTime[5]));

   ccode := NWGetInetAddr (connHandle, connNum, addr);
   if not(ccode=0) then
     ShowMessage('NWGetInetAddr Failed!'+#13+'Error Code: '+inttostr(ccode));
   Memo2.Lines.Add('Network Address:'+#9+inttohex(addr.networkAddr[0],2)+inttohex(addr.networkAddr[1],2)
          +inttohex(addr.networkAddr[2],2)+inttohex(addr.networkAddr[3],2));
   Memo2.Lines.Add('Node Address:'+#9+inttohex(addr.netnodeAddr[0],2)+inttohex(addr.netnodeAddr[1],2)
          +inttohex(addr.netnodeAddr[2],2)+inttohex(addr.netnodeAddr[3],2)
          +inttohex(addr.netnodeAddr[4],2)+inttohex(addr.netnodeAddr[5],2));
   Memo2.Lines.Add('Socket Number:'+#9+inttohex(addr.socket,4));
end;

procedure TMainForm.DoDiagnostics;
{This procedure will not work until the transport API set has been converted
to delphi.}
var
   ccode:NWCCODE;
   {idx,cnt:nuint;
   string1:string;
   connHandle:NWCONN_HANDLE;
   i:NWCONN_NUM;
   addr:NWINET_ADDR;
   desintation:BeginDiagnosticStruct;
   diagSocket:WORD;
   componentList:BYTE;
   connectionID:WORD;
   offset:BYTE;
   intvptr:AllResponseData;
   SHELLdata:DriverConfigurationStruct;}

begin

   {memset( &addr, 0, sizeof( addr ) );}

   {memcpy(destination.network, addr.networkAddr, 4);
   memcpy(destination.node, addr.netNodeAddr, 6);
   diagSocket:=0x456;
   memcpy(destination.socket, &diagSocket, 2);

   ccode = BeginDiagnostics(@destination,@connectionID, componentList);
   if not(ccode=0) then
    ShowMessage('BeginDiagnostics Failed!'+#13+'Error Code: '+inttostr(ccode));
   Memo2.Lines.Add('Componet List:'+
   for (idx := 0 to componentList[0] + 1) do
     componentList[idx] );

   offset = (BYTE) FindComponentOffset(componentList, 2);

   {memset( &SHELLdata, 0, sizeof( SHELLdata ) );}
   {ccode =  GetShellDriverConfiguration(connectionID, offset, @intvptr, @SHELLdata);
   if not(ccode=0) then
     ShowMessage('GetShelDriverConfiguration Failed!'+#13+'Error Code: '+inttostr(ccode));

   Memo2.Lines.Add('LAN Description:'+#9+SHELLdata.LANDescription);
   Memo2.Lines.Add('IO Addres:'+#9+SHELLdata.IOAddress1);
   Memo2.Lines.Add('Interrupt Used:'+#9+SHELLdata.interruptLine1);
   Memo2.Lines.Add('Config Description:'+#9+SHELLdata.textDescription);

   EndDiagnostics(connectionID);}
end;

end.
