/****************************************************************************
** DISCLAIMER
**
** Novell, Inc. makes no representations or warranties with respect to
** any NetWare software, and specifically disclaims any express or
** implied warranties of merchantability, title, or fitness for a
** particular purpose.
**
** Distribution of any NetWare software is forbidden without the
** express written consent of Novell, Inc.  Further, Novell reserves
** the right to discontinue distribution of any NetWare software.
**
** Novell is not responsible for lost profits or revenue, loss of use
** of the software, loss of data, costs of re-creating lost data, the
** cost of any substitute equipment or program, or claims by any party
** other than you.  Novell strongly recommends a backup be made before
** any software is installed.   Technical support for this software
** may be provided at the discretion of Novell.
*****************************************************************************
**
** File:   DateTime.c
**
** Desc:   Example program of how to use NWUnpackDateTime() and NWPackDateTime()
**
**         
** Parameter descriptions:    > input
**                            < output
**
**
** Netware API Calls:     
**
**
** Programmers:
** Ini   Who                Firm
** ------------------------------------------------------------------
** ARM   A. Ray Maxwell     Novell Developer Support.
**
** History:
**
** ------------------------------------------------------------------
** 07-29-94   ARM   First code.    
*/

/****************************************************************************
**   Include headers, macros, function prototypes, etc.
*/
   

   /*------------------------------------------------------------------
   **   ANSI
   */
   #include <stdio.h>       /* printf()          */
   #include <stdlib.h>      /* exit()            */
   #include <string.h>      /* strcpy() strupr() */
   #include <dos.h>        /* getdate() gettime() */
  
   /*------------------------------------------------------------------
   **   NetWare
   */
   #define  NWDOS
   #include <nwcalls.h>



   /*------------------------------------------------------------------
   **   Prototypes
   */


   /*-------------------------------------------------------------------
   ** Day parameters.  The bit breakdown on the unsigned wr_date in the
   ** dos.h struct find_t.  two bytes in the following format
   **       YYYYYYYMMMMDDDDD    They are masked with the following defines
   **          7    4   5
   **  The year is figured from 1980.  Thus the 80 for YRSTANDARD.
   */
   #define DAY        0x001F  
   #define MONTH      0x01E0
   #define YEAR       0xFE00
   #define YRSTANDARD 80
   
   /*-------------------------------------------------------------------
   ** Time parameters.  This is the bit breadown of wr_time.
   **       HHHHHMMMMMMSSSSS  They are masked with the following defines.
   **         5     6    5    
   */
   #define MINUTES 0x07E0
   #define SECONDS 0x001F


/****************************************************************************
** Print routine
*/
void main()
{
   struct date d;
   struct time t;
   NW_DATE  nwd;
   NW_TIME  nwt;
   DWORD packedtime;
   WORD timebytes;
   WORD datebytes;

   getdate(&d);
   gettime(&t);

   printf("Date and time before packing > %d/%d/%d   %d:%d:%d\n",
          d.da_mon,
          d.da_day,
          d.da_year,
          t.ti_hour,
          t.ti_min,
          t.ti_sec
         );

   nwd.day   = d.da_day;
   nwd.month = d.da_mon;
   nwd.year  = d.da_year;

   nwt.hours   = t.ti_hour;
   nwt.minutes = t.ti_min;
   nwt.seconds = t.ti_sec;

   packedtime=NWPackDateTime(&nwd,&nwt);

   timebytes = (WORD)packedtime;
   datebytes = packedtime>>16;

printf("Date and time after packing > %2d/%2d/%2d   %2d:%2d:%2d\n",
         (datebytes & MONTH) >> 5,
         (datebytes & DAY),
         (datebytes >> 9)+YRSTANDARD,
         (timebytes >> 11),
         (timebytes & MINUTES) >> 5,
         (timebytes & SECONDS) * 2
         );

   NWUnpackDateTime(packedtime,&nwd,&nwt);

   printf("Date and time after unpacking > %d/%d/%d   %d:%d:%d\n",
           nwd.month,
           nwd.day,
           nwd.year,
           nwt.hours,   
           nwt.minutes, 
           nwt.seconds
           );


}
