/****************************************************************************
**	File:	Screen.C	
**
**	Desc:	Sample SPX chat program.	
**
**			This Sample code demonstrates how to set up and use SPX
**			communications to communicate between 2 nodes.
**		
**		
**		
**
**		DISCLAIMER  
**  
**	Novell, Inc. makes no representations or warranties with respect to
**	any NetWare software, and specifically disclaims any express or
**	implied warranties of merchantability, title, or fitness for a
**	particular purpose.  
**
**	Distribution of any NetWare software is forbidden without the
**	express written consent of Novell, Inc.  Further, Novell reserves
**	the right to discontinue distribution of any NetWare software.
**	
**	Novell is not responsible for lost profits or revenue, loss of use
**	of the software, loss of data, costs of re-creating lost data, the
**	cost of any substitute equipment or program, or claims by any party
**	other than you.  Novell strongly recommends a backup be made before
**	any software is installed.   Technical support for this software
**	may be provided at the discretion of Novell.
**
**	Programmers:
**
**		Ini	Who						Firm
**		-----------------------------------------------------------------------
**		TDOC  Technical Documentation Team
**		KLB	Karl Bunnell				Novell Developer Support.
**
**	History:
**
**		When		Who	What
**		-----------------------------------------------------------------------
**		10-25-88	TDOC	First code.
**		01-27-95 KLB   Ported this example to the NetWare Client SDK
*/

/****************************************************************************
**	Include headers, macros, function prototypes, etc.
*/

	/*------------------------------------------------------------------------
	**	ANSI
	*/
	#include <stdio.h>
	#include <dos.h>


	/*------------------------------------------------------------------------
	**	NetWare
	*/
	#include <nwcalls.h>
	#include "chat.h"

	/*------------------------------------------------------------------------
	**	GLOBALS
	*/


	void 	ClearEndOfLine();
	void 	ClearReceiveBox();
	void 	ClearScreen();
	void 	ClearSendBox();
	void 	CursorOff();
	void 	CursorOn(); 
	void 	DisplayHeadings();
	void 	DrawBorder();
	void 	DrawScreen();
	void 	Error();
	void 	ScrollUp();
	void 	SetCursor();
	void 	Update();
	void 	WriteChar();

	extern int  sendRow,
				sendCol,
				receiveRow,
				receiveCol;

	union	REGS  regs;


void DrawScreen()
{
	ClearScreen();
	DrawBorder();
	DisplayHeadings();
}


void DrawBorder()
{
	int		row,
			col;

	CursorOff();

	for (row = TOP; row <= BOTTOM; row++)
	{
		for (col = LEFT_SIDE; col <= RIGHT_SIDE; col++)
		{
			SetCursor(row,col);
				
	     /* Check for top, bottom, or middle */
			if (row == TOP)
			{
				if (col == LEFT_SIDE) 
					WriteChar(UPPER_LEFT);							
				else if (col == RIGHT_SIDE)
					WriteChar(UPPER_RIGHT);
				else
					WriteChar(HORIZONTAL);
			}
			else if (row == BOTTOM)
			{
				if (col == LEFT_SIDE)
					WriteChar(LOWER_LEFT);
				else if (col == RIGHT_SIDE)
					WriteChar(LOWER_RIGHT);
				else
					WriteChar(HORIZONTAL);
			}
			else if (row == MID_SCREEN)
			{
				if (col == LEFT_SIDE)
					WriteChar(L_INTERSECT);
				else if (col == RIGHT_SIDE)
					WriteChar(R_INTERSECT);						
				else 
					WriteChar(HORIZONTAL);							
			}

 		 /* Check for sides */
			else if ( (col == LEFT_SIDE) || (col == RIGHT_SIDE) )
				WriteChar(VERTICAL);							
		}			
	}
	CursorOn();
}


void DisplayHeadings()
{
	CursorOff();

	SetCursor(1,2);
	printf("RECEIVING");

	SetCursor(11,2);
	printf("SENDING");

	SetCursor(22,6);
	printf("ENTER = Return   BACKSPACE = Delete   TAB = Clear box   ESCAPE = Quit");

	SetCursor(13,2);
	CursorOn();
}


void Update(string)
char	*string;
{
	int		cursorRow, cursorCol;

	CursorOff();
	SetCursor (24,1);
	printf ("System Message: %s",string);
	GetCursor (&cursorRow, &cursorCol);
	ClearEndOfLine (24, cursorCol);
	SetCursor (sendRow,sendCol);
	CursorOn();
}

void Error(text)
char	*text;
{
	ClearScreen();
	printf("%s",text);
	Exit();
}


void ClearScreen()
{
	ScrollUp(0,0,24,0,79);
}


void ClearSendBox()
{
	int lines = 7,
		topRow = 13,
		bottomRow = 19,
		leftCol = 1,
		rightCol = 78;
	
	ScrollUp(lines,topRow,bottomRow,leftCol,rightCol);

	sendRow = TOP_SEND_ROW;
	sendCol = FIRST_TEXT_COL;
	SetCursor(sendRow,sendCol);
}


void ClearReceiveBox()
{
	int lines = 7, topRow = 3, bottomRow = 9, leftCol = 1, rightCol = 78;
	
	ScrollUp (lines, topRow, bottomRow, leftCol, rightCol);
	CursorOff();

	receiveRow = TOP_RECEIVE_ROW;
	receiveCol = FIRST_TEXT_COL;
	SetCursor(sendRow, sendCol);
	CursorOn();
}


void ClearEndOfLine (line, cursor)
int		line, cursor;
{
 	ScrollUp (1, line, line, cursor, 79);
}


void WriteChar(ch)
char	ch;
{
	regs.h.ah = 0x09;
	regs.h.al = ch;
	regs.h.bl = 0x07;
	regs.h.bh = 0;
	regs.h.ch = 0;
	regs.h.cl = 1;

	int86(VIDEO, &regs, &regs);
}


void ScrollUp (lines, topRow, bottomRow, leftCol, rightCol)
int	lines, topRow, bottomRow, leftCol, rightCol;
{
	regs.h.ah = SCROLL_UP;
	regs.h.al = lines;
	regs.h.ch = topRow;
	regs.h.cl = leftCol;
	regs.h.dh = bottomRow;
	regs.h.dl = rightCol;
	regs.h.bh = 0x07;

	int86(VIDEO, &regs, &regs);
}


void SetCursor(r,c)
int register	c,
            	r;
{
	union REGS regs;

	regs.h.ah = SET_CURSOR;
	regs.h.dl = c;
	regs.h.dh = r;
	regs.h.bh = 0;

	int86(VIDEO, &regs, &regs);
}

void CursorOn() 
{
	int		start = 12; /* top line of cursor    */
	int		end = 13;   /* bottom line of cursor */

	regs.h.ch = start;
	regs.h.cl = end;
	regs.h.ah = CURSOR_SIZE;

	int86(VIDEO, &regs, &regs);
}


void CursorOff()
{
	regs.h.ch = STOPBIT;
	regs.h.ah = CURSOR_SIZE;
	int86(VIDEO, &regs, &regs);
}


GetCursor (cursorRow, cursorCol)
int 	*cursorRow, *cursorCol;
{
	union REGS regs;

	regs.h.ah = 3;
	regs.h.bh = 0;
 	int86(VIDEO, &regs, &regs);

	*cursorCol = regs.h.dl;
	*cursorRow = regs.h.dh;
}



