/****************************************************************************
**	File:	HELLO.C	
**
**	Desc:	Sample SPX chat program.	
**
**			This Sample code demonstrates how to set up and use SPX
**			communications to communicate between 2 nodes.
**		
**		
**		
**
**		DISCLAIMER  
**  
**	Novell, Inc. makes no representations or warranties with respect to
**	any NetWare software, and specifically disclaims any express or
**	implied warranties of merchantability, title, or fitness for a
**	particular purpose.  
**
**	Distribution of any NetWare software is forbidden without the
**	express written consent of Novell, Inc.  Further, Novell reserves
**	the right to discontinue distribution of any NetWare software.
**	
**	Novell is not responsible for lost profits or revenue, loss of use
**	of the software, loss of data, costs of re-creating lost data, the
**	cost of any substitute equipment or program, or claims by any party
**	other than you.  Novell strongly recommends a backup be made before
**	any software is installed.   Technical support for this software
**	may be provided at the discretion of Novell.
**
**	Programmers:
**
**		Ini	Who						Firm
**		-----------------------------------------------------------------------
**		TDOC  Technical Documentation Team
**		KLB	Karl Bunnell				Novell Developer Support.
**
**	History:
**
**		When		Who	What
**		-----------------------------------------------------------------------
**		10-25-88	TDOC	First code.
**		01-27-95 KLB   Ported this example to the NetWare Client SDK
*/

/****************************************************************************
**	Include headers, macros, function prototypes, etc.
*/
	/*------------------------------------------------------------------------
	**	MACROS
	*/
	#define NWDOS


	/*------------------------------------------------------------------------
	**	ANSI
	*/
	#include <stdio.h>


	/*------------------------------------------------------------------------
	**	NetWare
	*/
	#include <nwcalls.h>
	#include "chat.h"
	#include <nwipxspx.h>

	/*------------------------------------------------------------------------
	**	GLOBALS
	*/
	extern	void	SendMessage();
	extern	void	TearDownConnection();
	extern	int	PollForPacket();
	extern	void	SetUpReceiveECBs();
	extern	ECB	*SetUpInitialECB();
	extern	void	DrawScreen();
	extern	void	Dispatcher();
	extern 	void	ClearScreen();
	extern	void 	SetUpSendECB();

	extern NETWORK_NODE 	destNode;
	extern WORD   	SPXConnectionNumber, 		/* SPXEstablishConnection returns in DX */
			  		Socket;
	extern int		ACTIVE_CONNECTION;

	NWCONN_HANDLE	connHandle;


void main(argc,argv)
int		argc;
char	*argv[];
{
	int		ccode = 0;
	char	key = 0,
			networkNumber[4];
	WORD	connection, mysocket;
	NETWORK_ADDR	iNetAddress;

 /* Test for the correct number of arguments on command line */ 
	if (argc != 2) 
	{
		printf ("HELLO.EXE v1.01\n");
		printf ("by Novell Technical Documentation\n\n");
		printf ("Format: Hello station_number(hexidecimal)\n");
		printf ("Example: Hello 3A\n");
		exit (); 
	}

	NWCallsInit(NULL, NULL);

 /* Get the target station number */
 	sscanf (argv[1], "%d", &connection);
	NWGetDefaultConnectionID(&connHandle);

	NWGetInternetAddress (connHandle, connection, (BYTE *)&iNetAddress);
	
	memcpy(&destNode, iNetAddress.node, 6);
	memcpy(&networkNumber, iNetAddress.network, 4);

 /* Format the screen */
 	DrawScreen ();

 /* Establish a connection */
	ccode = EstablishListeningSide ();
	if (ccode)
			Error ("No answer.  Maybe they really didn't want to chat with you.");

 /* While connection is active, send or poll for messages */
 	Update ("Connection is established.");

	while (ACTIVE_CONNECTION)
	{
 		while ( !kbhit () )
		{
			if ( (ACTIVE_CONNECTION = PollForPacket()) == 0)
			{
			 	Update ("Your partner hung up.  Press ESCAPE twice to close.");
				break;
			}
		}

	 /* A key was hit */
	 	if ( (key = getch()) == ESCAPE)
		{
			Update ("Press ESCAPE to hang up / ENTER to resume.");
			if ( (key = getch()) == ESCAPE)
			{
				Update ("Closing connection...");
				ACTIVE_CONNECTION = 0;
				break;
			}
			Update ("Connection is active.");
		}
		else
			Dispatcher (key);		
 	}

	TearDownConnection ();
}



int	EstablishListeningSide ()
{
	int		ccode;
	BYTE	retryCount = 0x00, watchDog = 0x00, majRevNumber, minRevNumber;
	WORD	tempIDNumber, maxConnections, maxConnAvailable;
	ECB		*initialECB;
	char	key;

 /* See if SPX is installed */
   	Update ("Initializing SPX.",0);
	ccode =	SPXInitialize (&majRevNumber,&minRevNumber,&maxConnections,
				&maxConnAvailable);
	if (ccode != SPX_INSTALLED)
		Error ("SPX is not installed.");

 /* Open an IPX socket */
	ccode = IPXOpenSocket ( (BYTE *)&Socket, (BYTE)0 );
	if (ccode)
		Error ("Unable to open a socket.");

 /* Set up an ECB for listening and some ECBs for receiving */
	Update ("Preparing packets.",0);
 	SetUpReceiveECBs ();
 	initialECB = SetUpInitialECB ();
 
 /* Have SPX begin listening for a connection */
 	Update ("Attempting a connection.",0);
	SPXListenForConnection ( (BYTE)retryCount, (BYTE)watchDog, initialECB );

 /* If connection is successful, set up some ECBs for sending */
	Update ("Attempting a connection.  Press ESCAPE to hang up.");
 	while ( !kbhit() && initialECB->inUseFlag)
	{
		/* WAIT HERE */;
	}

	if (initialECB->completionCode == 0x00)
	{
		memcpy (&SPXConnectionNumber, initialECB->IPXWorkspace, 2);
		SetUpSendECB ();
		ccode = initialECB->completionCode;
	}
	else if ( (key = getch()) == ESCAPE )
		ccode = -1;

	return (ccode);
}
