;*****************************************************************************
;*
;* Program Name:  CONNECT
;*
;* Filename:	  connecta.asm
;*
;* Date Created:  December 1, 1987
;*
;* Programmers:	  Bryan Sparks
;*		  Software Consultant
;*	  	  API Consulting
;*		  Novell Inc.
;*
;* Files used:	  connect.c
;*
;* Comments:
;*	This assembly file contains two procedures that are "front-end"s 
;*	to C procedures that actually are the ESR procedures.
;*
;*****************************************************************************
	title	ESR Routines to C Function
	name	Connecta

DGroup	GROUP	_DATA
_DATA	segment word public 'DATA'
	assume	ds:DGroup
_DATA	ends

PGroup	GROUP	_TEXT
	assume	cs:PGroup

_TEXT	segment	byte public 'CODE'

	public	_ReceiveESRHandler
	public	_SendESRHandler

	extrn	_SendESR: near
	extrn	_ReceiveESR: near


;	
;	This is the front-end procedure to the C function "ReceiveESR"
;
_ReceiveESRHandler	proc	far
	mov	ax, DGroup
	mov	ds, ax
	push	es
	push	si
	call	_ReceiveESR
	add	sp, 4
	ret	
_ReceiveESRHandler	endp

;
;	This is the front-end procedure to the C function "SendESR"
;
_SendESRHandler		proc	far
	mov	ax, DGroup
	mov	ds, ax
	push	es
	push	si
	call	_SendESR
	add	sp, 4
	ret	
_SendESRHandler	endp


_TEXT	ends
	END
