/*****************************************************************************
 *
 * Program Name:  CONNECT
 *
 * Filename:	  connect.h
 *
 * Date Created:  December 1, 1987
 *
 * Programmers:	  Bryan Sparks
 *				  Software Consultant
 *			  	  API Consulting
 *				  Novell Inc.
 *
 * Files used:	  connect.c
 *
 * Comments:
 *	This file contains the definitions for SPX and IPX functions.
 *	You will notice that in some of the definitions a "far" directive
 *	is used.  This is a Microsoft C feature and I am not sure if other
 *	C compilers allow such a declaration.  If you use a language that
 *	does not support such a feature then you will have to use your
 *	imagination to come up with another scheme of assigning addresses.
 *	I do know that Lattice C has a function called "makepv" which may suit
 *	your purposes in this area.
 *
 *	The definitions for the following structures are taken from the 
 *	"Peer-to-Peer Communication Protocols" document.  See Developer's
 *	Update" article for more information in obtaining this document.
 ****************************************************************************/
#ifndef		TRUE
#define		TRUE		1
#endif
#ifndef		FALSE
#define		FALSE		0
#endif

#define		DATASIZE	100

struct	IPXAddress
{
	unsigned char	Network[4];	/* high-low */
	unsigned char	Node[6];	/* high-low */
	unsigned int 	Socket;		/* high-low */
};

typedef struct IPXPacketStructure
{
	unsigned int				PacketCheckSum;			/* high-low */
	unsigned int    			PacketLength;			/* high-low */
	unsigned char				PacketTransportControl;
	unsigned char				PacketType;
	struct IPXAddress			Destination;
	struct IPXAddress			Source;
} IPXPacket;

typedef struct SPXPacketStructure
{
	unsigned int				PacketCheckSum;			/* high-low */
 	unsigned int    			PacketLength;			/* high-low */
	unsigned char				PacketTransportControl;
	unsigned char				PacketType;
	struct IPXAddress			Destination;
	struct IPXAddress			Source;
	unsigned char				ConnectionControl;
	unsigned char				DatastreamType;
	unsigned int				SourceConnectionID;		/* high-low */
	unsigned int				DestinationConnectionID;	/* high-low */
	unsigned int				SequenceNumber;			/* high-low */
	unsigned int				AcknowledgeNumber; 		/* high-low */
	unsigned int				AllocationNumber;		/* high-low */
} SPXPacket;

struct	ECBFragment
{
	char far 			*Address; 
	unsigned int		Size;	 		/* low-high */
};

typedef struct ECBStructure 
{
	unsigned int				Link[2];				
	char far					*ESRAddress;			/* offset-segment */
	unsigned char				InUseFlag;
	unsigned char				CompletionCode;
	unsigned int				ECBSocket;				/* high-low */
	unsigned char				IPXWorkspace[4];		
	unsigned char				DriverWorkspace[12];	
	unsigned char				ImmediateAddress[6];	/* high-low */
	unsigned int				FragmentCount;			/* low-high */
	struct ECBFragment			FragmentDescriptor[2];
} ECB;

