/*******************************************************************************
module name:  UPTODATE
author:       Karl Boyken
date:         4/8/92
OS:           MS-DOS
compiler:     MicroSoft C 6.0
purpose:      UPTODATE is a batch utility that indicates whether a file needs
              to be updated, based on the date and time of another file.
              UPTODATE takes exactly two parameters, in this order:  a string
              specifying the file or directory to be tested, and a string
              representing the most current file or directory.

              UPTODATE returns 0 if exactly two parameters were passed to it,
              both files exist, and the first is as young or younger than
              the second.  If more or less than two parameters exist,
              UPTODATE returns 1.  If neither file exists, UPTODATE
              returns 2.  If the first file exists but the second does not,
              UPTODATE returns 3.  If the second file exists but the first
              does not, UPTODATE returns 4.  If both files exist and the
              first is older than the second, UPTODATE returns 5.
*******************************************************************************/

#include <fcntl.h>
#include <dos.h>

int main(int argc, char *argv[]) {
  int fh;                   /* file handle */
  int files_exist     = 0;  /* 0 == neither exists
                               1 == first file exists
                               2 == second file exists
                               3 == both files exist   */
  unsigned file1_date = 0;  /* date of first file  */
  unsigned file1_time = 0;  /* time of first file  */
  unsigned file2_date = 0;  /* date of second file */
  unsigned file2_time = 0;  /* time of second file */
  
  /* Check number of arguments */
  if ((argc < 3) || (argc > 3)) {
    return 1;
  }

  /* Get file attributes and see if first file or directory exists */
  if (!_dos_open(argv[1], O_RDONLY, &fh)) {
    if (!_dos_getftime(fh, &file1_date, &file1_time))
      files_exist |= 1;
    _dos_close(fh);
  }

  /* Get file attributes and see if second file or directory exists */
  if (!_dos_open(argv[2], O_RDONLY, &fh)) {
    if (!_dos_getftime(fh, &file2_date, &file2_time))
      files_exist |= 2;
    _dos_close(fh);
  }
  
  /* See which files exist */
  switch (files_exist) {
    case 0:  return 2;    /* Neither exists */
    case 1:  return 3;    /* First exists   */
    case 2:  return 4;    /* Second exists  */
  }
  
  /* Compare the dates and times */
  if (   (file1_date < file2_date) 
      || ((file1_date == file2_date) && (file1_time < file2_time)))
    return 5;

  /* First file is as young as or younger than the second */
  return 0;
}                                         
