/***************************************************************************
 *  This is a program that I have found to be very useful.  It checks a    *
 *  default connection Netware file server to see if it can see a          *
 *  particular SAP server.  If the SAP'd server is not there it passes an  *
 *  error level of 1 to the OS.  If it is there is passes a 0 to the OS.   *
 *  I run this program inside of a recursive call batch file and if the    *
 *  errorlevel is of a certain type then I send an urgent mail to my mail  *
 *  system which is picked up and pages me.  Use it if you like, if you    *
 *  have comments about why I coded things the way I did please e-mail me  *
 *  back at Jeff Grammer 76704,121 or jgrammer@iglou.com                   *
 *  Oh, BTW, to use the program it accepts SAP id's and server names as a  *
 *  command line entry.  For example, we have a phone system server that   *
 *  runs under OS/2 1.3 and the 1.3 Requester as SAP id "9a" and server    *
 *  name of "CALLXPR1".  Therefore to ping the sap you enter all as a      *
 *  command line of "SAPPING 0x009a CALLXPR1".  While case doesn't matter  *
 *  the SAP id *MUST* be entered in the above format (i.e. 0x<sap #>)      *
 *  or the C function call strtoul() doesn't work correctly.               *
 *  Anyway, see if you like it, and let me know thanks!                    *
 ***************************************************************************/


#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

#define NWDOS
#include <nwcalls.h>
#include <nwipxspx.h>

#ifdef __cplusplus
}
#endif

int main(int argc, char *argv[])
{

    LONG rCode;
    WORD cCode;
    SAP sap;
    BYTE propValue[128];
    int outCode=0;
    LONG SERVER_SAP;
    char *servername;

    if (argc < 3)
    {
       printf ("\nUsage: SAPPING 0x<sap#> <SERVERNAME>");
       exit(3);
    }
    
    SERVER_SAP = strtoul(argv[1],NULL,0);
    servername = argv[2];
    
    if (cCode = NWCallsInit(NULL, NULL))
    {
      printf("\ncall failed with %04x\nNETX may not be loaded.",cCode);
      exit(2);
    }
    
    
    rCode = NWReadPropertyValue(0,servername,NWWordSwap(SERVER_SAP),"NET_ADDRESS",1,propValue,NULL,NULL);
    switch (rCode)
    {
       case 0x0000:
            printf ("\n%s is alive.",servername);
            break;
       case 0x89FB:
            printf ("\nNo such property type.");
            outCode=1;
            break;
       case 0x89FC:
            printf ("\nNo such server.");
            outCode=1;
            break;
       default:
            printf ("\nError: NWReadPropertyValue() returned 0x%04X",rCode);
            outCode=1;
            break;
    }
    return (outCode);
}
