
/****************************************************************************
** DISCLAIMER
**
** Novell, Inc. makes no representations or warranties with respect to
** any NetWare software, and specifically disclaims any express or
** implied warranties of merchantability, title, or fitness for a
** particular purpose.
**
** Distribution of any NetWare software is forbidden without the
** express written consent of Novell, Inc.  Further, Novell reserves
** the right to discontinue distribution of any NetWare software.
**
** Novell is not responsible for lost profits or revenue, loss of use
** of the software, loss of data, costs of re-creating lost data, the
** cost of any substitute equipment or program, or claims by any party
** other than you.  Novell strongly recommends a backup be made before
** any software is installed.   Technical support for this software
** may be provided at the discretion of Novell.
****************************************************************************
**
** File:   MAP.C
**
** Desc:   This program will allow the user to change a drive mapping to
**         a new drive mapping or create a new drive mapping based on the
**         drive and path that is specified.     
**
** NOTE:   The reset code will set the drive back as a map root. Notice volume-
**         path returned by NWStripServerOffPath is the full path, so when 
**         NWSetDriveBase() is run it will map root the drive to were that map-
**         ping used to be.  In order to return the original mapping you would
**         have to NWSetDriveBase() to the root of the volume, then use the dos
**         function calls shown in ChangeMappings() to change directory out to
**         the subdirectory you wish to be in.
**
**
**
** Parameter descriptions:    > input
**                            < output
**
**
** Netware API Calls:    NWCallsInit()   
**                       NWGetDriveStatus()      
**                       NWDeleteDriveBase()
**                       NWParsePath()
**                       NWStripServerOffPath()
**                       NWAttachToFileServer()
**                       NWSetDriveBase()
**
** Programmers:
** Ini   Who                Firm
** ------------------------------------------------------------------
** ARM   A. Ray Maxwell     Novell Developer Support.
**
** History:
**
** ------------------------------------------------------------------
** 09-06-94   ARM   First code.    Inspired by code from Belinda Adams.
*/

/****************************************************************************
**   Include headers, macros, function prototypes, etc.
*/
   

   /*------------------------------------------------------------------
   **   ANSI
   */
   #include <ctype.h>
   #include <stdio.h>       /* printf()          */
   #include <stdlib.h>      /* exit()            */
   #include <string.h>      /* strcpy() strupr() */
   #include <conio.h>       /* clrscr()          */
   #include <dir.h>         /* chdir()           */
   
   /*------------------------------------------------------------------
   **   NetWare
   */
   #include <nwcalls.h>
   
   
   /*------------------------------------------------------------------
   **   Defines
   */
   #define NWDOS
   
   
   /*------------------------------------------------------------------
   **   Prototypes
   */
   static void displayAllMappings(void);
   static void displayMapping(int);
   static void changeMappings(void);
   static void resetMapping( char, NWCONN_HANDLE, char *);



/****************************************************************************
**   Program Start
*/
void main(void)
{
   int ccode;
   char drive;
   char ans = 'n';
   
   
   ccode = NWCallsInit( NULL, NULL );
   if (ccode)
   {
      printf( "\nNWCallsInit: failed %04x", ccode );
      exit(1);
   }
   system( "cls" );
   displayAllMappings();
   puts("\n\nChange current mappings (y/n)? ");
   ans = getche();
   puts("\n");
   if ( ans == 'y' || ans == 'Y' )
      changeMappings();
}

/****************************************************************************
**   Displays all the drive mappings
*/
void displayAllMappings(void)
{
   int   drive_num;

   puts( "Current drive mapping:\n" );
   for (drive_num = 1; drive_num <= 26; drive_num++)
      displayMapping(drive_num);
}

/****************************************************************************
**  Displays one mapping at a time
*/
void displayMapping(int drive_num)
{
   NWCCODE  ccode;
   char     rootPath[304], relativePath[304];
   int      status;


   ccode = NWGetDriveStatus(      
           /* > drive Number    */  drive_num,
           /* > path format     */  NW_FORMAT_SERVER_VOLUME,
           /* < bitmask pointer */  &status,
           /* < conn Handle     */  NULL,
           /* < root path       */  rootPath,
           /* < relative path   */  relativePath,
           /* < full path       */  NULL);

   if ( ccode == NW_INVALID_DRIVE )
      printf( "\nNWGetDriveStatus: Invalid Drive Number %d", drive_num );
   else
   {
      if ( ccode )
      {
         printf( "\nNWGetDriveStatus: failed %04x", ccode );
         exit(1);
      }
      if ( (status & NW_NETWARE_DRIVE) || (status & NW_LOCAL_DRIVE) )
      {
         printf("Drive %c: = %s", drive_num + '@', rootPath);
         puts( relativePath );
      }
   }
}

/****************************************************************************
** Changes the drive mapping
*/
void changeMappings(void)
{
   char          drive_ltr, drive_num;
   int           ccode, status;
   NWCONN_HANDLE conn;
   char          ans, ans_str[100];
   char          *upr_ans;
   char          server[50],
                 rootPath[304],
                 relativePath[304],
                 fullPath[304];

   char           *volumePath;
   char          serverName[48];
   char          volName[17];
   char          dirPath[256];
   char          dosPath[256];

   /*---------------------------------------------------------------------
   ** This code converts alpha drive letter to numeric.
   */
   puts( "Enter drive letter to change " );
   drive_ltr = getche();
   if (drive_ltr >= 'a' && drive_ltr <= 'z')
      drive_ltr = _toupper(drive_ltr);
   puts("\n");
   if (drive_ltr >= 'A' && drive_ltr <= 'Z')
      drive_num = drive_ltr - '@';
   else
   {
      printf("Drive letter %c is an invalid drive letter", drive_ltr);
      exit(1);
   }

   /*--------------------------------------------------------------------
   **Read current drive status of the drive number passed in.
   */
   ccode = NWGetDriveStatus(
            /* > drive Number    */  drive_num,
            /* > path format     */  NW_FORMAT_SERVER_VOLUME,
            /* < bitmask pointer */  &status,
            /* < conn Handle     */  &conn,
            /* < root path       */  rootPath,
            /* < relative path   */  relativePath,
            /* < full path       */  fullPath);

   if ( ccode )
   {
      printf( "\nNWGetDriveStatus: failed %04x", ccode );
      exit(1);
   }

   /*--------------------------------------------------------------------
   ** delete the drive's current mapping
   */
   if ( status != NW_UNMAPPED_DRIVE ){
      ccode = NWDeleteDriveBase(
              /* > drive number    */  drive_num,
              /* NOVELL use only 0 */  0 );
      if (ccode){
         printf( "\nNWDeleteDriveBase: failed %04x", ccode );
         exit(1);
      }
   }

   puts("Enter new mapping (server\\volume:path): ");
   gets(ans_str);
   upr_ans = strupr(ans_str);

   /*---------------------------------------------------------------------
   ** Parse the path to get the volName for use in setting the drive base.
   */
   ccode = NWParsePath(
           /* > pointer to path                         */  upr_ans,
           /* < pointer to server name 48 char optional */  server,
           /* < pointer to conn handle                  */  &conn,
           /* < pointer to volume name 17 char optional */  volName,
           /* < pointer to directory  256 char optional */  dirPath);

   if (ccode == (NWCCODE) NO_CONNECTION_TO_SERVER ){
       ccode = NWAttachToFileServer(
                /* server name       */  server,
                /* NOVELL USE ONLY 0 */  0,
                /* connection Handle */  &conn );
      if (ccode){
         printf( "\nNWAttachToFileServer: failed %04x", ccode );
         exit(1);
      }
   }
   else
      if (ccode){
        printf( "\nNWParsePath: failed %04x", ccode );
        exit(1);
      }
   /*-----------------------------------------------------------------------
   ** NWStripServerOffPath will return a pointer to the volume path if
   ** successful, it will also return the server name in the second parameter.
   */
  // volumePath = NWStripServerOffPath(
  //              /* path to parse        */ upr_ans,
  //              /* server name Optional */ serverName);
   /*-----------------------------------------------------------------------
   ** set the drive base EXAMPLE  servername\sys:
   */
   ccode = NWSetDriveBase(
            /* > drive Number    */  drive_num,
            /* > conn Handle     */  conn,
            /* > directory handle*/  0,
            /* > directory path  */  volName,
            /* NOVELL use only 0 */  0);

   if   (ccode){
      printf( "\nNWSetDriveBase: failed %04x", ccode );
      exit(1);
   }


   /*-----------------------------------------------------------------------
   ** sets the drive mapping out to the rest of the directory path passed
   ** in by the user.
   */
   dosPath[0]=drive_ltr;
   dosPath[1]=':';
   dosPath[2]='\0';
   strcat(dosPath,dirPath);
   chdir(dosPath);
   clrscr();
   puts("Drive mappings updated.\n");
   displayMapping(drive_num);

        

   puts("\n\nReset to original mappings (y/n)? ");
   ans = getche();
   puts("\n");

   if ( ans == 'y' || ans == 'Y' )
   {
      strcat(rootPath, relativePath);
      resetMapping(drive_num, conn, rootPath);
      system( "cls" );
      puts("Drive mappings reset.");
   }
   displayAllMappings();
}
/****************************************************************************
**  reset the mappings that were there originally
**  NOTE: The reset code will set the drive back as a map root. Notice volume-
**        path returned by NWStripServerOffPath is the full path, so when 
**        NWSetDriveBase() is run it will map root the drive to were that map-
**        ping used to be.  In order to return the original mapping you would
**        have to NWSetDriveBase() to the root of the volume, then use the dos
**        function calls shown in ChangeMappings() to change directory out to
**        the subdirectory you wish to be in.
*/
void resetMapping(char drive_num,NWCONN_HANDLE conn,char *rootPath)

{
   int          ccode;
   char         *volumePath;


   ccode = NWDeleteDriveBase(
           /* > drive number    */  drive_num,
           /* NOVELL use only 0 */  0 );

   if (ccode){
      printf( "\nNWDeleteDriveBase: failed %04x", ccode );
      exit(1);
   }
   volumePath = NWStripServerOffPath(
                /* path to parse        */ rootPath,
                /* server name Optional */ NULL );


   ccode = NWSetDriveBase(
           /* > drive Number    */  drive_num,
           /* > conn Handle     */  conn,
           /* > directory handle*/  0,
           /* > directory path  */  volumePath,
           /* NOVELL use only 0 */  0);

   if(ccode){
      printf( "\nNWSetDriveBase: failed %04x", ccode );
      exit(1);
   }
}
                                                                               
                                                                                                                                             