
#include <stdio.h>
#include <dos.h>

/*
 *	List all network devices for networked PCs using NETBIOS
 *	(tested on 3Com nets only, though info was taken from the DOS
 *	tech reference)
 *
 *	Feel free to pillage and plunder this code fragment as you see
 *	fit.
 *
 *	D. Cornejo; TPCC; PO Box 501, Herndon, VA 22070
 */

/* make sure the necessary pointers are long pointers */
#define FAR far

/* prototype for the NETBIOS access function */
int GetRedirList (int index, char * FAR localname, char * FAR netname, int * FAR type);

void main (void)
{
     char locbuf[128], netbuf[128];
     int type;
     int cy;
     int index;
     char *devtyp;

     cy = 0;
     index = 0;
     while ((index < 256) && (cy == 0)) {
	  cy = GetRedirList (index, locbuf, netbuf, &type);
	  if (cy == 0) {
	       switch (type) {
	       case 3:
		    devtyp = "Print";
		    break;
	       case 4:
		    devtyp = "Drive";
		    break;
	       default:
		    devtyp = "Unknown";
	       }

	       printf ("[%d] %s: local name='%s' net name='%s'\n",
		       index, devtyp, locbuf, netbuf);
	  }
	  index++;
     }
}

int GetRedirList (int index, char * FAR localname, char * FAR netname, int * FAR type)
{
     /* read the local name, network name, and device type for entry <index> */

     union REGS junk;
     struct SREGS sjunk;

     junk.x.ax = 0x5f02;	/* function call 5f (subfunction 2) */
     junk.x.bx = index;		/* index of entry in redir table */

     sjunk.ds = FP_SEG (localname);	/* pointer to local name buf */
     junk.x.si = FP_OFF (localname);

     sjunk.es = FP_SEG (netname);	/* pointer to net name buf */
     junk.x.di = FP_OFF (netname);

     intdosx (&junk, &junk, &sjunk);	/* make the call */

     *type = junk.x.bx;
     return (junk.x.cflag);	/* return the carry flag */
}
