unit U_srvinf;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, SysUtils,
  CALMIS16, CALSRV16,
  U_Vars;

type
  TServerInfo = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    EditSrv: TEdit;
    Label2: TLabel;
    EditVer: TEdit;
    Label3: TLabel;
    EditConn: TEdit;
    Label4: TLabel;
    EditVol: TEdit;
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ServerInfo: TServerInfo;

implementation

{$R *.DFM}

procedure TServerInfo.FormShow(Sender: TObject);
VAR
   serverName :   String;
   majorVer :     nuint8;
   minVer :       nuint8;
   rev :          nuint8;
   maxConns :     nuint16;
   maxConnsUsed : nuint16;
   connsInUse :   nuint16;
   numVolumes :   nuint16;
   SFTLevel :     nuint8;
   TTSLevel :     nuint8;
   cCode :        NWCCODE;
begin
 cCode := NWGetFileServerInformation(connHandle, @serverName[1], @majorVer, @minVer, @rev,
             @maxConns, @maxConnsUsed, @connsInUse, @numVolumes, @SFTLevel, @TTSLevel);

 if (cCode=0) then begin
    EditSrv.Text  := StrPas(@serverName[1]);
    EditVer.Text  := 'v' + IntToStr(majorVer) + '.' + IntToStr(minVer);
    EditConn.Text := IntToStr(connsInUse) + ' of ' + IntToStr(maxConns) + ' used';
    EditVol.Text  := IntToStr(numVolumes);
    end;
end;

end.
