unit U_jobinf;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, SysUtils,
  CALMIS16, CALQMS16,
  Delphi_U, U_Vars;

type
  TDlgJobInfo = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    EditJobNumber: TEdit;
    EditClient: TEdit;
    Label2: TLabel;
    EditDesc: TEdit;
    Label3: TLabel;
    EditPath: TEdit;
    Label4: TLabel;
    EditSeq: TEdit;
    Label5: TLabel;
    EditBanner: TEdit;
    Label7: TLabel;
    EditName: TEdit;
    Label8: TLabel;
    EditForm: TEdit;
    Label9: TLabel;
    EditServer: TEdit;
    Label10: TLabel;
    EditTargetServer: TEdit;
    Label11: TLabel;
    EditTabsize: TEdit;
    Label12: TLabel;
    CheckBoxOpHold: TCheckBox;
    CheckBoxUserHold: TCheckBox;
    CheckBoxBanner: TCheckBox;
    CheckBoxFF: TCheckBox;
    CheckBoxNotify: TCheckBox;
    Label13: TLabel;
    EditCopies: TEdit;
    EditBannerFile: TEdit;
    Label14: TLabel;
    CheckBoxText: TCheckBox;
    TimerJobUpdate: TTimer;
    Label6: TLabel;
    EditSize: TEdit;
    procedure PassQueueAndJob(Q, jobNr: nuint32);
    procedure FormActivate(Sender: TObject);
    procedure UpdateJobInfo(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
     jobNumber  : nuint32;
     QID        : nuint32;
  public
    { Public declarations }
  end;


TYPE
   TClientRecordArea = RECORD
	versionNumber:           BYTE;
	tabSize:                 BYTE;
	numberOfCopies:          WORD;
	printControlFlags:       WORD;
	maxLinesPerPage:         WORD;
	maxCharsPerLine:         WORD;
	formName:                ARRAY[1..16] OF CHAR;
	reserve:                 ARRAY[1..6]  OF BYTE;
	bannerNameField:         ARRAY[1..13] OF CHAR;
	bannerFileField:         ARRAY[1..13] OF CHAR;
	headerFileName:          ARRAY[1..14] OF CHAR;
	directoryPath:           ARRAY[1..80] OF CHAR;
        end;

var
  DlgJobInfo : TDlgJobInfo;

implementation

{$R *.DFM}

procedure TDlgJobInfo.PassQueueAndJob(Q, jobNr: nuint32);
begin
   QID       := Q;
   jobNumber := jobNr;
end;

procedure TDlgJobInfo.FormActivate(Sender: TObject);
begin
   UpdateJobInfo(Sender);
   TimerJobUpdate.Interval := 10000;   { update form every 10 sec }
end;

procedure TDlgJobInfo.UpdateJobInfo(Sender: TObject);
VAR
   job           : NWQueueJobStruct;
   objName       : String;
   clientRecord  : TClientRecordArea;
   fileSize      : nuint32;
begin
   EditJobNumber.Text := IntToHex(jobNumber, 8);
   cCode := NWReadQueueJobEntry2(connHandle, QID, jobNumber, job);
   Case cCode of
      $89D5 : ErrorMessage(cCode, 'NO_Q_JOB');
      else    ErrorMessage(cCode, 'NWReadQueueJobEntry2');
      end;
   if (cCode<>0) then exit;

   cCode := GetObjNameFromID(job.clientID, objName);
   if (cCode=0) then EditClient.Text := objName;

   if (job.targetServerID = -1)    then EditTargetServer.Text := '<any>'
      else begin
           cCode := GetObjNameFromID(job.targetServerID, objName);
           if (cCode=0) then EditTargetServer.Text := objName;
           end;

   if (job.servicingServerID = 0)  then EditServer.Text := '<none>'
      else begin
           cCode := GetObjNameFromID(job.servicingServerID, objName);
           if (cCode=0) then EditServer.Text := objName;
           end;

   EditDesc.Text       := StrPas(@job.jobDescription);
   EditSeq.Text        := IntToStr(job.jobPosition);
   EditName.Text       := StrPas(@job.jobFileName);

   Move(job.clientRecordArea, clientRecord, sizeof(clientRecord));

   EditCopies.Text     := IntToStr(Swap(clientRecord.numberOfCopies));
   EditBanner.Text     := StrPas(@clientRecord.bannerNameField);
   EditBannerFile.Text := StrPas(@clientRecord.bannerFileField);
   EditForm.Text       := '('+IntToStr(job.jobType)+') '+StrPas(@clientRecord.formName);
   EditTabsize.Text    := IntToStr(clientRecord.tabSize);
   EditPath.Text       := StrPas(@clientRecord.headerFileName) + ' ('+StrPas(@clientRecord.directoryPath) +')';
   if (EditPath.Text = ' ()') then EditPath.Text := '';

   CheckBoxUserHold.Checked := (job.jobControlFlags and $40)>0;
   CheckBoxOpHold.Checked   := (job.jobControlFlags and $80)>0;

   CheckBoxBanner.Checked   := (clientRecord.printControlFlags and $8000)>0;
   CheckBoxFF.Checked       := (clientRecord.printControlFlags and $0800)=0;
   CheckBoxNotify.Checked   := (clientRecord.printControlFlags and $1000)>0;
   CheckBoxText.Checked     := (clientRecord.printControlFlags and $4000)>0;

   cCode := NWGetQueueJobFileSize2(connHandle, QID, jobNumber, @fileSize);
   ErrorMessage(cCode, 'NWGetQueueJobFileSize2');
   if (cCode = 0) then EditSize.Text := IntToStr(fileSize)
                  else EditSize.Text := '';
end;

procedure TDlgJobInfo.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   TimerJobUpdate.Interval := 0;
end;

end.
