unit U_queues;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, SysUtils,
  CALMIS16, CALBND16, CALQMS16,
  Delphi_U, U_Vars, U_JobInf, U_QInfo;

type
  TDlgQueueList = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    Bevel1: TBevel;
    ListBoxQueues: TListBox;
    ListBoxJobs: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    EditJobInfo: TEdit;
    ButtonDelJob: TButton;
    ButtonJobInfo: TButton;
    ButtonQInfo: TButton;
    procedure GetQueueList(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure ListBoxQueuesClick(Sender: TObject);
    procedure GetJobList(Sender: TObject);
    procedure ListBoxJobsClick(Sender: TObject);
    procedure ButtonDelJobClick(Sender: TObject);
    procedure ButtonJobInfoClick(Sender: TObject);
    procedure ListBoxQueuesDblClick(Sender: TObject);
  private
    { Private declarations }
     QName     : String;
     QID       : nuint32;
  public
    { Public declarations }
  end;

var
   DlgQueueList : TDlgQueueList;

implementation

{$R *.DFM}


procedure TDlgQueueList.GetQueueList(Sender: TObject);
begin     { retrieve all bindery queues into list box }
   ClearList(ListBoxQueues);
   ClearList(ListBoxJobs);
   ListBoxAddObjects(Sender, connHandle, ListBoxQueues, '*', OT_PRINT_QUEUE);
end;

procedure TDlgQueueList.FormActivate(Sender: TObject);
begin
   QName := '';
   GetQueueList(Sender);
end;


procedure TDlgQueueList.GetJobList(Sender: TObject);
VAR queueStartPos : nuint32;
    jobList   : QueueJobListReply;
    jobIndex  : WORD;
    jobNumber : nuint32;
    job       : NWQueueJobStruct;
    sTemp     : String;
    objName   : String;
    objType   : nuint16;
begin
   ClearList(ListBoxJobs);
   EditJobInfo.Text := '';
   ccode := NWGetObjectID(connHandle, @QName[1], OT_PRINT_QUEUE, @QID);
   ErrorMessage(cCode, 'NWGetObjectID');   if cCode>0 then exit;

   queueStartPos := 0;
   cCode := NWGetQueueJobList2(connHandle, QID, queueStartPos, jobList);
   Case cCode of
      $89D3 : ErrorMessage(cCode, 'ERR_NO_Q_RIGHTS');
      else ErrorMessage(cCode, 'NWGetQueueJobList2');
      end;
   if cCode>0 then exit;

   for jobIndex := 1 to jobList.replyQueueJobNumbers do begin
       jobNumber := jobList.jobNumberList[Pred(jobIndex)];
       cCode := NWReadQueueJobEntry2(connHandle, QID, jobNumber, job);
       if (cCode=0) then begin
          cCode := GetObjNameFromID(job.clientID, objName);
          sTemp := IntToStr(jobIndex) + '   ';           sTemp := Copy(sTemp, 1, 4);
          sTemp := sTemp + '['+objName+ '            ';  sTemp := Copy(sTemp, 1, 15);
          sTemp := sTemp                       + '] ' +
                   StrPas(@job.jobDescription) + ' ' +
                   '('+IntToHex(jobNumber,8)+')';
          AddListEntry(Sender, ListBoxJobs, sTemp);
          end;
       end;

end;


procedure TDlgQueueList.ListBoxQueuesClick(Sender: TObject);
VAR
   sTemp     : String;
begin
   if (ListBoxQueues.ItemIndex = -1) or (ListBoxQueues.Items.Count=0) then exit;
   sTemp := ListBoxQueues.Items[ListBoxQueues.ItemIndex] + #0;
   if (sTemp=QName) then exit  { queue did not change }
                    else QName := sTemp;
   GetJobList(Sender);
end;

procedure TDlgQueueList.ListBoxJobsClick(Sender: TObject);
begin
   if (ListBoxJobs.ItemIndex>=0) then
      EditJobInfo.Text := ListBoxJobs.Items[ListBoxJobs.ItemIndex];
   ButtonJobInfo.Enabled := (ListBoxJobs.ItemIndex>=0);
   ButtonDelJob.Enabled  := (ListBoxJobs.ItemIndex>=0);
end;

procedure TDlgQueueList.ButtonDelJobClick(Sender: TObject);
VAR JobNumber : nuint32;
    sTemp     : String;
    Code      : Integer;
    oldPos    : Integer;
begin
   sTemp := Copy(EditJobInfo.Text, Length(EditJobInfo.Text)-8, 8);
   Val('$'+sTemp, JobNumber, Code);  { get job number }
   if (Code>0) then exit;
   cCode := NWRemoveJobFromQueue2(connHandle, QID, jobNumber);
   Case cCode of
      0     : begin
              oldPos := ListBoxJobs.ItemIndex;
              GetJobList(Sender);               { rebuild list }
              ListBoxJobs.ItemIndex := oldPos;
              ListBoxJobsClick(Sender);         { re-display edit text }
              end;
      $89D3 : ErrorMessage(cCode, 'NO_Q_RIGHTS');
      $89D6 : ErrorMessage(cCode, 'NO_Q_JOB_RIGHTS');
      else ErrorMessage(cCode, 'NWRemoveJobFromQueue2');
      end;

end;

procedure TDlgQueueList.ButtonJobInfoClick(Sender: TObject);
VAR JobNumber : nuint32;
    sTemp     : String;
    Code      : Integer;
begin
   sTemp := Copy(EditJobInfo.Text, Length(EditJobInfo.Text)-8, 8);
   Val('$'+sTemp, JobNumber, Code);  { get job number }
   if (Code>0) then exit;
   DlgJobInfo.PassQueueAndJob(QID, jobNumber);
   DlgJobInfo.ShowModal;
end;

procedure TDlgQueueList.ListBoxQueuesDblClick(Sender: TObject);
begin
   DlgQueueInfo.PassQIDName(QID, ListBoxQueues.Items[ListBoxQueues.ItemIndex]);
   DlgQueueInfo.ShowModal;
end;

end.
