unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, StdCtrls,
  CALMIS16, CLXWIN16, LOCWIN16,
  {
  AUDWIN16, CALACT16, CALAFP16, CALBND16, CALCON16, CALFIL16, CALFSE16,
  CALMIG16, CALMIS16, CALMSG16, CALNAM16, CALNCP16, CALPRT16, CALQMS16,
  CALSRV16, CALSVM16, CALSYN16, CALTTS16, CALVOL16, CLXWIN16, LOCWIN16,
  NETCON16, NETNDS16,
  }
  Delphi_U, U_Vars, U_About, U_SelSrv, U_SrvInf, U_Queues;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    MenuGeneral: TMenuItem;
    ItemScanFiles: TMenuItem;
    ItemExit: TMenuItem;
    ItemAbout: TMenuItem;
    ItemSelectServer: TMenuItem;
    ItemServerInformation: TMenuItem;
    Label1: TLabel;
    procedure ItemExitClick(Sender: TObject);
    procedure ItemAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ItemSelectServerClick(Sender: TObject);
    procedure ItemServerInformationClick(Sender: TObject);
    procedure ItemScanFilesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1:       TForm1;
  local:       LCONV;

implementation

{$R *.DFM}

procedure TForm1.ItemExitClick(Sender: TObject);
begin
   Close;
end;

procedure TForm1.ItemAboutClick(Sender: TObject);
begin
   About.Show;
end;

procedure TForm1.FormCreate(Sender: TObject);
VAR
   tmp:      nptr;

   connRef : nuint32;
   openState : nuint;
   reserved : nuint;
   countryCode : nint;
   codePage    : nint;

begin
   { Initialize the program }
   tmp         := Nil;
   cCode       := NWCallsInit(tmp, tmp);
   ErrorMessage(cCode, 'NWCallsInit');

   { Get the primary connection reference }
   cCode       := NWCCGetPrimConnRef(@ConnRef);
   ErrorMessage(cCode, 'NWCCGetPrimConnRef');

   { Get the primary connection handle }
   cCode       := NWCCOpenConnByRef(ConnRef, NWCC_OPEN_LICENSED, reserved, @connHandle);
   ErrorMessage(cCode, 'NWCCOpenConnByRef');

   { Get get locale ANSI information }
   NWLlocaleconv(@local);

   { initialize Unicode tables }
   cCode       := NWInitUnicodeTables(local.country_ID, local.code_Page);

end;

procedure TForm1.ItemSelectServerClick(Sender: TObject);
begin
   SelectServer.ShowModal;
end;

procedure TForm1.ItemServerInformationClick(Sender: TObject);
begin
   ServerInfo.ShowModal;
end;

procedure TForm1.ItemScanFilesClick(Sender: TObject);
begin
   DlgQueueList.ShowModal;
end;

end.
