unit Delphi_u;
{  general variables/functions/procedures for Delphi }

interface

uses
    Forms, Controls, StdCtrls, Dialogs, SysUtils, IniFiles,
    CALMIS16, CALBND16, NETNDS16,
    U_Vars;


TYPE
     Str2                      = String[2];
     Str4                      = String[4];
     Str8                      = String[8];

     NWCCODE                   = WORD;


{ general }
{
FUNCTION  hex2(Number: BYTE): Str2;
FUNCTION  hex4(Number: Word): Str4;
FUNCTION  hex8(nr: LongInt): Str8;
}
Function  UpperString(S: String): String;
Function  LastChar(S:String): Char;
Procedure TerminateString(VAR S: String);
Procedure AppendBackslash(VAR S: String);

procedure PushCursor;
procedure PopCursor;
procedure Hourglass;
procedure WaitCursor;
procedure NormalCursor;

Procedure NotYet(Sender: TObject);
Procedure ErrorMessage(Error: NWCCODE; Msg: String);
Procedure MyShowMessage(Msg: String);

{ list boxes }
procedure SelectDefaultListItem(Sender: TObject; VAR SelectedListbox: TListBox; VAR pos: Integer);
procedure ChangeCurrentListboxEntry(VAR NewName: String; VAR SelectedListbox: TListBox);
procedure ClearList(VAR SelectedListbox: TListBox);
procedure AddListEntry(Sender: TObject; VAR SelectedListbox: TListBox; VAR NewEntry: String);
procedure DeleteListEntry(Sender: TObject; VAR SelectedListbox: TListBox; VAR Pos: Integer);

function  GetBinderyObjectName(objID: nuint32; VAR Name: String): NWCCODE;
function  GetNDSObjectName(objID: nuint32; VAR Name: String): NWCCODE;
function  GetObjNameFromID(objID: nuint32; VAR objName: String): NWCCODE;
PROCEDURE ListBoxAddObjects(Sender: TObject; connID: NWCONN_HANDLE; VAR TargetList: TListBox;
                            OPattern: String; OType: nuint16);
procedure ListBoxAddMembers(Sender: TObject; connID: NWCONN_HANDLE; VAR TargetList: TListBox;
                            objectName: String; objectType: nuint16; propertyName: String);

procedure IniWriteString(IniName: String; Section, Ident, Value: String);
Function  IniReadString(IniName: String; Section, Ident, Default: String): String;
procedure IniWriteInt(IniName: String; Section, Ident: String; Value: Integer);
Function  IniReadInt(IniName: String; Section, Ident: String; Default: Integer): Integer;



VAR
   PushedCursor :    TCursor;


implementation
(*
FUNCTION hex2(Number: BYTE): Str2;
CONST  hexa : Array[0..15] of Char = '0123456789ABCDEF';
BEGIN
     hex2[0] := #2;
     hex2[1] := hexa[Number SHR 4];
     hex2[2] := hexa[Number AND $0F];
END;

FUNCTION  hex4(Number: Word): Str4;
BEGIN
     hex4 :=  hex2(hi(Number)) + hex2(lo(Number));
END;

FUNCTION  hex8(nr: LongInt): Str8;
VAR DW : Record
         WHi, WLo : Word
         END absolute nr;
BEGIN
   hex8 := hex4(Swap(DW.WHi)) + hex4(Swap(DW.WLo))
END;
*)

Function  UpperString(S: String): String;
VAR i : BYTE;
begin
   for i := 1 to Length(S) do S[i] := UpCase(S[i]);
   UpperString := S;
end;

Function  LastChar(S:String): Char;
begin
   LastChar := S[Length(S)];
end;

Procedure TerminateString(VAR S: String);
begin
   S[Succ(Length(S))] := #0;
end;

Procedure AppendBackslash(VAR S: String);
begin
   IF not (LastChar(S) in ['\', '/']) then S:= S + '\';
end;

procedure PushCursor;
begin
   PushedCursor  := Screen.Cursor;
end;

procedure PopCursor;
begin
   Screen.Cursor := PushedCursor;
end;

procedure Hourglass;
begin
   Screen.Cursor := crHourGlass;
end;

procedure WaitCursor;
begin
   if Screen.Cursor = crHourGlass then Exit;
   PushedCursor  := Screen.Cursor;
   Screen.Cursor := crHourGlass;
end;

procedure NormalCursor;
begin
   Screen.Cursor := PushedCursor;
end;

Procedure NotYet(Sender: TObject);
begin
   MyShowMessage('This Function is not Implemented');
end;

Procedure MyShowMessage(Msg: String);
VAR SaveCursor : TCursor;
begin
   SaveCursor    := Screen.Cursor;
   Screen.Cursor := crArrow;
   MessageDlg(Msg, mtWarning, [mbOK], 0);
   Screen.Cursor := SaveCursor;
end;

Procedure ErrorMessage(Error: NWCCODE; Msg: String);
begin
   if Error<>0 then MyShowMessage('Error '+IntToHex(Error, 4)+': '+Msg);
end;

procedure SelectDefaultListItem(Sender: TObject; VAR SelectedListbox: TListBox; VAR pos: Integer);
begin
   if (SelectedListbox=nil) then exit;
   if (SelectedListbox.ItemIndex >= 0)                      { override pos if valid position }
      then pos := SelectedListbox.ItemIndex          else
   if ((Pos <= -1) and (SelectedListbox.Items.Count > 0))   { if none selected, select first }
      then Pos := 0                                  else
   if ( Pos >= SelectedListbox.Items.Count)                 { too big }
      then Pos := Pred(SelectedListbox.Items.Count);
   SelectedListbox.ItemIndex := pos;
end;

procedure ChangeCurrentListboxEntry(VAR NewName: String; VAR SelectedListbox: TListBox);
{  Delete current entry and insert new entry - e.g. renaming }
{  NewName must be #0 terminated }
VAR Pos, NewPos:       Integer;
begin
   if (SelectedListbox=nil) then exit;
   Pos    := SelectedListbox.ItemIndex;
   SelectedListbox.Items.Delete(Pos);
   NewPos := SelectedListbox.Items.Add(NewName);
   SelectedListbox.ItemIndex := NewPos;
end;

procedure ClearList(VAR SelectedListbox: TListBox);
begin
   if (SelectedListbox=nil) then exit;
   While SelectedListbox.Items.Count > 0
         DO SelectedListbox.Items.Delete(0);
end;

procedure AddListEntry(Sender: TObject; VAR SelectedListbox: TListBox; VAR NewEntry: String);
{   add entry if not existing    }
VAR NewPos    : Integer;
begin
   if (SelectedListbox=nil) then exit;
   if (SelectedListbox.GetTextLen>32000) then exit;
   NewPos := SelectedListbox.Items.IndexOf(NewEntry);
   IF (NewPos=-1) THEN begin
      NewPos := SelectedListbox.Items.Add(NewEntry);
      SelectedListbox.ItemIndex := NewPos;
      end;
end;


procedure DeleteListEntry(Sender: TObject; VAR SelectedListbox: TListBox; VAR Pos: Integer);
begin
   if (SelectedListbox=nil) then exit;
   SelectedListbox.Items.Delete(Pos);
   IF Pos <> SelectedListbox.ItemIndex THEN BEGIN {change current index}
         IF Pos>=SelectedListbox.Items.Count THEN Pos := Pred(SelectedListbox.Items.Count);
      END;
   SelectedListBox.ItemIndex := Pos;
end;

procedure ListBoxAddObjects(Sender: TObject; connID: NWCONN_HANDLE; VAR TargetList: TListBox;
                            OPattern: String; OType: nuint16);
          { scan bindery and add selected objects to listbox }
TYPE TRetrievedObject  = Record
        objID             : nuint32;
        objName           : String;
        objType           : nuint16;
        hasPropertiesFlag : nuint8;
        objFlags          : nuint8;
        objSecurity       : nuint8
        end;
VAR   NewPos:            Integer;
      ObjectName:          String;
      Obj:               TRetrievedObject;
begin
     WaitCursor;
     Obj.objID := -1;
     OPattern  := OPattern + #0;
     Repeat
     cCode := NWScanObject(connID, @OPattern[1], OType, @Obj.objID, @Obj.objName[1],
              @Obj.objType, @Obj.hasPropertiesFlag, @Obj.objFlags, @Obj.objSecurity);
     IF cCode = 0 THEN BEGIN
        ObjectName := StrPas(@Obj.objName[1]);
        NewPos := TargetList.Items.IndexOf(ObjectName);
        IF (NewPos=-1) THEN NewPos := TargetList.Items.Add(ObjectName);
        IF (NewPos=-1) THEN TargetList.ItemIndex := NewPos;
        END;
     Until cCode > 0;
     NormalCursor;
end;


procedure ListBoxAddMembers(Sender: TObject; connID: NWCONN_HANDLE; VAR TargetList: TListBox;
                            objectName: String; objectType: nuint16; propertyName: String);
TYPE readPropValueRep = RECORD
     dataSetIndex:      NWSEGMENT_NUM;
     data:              Array[1..32] of nuint32;
     moreFlag:          NWFLAGS;
     propertyFlags:     NWFLAGS;
     END;
TYPE TBinderyObject = RECORD
     ObjectID:          NWOBJ_ID;
     ObjectType:        NWOBJ_TYPE;
     ObjectName:        String;
     END;
VAR
    prop:              readPropValueRep;
    ReadMore:          Boolean;
    Mmb:               TBinderyObject;
    i:                 Byte;
BEGIN
    prop.dataSetIndex := 1;
    TerminateString(objectName);
    TerminateString(propertyName);
    REPEAT
     FillChar(prop.data, sizeOf(prop.data), 0); 
     cCode := NWReadPropertyValue(connID, @objectName[1], objectType, @propertyName[1], prop.dataSetIndex,
              @prop.data, @prop.moreFlag, @prop.propertyFlags);
     ReadMore := (prop.moreFlag<>0) and (cCode=0);
     IF (cCode=0) THEN BEGIN
	FOR i := 1 to 32 DO BEGIN
	    IF (prop.data[i] = 0) THEN break;
            cCode := NWGetObjectName(connID, prop.data[i], @Mmb.ObjectName[1], @Mmb.ObjectType);
            if cCode=0 then TargetList.Items.Add(StrPas(@Mmb.ObjectName[1]));
	    END;       {For i ..}
        END;
     Inc(prop.dataSetIndex);
    UNTIL Not ReadMore
END;           {ListBoxAddMembers}



procedure IniWriteString(IniName: String; Section, Ident, Value: String);
var NW4Ini: TIniFile;
begin
   NW4Ini := TIniFile.Create(IniName);
   NW4Ini.WriteString(Section, Ident, Value);
   NW4Ini.Free;
end;

Function  IniReadString(IniName: String; Section, Ident, Default: String): String;
var NW4Ini: TIniFile;
begin
   NW4Ini := TIniFile.Create(IniName);
   IniReadString := NW4Ini.ReadString(Section, Ident, Default);
   NW4Ini.Free;
end;

procedure IniWriteInt(IniName: String; Section, Ident: String; Value: Integer);
var NW4Ini: TIniFile;
begin
   NW4Ini := TIniFile.Create(IniName);
   NW4Ini.WriteInteger(Section, Ident, Value);
   NW4Ini.Free;
end;

Function  IniReadInt(IniName: String; Section, Ident: String; Default: Integer): Integer;
var NW4Ini: TIniFile;
begin
   NW4Ini := TIniFile.Create(IniName);
   IniReadInt := NW4Ini.ReadInteger(Section, Ident, Default);
   NW4Ini.Free;
end;

function GetBinderyObjectName(objID: nuint32; VAR Name: String): NWCCODE;
VAR
   objType : nuint16;
   objName : String;
   cCode :      NWCCODE;
begin
   cCode   := NWGetObjectName(connHandle, objID, @objName[1], @objType);
   if cCode<>0 then objName := #0;
   Name := StrPas(@objName[1]);
   GetBinderyObjectName := cCode;
end;

function GetNDSObjectName(objID: nuint32; VAR Name: String): NWCCODE;
VAR
   context :    NWDSContextHandle;
   conn :       NWCONN_HANDLE;
   objName :    String;
   cCode :      NWCCODE;
begin
   context := NWDSCreateContext;
   cCode := NWDSMapIDToName(context, connHandle, objID, @objName[1]);
   if cCode<>0 then objName := #0;
   Name := StrPas(@objName[1]);
   GetNDSObjectName := cCode;
   if cCode >= 0 then cCode := NWDSFreeContext(context);
end;

function GetObjNameFromID(objID: nuint32; VAR objName: String): NWCCODE;
VAR cCode   : NWCCODE;
begin
   cCode := GetNDSObjectName(objID, objName);                       { NDS object ? }
   if cCode<>0 then cCode := GetBinderyObjectName(objID, objName);  { bindery object ? }
   GetObjNameFromID := cCode;
end;






end.

