{$M 16384, 0, $40000}

{
  PWD_TEST is a little program to demonstrate usage of PWD.TPU

  Use it with a test user named 'TEST' and a password 'DEF' created 
  with SYSCON.  It calls the PWD.TPU functions and prints the 
  completion code (0=successful).
}

uses crt, PWD;

VAR    P1, P2  : String[80];
CONST  OT_User = 1;

begin
   P1 := 'DEF';
   P2 := 'XYZ';

   ClrScr;

   WriteLn(VerifyBinderyObjectPassword('TEST', OT_User, P1));
   WriteLn(VerifyBinderyObjectPassword('TEST', OT_User, P2));

   WriteLn(ChangeBinderyObjectPassword('TEST', OT_User, P1, P2));

   WriteLn(VerifyBinderyObjectPassword('TEST', OT_User, P1));
   WriteLn(VerifyBinderyObjectPassword('TEST', OT_User, P2));

   {
   The next function will logout and login with a new name.
   Be sure to save your test program before calling this function !
   }

   {
   WriteLn(LoginToFileServer('TEST', OT_User, P2));
   }
end.