unit PWD;

{
Purpose:      Use password encryption from Turbo Pascal v6.0 programs.

              This TPU emulates the 3 password functions provided by
              Novell's CLIB and implements basically the same syntax as
              Novell's library functions.

Author:       Dr. Wolfgang Schreiber, Novell Dsseldorf     (Dec 91)

Background:   Password encryption currently can only be implemented
              with Novell's CLIB. Other applications may have problems with
              NetWare's password APIs if they are not using the C library.

              Some servers running NetWare 386 however will only accept
              encrypted passwords (for security reasons).
              This limits the functionality of programs written without
              Novell's CLIB.  3 functions are affected:
                   ChangeBinderyObjectPassword
                   VerifyBinderyObjectPassword
                   LoginToFileServer

              PWD.TPU is a workaround until Novell offers a better
              solution; it uses a small external routine (PWD_C.EXE) to
              encrypt passwords.

Usage:        Include PWD.TPU in a 'USES' statement of your application.
              PWD_C.EXE must be in one of your search mappings or in your
              current drive whenever your application is called.

              All 3 functions return the completion code as words;
              see detailed return codes below.
              An example for usage is attached as PWD_TEST.PAS.

Limitations:  - Uses an external PWD_C.EXE program (written with CLIB);
                Only operational with PWD_C.EXE accessible during runtime.
              - Slower performance than with internal functions only;
              - The main routine must restrict its memory usage to
                allow some space for PWD_C.EXE: include a line like
                [$M 16384, 0, $30000]     at the beginning of each
                program that uses PWD.TPU (see example: PWD_TEST.PAS)


Return Codes:   Return codes are identical to the return codes from
                CLIB / API calls.  In addition to those, DOS errors
                may occur due to incorrect access to PWD_C.EXE

                0  Successful
                2  File not found     (PWD_C.EXE not in PATH)
                3  Path not found
                5  Access denied
                6  Invalid handle
                8  Not enough memory  (use/modify heap in $M statement)
               10  Invalid environment
               11  Invalid format
               18  No more files
              150  Server out of memory
              240  Wildcard not allowed
              251  No such property
              252  No such object
              254  Server bindery locked
              255  No such object / bad password

}

interface

uses DOS;

TYPE Str48 = String[48];
     Str80 = String[80];

FUNCTION ChangeBinderyObjectPassword(Name: Str48; ObjType: word; PW1, PW2: Str80): Word;
FUNCTION VerifyBinderyObjectPassword(Name: Str48; ObjType: word; PW1: Str80): Word;
FUNCTION LoginToFileServer(Name: Str48; ObjType: word; PW1: Str80): Word;


implementation

Function itoa(i : LongInt): Str48;
{	Integer to String conversion}
VAR S_Temp : Str48;
BEGIN
  Str(i, S_Temp);
  itoa := S_Temp
END;


FUNCTION Call_PWD(Fct: BYTE; Name: Str48; ObjType: Word; PW1, PW2: Str80): Word;
BEGIN
   SwapVectors;       
   Exec(FSearch('PWD_C.EXE', GetEnv('PATH')),  itoa(Fct)+' '+Name+' '+itoa(ObjType)+' '+PW1+' '+PW2);
   SwapVectors;
   IF DosError = 0 THEN Call_PWD := DOSExitCode
                   else Call_PWD := DOSError;
END;


FUNCTION ChangeBinderyObjectPassword(Name: Str48; ObjType: word; PW1, PW2: Str80): Word;
BEGIN
   ChangeBinderyObjectPassword := Call_PWD(1, Name, ObjType, PW1, PW2);
END;

FUNCTION VerifyBinderyObjectPassword(Name: Str48; ObjType: word; PW1: Str80): Word;
BEGIN
   VerifyBinderyObjectPassword := Call_PWD(2, Name, ObjType, PW1, '');
END;

FUNCTION LoginToFileServer(Name: Str48; ObjType: word; PW1: Str80): Word;
BEGIN
   LoginToFileServer := Call_PWD(3, Name, ObjType, PW1, '');
END;

end.
