/****************************************************************************
**      DISCLAIMER  
**  
**   Novell, Inc. makes no representations or warranties with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.  
**
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
****************************************************************************
**   File:   PRINTJOB.C
**
**   Desc: This program will search for a print job record in the PRINTCON 
**         database. It will print out information then modify the job and 
**         save it to the same job name.
**   NOTE: The dbOwner must be found for each call to find the printcon
**         information so a loop will be needed to access the bindery
**         and find each user. 
**
**
**   Parameter descriptions:    > input
**                              < output
**
**   Programmers:
**   Ini   Who                  Firm
**   -----------------------------------------------------------------------
**   ARM   A. Ray Maxwell         Novell Developer Support.
**
**   History:
**
**   When      Who   What
**   -----------------------------------------------------------------------
**   08-02-94   ARM   First code.
*/

/****************************************************************************
**   Include headers, macros, function prototypes, etc.
*/



   /*------------------------------------------------------------------------
   **   ANSI
   */
   #include <stdio.h>
   #include <stdlib.h>
   #include <string.h>

   /*------------------------------------------------------------------------
   **   NetWare
   */
   #include <nwcalls.h>
   #include <nwps_job.h>
   #include <nwps_err.h>

   /*------------------------------------------------------------------------
   ** Defines
   */
   #define NWDOS

/****************************************************************************
**   Main program start
*/
void main(int argc,char *argv[])
{

   /*--------------------------------------------------------------------------
   ** NWPSJobGetFirstJob
   */
   NWCONN_HANDLE  connHandle;
   NWPS_Job_Rec   pJobRecord;
   NWPSListHandle hListHandle;
   char             dbOwner[48];
   char             pJobName[48];
   WORD             defaultPJ;
   WORD             ccode;
   int             globalConnType;
   /*--------------------------------------------------------------------------
   ** NOTE: The following parameter has been added to the SDK with the 4.1 
   **       release which is in beta as of 8/18/94 it was not available with
   **       the SDK v1.0e and therefore the functions wouldn't work with 3.x
   **       servers. i.e NWPS_BINDERY_SERVICE_PRE_40.(it is available with the
   **       4.02 sdk)
   */
   globalConnType=NWPS_BINDERY_SERVICE_PRE_40;


   ccode=NWCallsInit(NULL,NULL);
   if (ccode)
      exit(1);

	ccode = NWGetConnectionHandle(
            /* > server name        */ "PRV-DEVSUP",
            /*   Novell Reserved1   */ 0,
            /* < conn Handle        */ &connHandle,
            /*   Novell Reserved2   */ NULL);
   if (ccode)
      exit(1);

   strcpy (dbOwner,"SUPERVISOR"); /*user name of the printcon.dat file owner*/

   /*------------------------------------------------------------------------
   ** to get all the users on the server you will need to put a loop in that
   ** will find the username (dbOwner) then call the code listed below to
   ** get the printjob information.
   */

   if (globalConnType == NWPS_BINDERY_SERVICE_PRE_40)
   {
      ccode=NWPSJobGetFirstJob(
            /* > connType               */ globalConnType,
            /* > conn Handle            */ connHandle,
            /* > search flag            */ NWPS_EXTENDED_SEARCH,
            /* < pointer to handle
                 to be passed to  
                 NWPSJobGetNextJob      */ &hListHandle,
            /* <>pointer to start
                 point of the search
                 Output actual
                 location of job        */ dbOwner,
            /* < Pointer to first job   */ pJobName,
            /* < Default print job flag */ &defaultPJ);
      if(!ccode){
         do{
            ccode = NWPSJobRead(
                    /* > connType                 */ globalConnType,
                    /* > conn Handle              */ connHandle,
                    /* > username of owner of DB  */ dbOwner,
                    /* > ponter to name of job    */ pJobName,
                    /* < pointer to NWPS_Job_Rec  */ &pJobRecord);
            if (ccode)
               exit(1);

            printf("copies=%d\nlocalprinter=%d\nformname=%s\nbannerName=%s\n",
              pJobRecord.copies,
              pJobRecord.localPrinter,
              pJobRecord.formName,
              pJobRecord.bannerName);
			  printf("printserver name %s\n",pJobRecord.u.nonDS.printServer);
           /*----------------------------------------------------------------
           ** Change the print job record 
           */
           pJobRecord.copies=2;
           strcpy(pJobRecord.bannerName,"Rays_Banner");

           /*----------------------------------------------------------------
           ** If a print job record with the same name already exists, it is 
           ** overwritten with the data pointed to by the info in the pointer
           ** to name of print job record.
           */
           ccode=NWPSJobWrite(
						/* > connType                           */ globalConnType,
                  /* > conn Handle                        */ connHandle,
                  /* > pointer to username of owner of DB */ dbOwner,
                  /* > pointer to name of print job record*/ pJobName,
                  /* > pointer to NWPS_Job_Rec            */ &pJobRecord);

            printf("copies=%d\nlocalprinter=%d\nformname=%s\nbannerName=%s\n",
              pJobRecord.copies,
              pJobRecord.localPrinter,
              pJobRecord.formName,
              pJobRecord.bannerName);


         } while (!NWPSJobGetNextJob(
                    /* > value from NWPSJobGetFirstJob     */ hListHandle, 
                    /* < pointer to username ofowner of DB */ dbOwner,
                    /* < pointer to print job record found */ pJobName,
                    /* < pointer to defualt job flag       */ &defaultPJ));

         NWPSJobEndNextJob(hListHandle);
      }
   }

}
