' **************************************************************************
'
'       TAPE3LOG.BAS    By Bob Morrisson (rfm), MTI
'                       Modified heavily from a program by Charles John.
'
'       This program reads a copy of the Palindrome TMPSTAMP.LOG file and
'       prints a report showing each volume backed up, the number of files
'       protected, their total size (rounded up), and the megabytes per
'       minute written.  This information can also be copied to the file
'       LOG.FIL or displayed on the screen.  This versions works with the
'       Palindrome 3.1 NLM software.
'
'       For use by:     Pension Benefit Guarantee Corportion (PBGC)
'                       1200K St. NW.
'                       Washington, DC 20005-4026
'                       Phone: 202-326-4142 x6264
'
'       Use by others is at their own risk.
'
' **************************************************************************
'
'       Requirements to use this program:
'
'       1.      Create a ONE LINE file named TAPE3LOG.NAM; this line must
'               contain the backup system name you want printed on each
'               page of the reports.  You may bypass this feature.  Go to
'               Line 55100 and do what it says.  To create the TAPE3LOG.NAM
'               file, simply type:
'
'                       COPY CON: TAPE3LOG.NAM
'                       <System Name> ^Z        (That is, control-Z.)
'
'       2.      Ensure all backups are done with the /TS switch!!!  This
'               creates the TMPSTAMP.LOG file as the backups run.
'
'       3.      You must have a printer or be captured to the network.  It
'               is assumed that your printer is an HP LaserJet III or later.
'               You will have to change codes in 53300 for other printers.
'               A Form Feed is sent to the printer after the last page.
'
'       4.      When the backup has finished, copy the TMPSTAMP.LOG file
'               as TMPSTAMP.TMP.  Edit this file adding a blank line at
'               top and save this file.  This prevents you from receiving
'               an "Out of String Space " error.  The fault lies with the
'               way Palindrome closes (or doesn't properly close) their
'               TMPSTMP.LOG file; QBASIC can't deal with it.
'
'       5.      Note that the elapsed time includes history database
'               maintenance for checkpoints and saves but not for exports.
'               Note also that the Export total gives you a general idea
'               of your volume usage, if you export all volumes.
'
' *************************************************************************

'          REVISION HISTORY

'01/31/95 Released this program upon an unsuspecting world!  rfm
'02/11/95 Fixed screen pagination problem; changed to 19 lines from 20.
'02/26/95 Search for "NLM *" from the right; allow version names to change.
'03/03/95 Added FS and FC types.
'03/14/95 Fixed 3.1a2 problem; ROOT and NDS not printing. See 1080 and 6000.
'03/20/95 Fixed problem with export totals bumping unread text off screen.
'04/24/95 Changed line count on the report to 71 so it will fit in a
'         Word Perfect file; used variable MAXLINE% to do this.
'05/18/95 Bindery file count was reporting prior value if backup failed.
'05/18/95 If history is opened and then closed, volume now reports as FAILED!
'05/18/95 Root object now reports as .[ROOT], which is correct NovellSpeak.
'05/18/95 Added flagging for tape changes - puts a * after the backup type.
'
'
								       
' *************************************************************************
'
'       And away we go...
'       (The line numbers should make following this easier)

1000    'We do the usual housekeeping...
	CLEAR
	GOSUB 53000                     'Select Screen, Printer, or File
	GOSUB 55000                     'Get the system name, etc.

1020    'Read the timestamp log looking for telltale messages.
	'Print the number of lines per page in MAXLINE%
	MAXLINE% = 71
	DO UNTIL EOF(1)
	LINE INPUT #1, l$
	IF lncount% > MAXLINE% THEN GOSUB 14000
'         *******************************************************
'        *********************************************************
'       ***  Did you get an  "Out of String Space"  error?      ***
'      ****  If so, open the file TMPSTMP.TMP with an editor.   ****
'      ****  Add a space or line at the top and then save the   ****
'      ****  file.  Then run this program again.                ****
'      ****                                                     ****
'      ****  The problem is with QBASIC; you just have to do    ****
'       ***  it this way.                                       ***
'        *********************************************************
'         *******************************************************

       

1030    'Check for "nuisance" lines, loop back to the next line.
	IF MID$(l$, 13, 4) = "Idle" THEN GOTO 1200
	IF MID$(l$, 13, 18) = "Checking for media" THEN GOTO 1200
	IF MID$(l$, 13, 19) = "Waiting media ready" THEN GOTO 1200

1040    'Check for a command, start of backup, or comments.
       
	IF LEFT$(RIGHT$(l$, 14), 5) = "NLM *" THEN GOSUB 5000
	'IF MID$(l$, 53, 5) = "NLM *" THEN GOSUB 5000
	IF MID$(l$, 13, 24) = "Opening History Database" THEN
		GOSUB 6000
		savetype$ = "--"
		END IF
	IF MID$(l$, 1, 2) = "**" THEN comment$ = l$: GOSUB 5500

1050    'Determine the type of backup.
	IF MID$(l$, 13, 16) = "Incremental Save" THEN savetype$ = "IS"
	IF MID$(l$, 13, 13) = "Modified Save" THEN savetype$ = "MS"
	IF MID$(l$, 13, 9) = "Full Save" THEN savetype$ = "FS"
	IF MID$(l$, 13, 22) = "Incremental Checkpoint" THEN savetype$ = "IC"
	IF MID$(l$, 13, 19) = "Modified Checkpoint" THEN savetype$ = "MC"
	IF MID$(l$, 13, 15) = "Full Checkpoint" THEN savetype$ = "FC"
	IF MID$(l$, 13, 11) = "Full Export" THEN savetype$ = "FX"
	IF MID$(l$, 13, 16) = "Selective Export" THEN savetype$ = "SX"
      
1060    'The backup report begins!
	IF MID$(l$, 13, 16) = "Scheduled Files:" THEN GOSUB 10000
	'GOTO 1200
	  
1070    'Check for Export or Incremental; print as necessary.
	IF savetype$ = "FX" OR savetype$ = "SX" THEN GOTO 6300

1080    'The Novell$ check is for 3.1a2 NLM; they don't do "Writing History..."
	IF savetype$ = "--" AND MID$(l$, 13, 24) = "Closing History Database" THEN
		GOSUB 7000
		GOTO 1200
		END IF
	IF novell$ = "1" AND MID$(l$, 13, 24) = "Closing History Database" THEN GOSUB 7000
	IF novell$ = "0" AND MID$(l$, 13, 19) = "Updating History On" THEN GOSUB 7000
	GOTO 1200

1090    'This stuff is on "HOLD" until we figure out what/if to do with it
	'IF MID$(l$, 13, 25) = "Writing session directory" THEN GOSUB 7000
	'IF MID$(l$, 13, 13) = "Closing media" THEN GOSUB 7000

1100    'Here is where exports begin printing.
	IF MID$(l$, 13, 15) = "Writing catalog" THEN GOSUB 7000

1200    'We get here after working with a line from the timestamp log.
	'We ignore "nuisance" lines and go until we run out of data.
	'When done, print the report, kick out the last page, do a reset.
       
	LOOP

1210    'Print total bytes backed up.
	IF lncount% > MAXLINE% AND output$ <> "S" THEN PRINT CHR$(10)
	PRINT #3, TAB(10);
	COLOR 14, 1
	IF output$ = "S" THEN INPUT "Press ENTER to continue  ", dummy$
	PRINT #3,
	PRINT #3, TAB(mrg% + 25);
	PRINT #3, "Total megabytes EXPORTED:  ";
	PRINT #3, USING "###,###"; expbytes#
	COLOR 7, 1
       
'1215    'If we do NOT send to screen, display export megabytes anyway
'        IF expbytes# > 1 THEN
'                PRINT #3, : PRINT #3,
'                COLOR 14, 1
'                INPUT "Press ENTER to continue  ", dummy$
'                COLOR 7, 1
'                LOCATE 18, 10
'                PRINT
'                PRINT TAB(25); "Total megabytes exported:  ";
'                PRINT TAB(25); USING "###,###"; expbytes#
'        END IF

1220    'Pause screen before quitting
	IF output$ = "S" THEN
		PRINT " "
		COLOR 14, 1
		LOCATE 22, 10
		INPUT "Press ENTER to continue  ", dummy$
		COLOR 7, 1
		END IF
	CLOSE #1
	PRINT #3, CHR$(12);
       
1230    'Reset printer
	IF output$ = "P" THEN PRINT #3, reset$
	CLOSE #3
	PRINT "  "
	COLOR 7, 1
	SYSTEM

	'*****  All the lines above are the basic program.  *****
	'*****                                              *****
	'*****  The lines below are what makes it work.     *****

5000    'If a line has a start date, we get the date ready to print
	Startdate$ = "1"
	Dstarted$ = MID$(l$, 59, 5)
	RETURN

5500    'We print any lines that are remarks; these start with ***.
	PRINT #3, TAB(mrg%); l$
	IF output$ <> "S" THEN lncount% = lncount% + 1
	IF output$ = "S" THEN
		scrnlns% = scrnlns% + 1
		GOSUB 12000
		END IF
	RETURN

6000    'Set up to print incrementals:  Time, server volume
	shour$ = MID$(l$, 1, 2)
	sminute$ = MID$(l$, 4, 2)
	server$ = LTRIM$(MID$(l$, 37, LEN(l$) - 37))
	GOSUB 6400                              'Fix Bindery, NDS, Root
	K = 20 - LEN(server$)
	FOR i = 1 TO K
		server$ = server$ + " "
	NEXT i
	RETURN

6300    'Set up to print exports:  Time, server volume
	'Novell$ is not needed here; exports don't close the history DB
	IF MID$(l$, 13, 12) = "Copying From" THEN
	shour$ = MID$(l$, 1, 2)
	sminute$ = MID$(l$, 4, 2)
	server$ = LTRIM$(MID$(l$, 25, LEN(l$) - 25))
	GOSUB 6400                              'Fix Bindery, NDS, Root
	K = 20 - LEN(server$)
	FOR i = 1 TO K
	server$ = server$ + " "
	NEXT i
	END IF
	GOTO 1100

6400    'Fix Bindery, NDS, and .ROOT backups.
	'NLM 3.1a2 needs the Novell variable; they don't do a
	'"Writing history Database" any more.
	novell$ = "0"
	IF RIGHT$(server$, 7) = "/Binder" THEN                  'Fix Bindery
		server$ = MID$(server$, 1, LEN(server$) - 7)
		server$ = server$ + "  <<Bindery>>"
		novell$ = "1"
		END IF
	IF RIGHT$(server$, 21) = "/Full Directory Backu" THEN   'Fix NDS
		server$ = MID$(server$, 1, LEN(server$) - 21)
		server$ = server$ + "  << NDS >>"
		novell$ = "1"
		END IF
	IF RIGHT$(server$, 7) = "/.[Root" THEN                  'Fix .Root
		server$ = MID$(server$, 1, LEN(server$) - 7)
		server$ = server$ + "  <<.[Root]>>"
		novell$ = "1"
		END IF
	RETURN


6500    'Print data for exports.
	PRINT "We got to 6500!  "
	IF MID$(l$, 13, 13) = "Closing media" THEN GOSUB 7000

6800    'Get start time for histories
	'PRINT "We are looking at the histories..."
	'RETURN                          'Later, Charlie!

7000    'Get ending time:  Hour and Minute
	EHOUR$ = MID$(l$, 1, 2)
	EMINUTE$ = MID$(l$, 4, 2)
	EHOUR% = INT(VAL(EHOUR$))
	EMIN% = INT(VAL(EMINUTE$))
	shour% = INT(VAL(shour$))
	SMIN% = INT(VAL(sminute$))
	IF EHOUR% < shour% THEN EHOUR% = EHOUR% + 24
	IF EMIN% < SMIN% THEN EHOUR% = EHOUR% - 1
	IF EMIN% < SMIN% THEN EMIN% = EMIN% + 60
      
7150    'Get elapsed hours and minutes.  We convert this to minutes.
	elapsehr% = EHOUR% - shour%
	elapsemin% = EMIN% - SMIN%
	elapsetime% = (elapsehr% * 60) + elapsemin%
       
7200    'Compute and print everything!
	GOSUB 10600             'Compute megabytes per minute
	GOSUB 11000
	GOSUB 54000             'Clear variables
	RETURN

'       ***  All the calculations happen here   ***

10000   'Determine number of megabytes and bytes
	bigdisk$ = " "
	IF MID$(l$, 67, 1) = "G" THEN           'Volume is x.xxxG
		bigdisk$ = "1"
		gbytes$ = MID$(l$, 60, 3):      'Allow up to 999 gig
		mbytes$ = MID$(l$, 64, 3):      'Determine meg
		kbytes$ = "000"
		ubytes$ = "000"
		GOTO 10100

	ELSEIF MID$(l$, 67, 1) = "M" THEN       'Volume is x.xxxM
		bigdisk$ = "2"
		gbytes$ = MID$(l$, 57, 3):      'Allow up to 999 gig
		mbytes$ = MID$(l$, 60, 3):      'Determine meg
		kbytes$ = MID$(l$, 64, 3)
		ubytes$ = "000"
		GOTO 10100
       
	ELSE bigdisk$ = "0"                     'Volume is in bytes
		gbytes$ = "000"
		mbytes$ = MID$(l$, 57, 3)
		kbytes$ = MID$(l$, 61, 3)
		ubytes$ = MID$(l$, 65, 3)
	END IF

10100   'We convert the strings to megabytes.
	ubytes% = VAL(ubytes$)                  'This isn't printed
	kbytes% = VAL(kbytes$)
	mbytes% = VAL(mbytes$)                  'We are working in meg
	gbytes% = VAL(gbytes$) * 1000           'Extend gig to 1000 meg
	  
10200  'We work the string into a number, convert it to .K Bytes
	totalbytes$ = gbytes$ + mbytes$ + kbytes$ + ubytes$
	totalxbytes# = CLNG(VAL(totalbytes$) / 100000)
	totalkbytes! = totalxbytes# / 10
	IF savetype$ = "FX" OR output$ = "SX" THEN
		expbytes# = expbytes# + (totalxbytes# / 10)
		END IF

10300   'If a volume reports a 0 but has a few bytes, we flag the column.
	note1$ = "Z"
	IF totalkbytes! = 0 AND (kbytes% + ubytes%) > 0 THEN note1$ = "<.1m"

10400   'Get the number of files copied, convert to a number
	mfiles$ = MID$(l$, 32, 3)               'Up to 999,999,999 files
	kfiles$ = MID$(l$, 36, 3)
	ufiles$ = MID$(l$, 40, 3)
	files$ = (mfiles$ + kfiles$ + ufiles$)  'String, if we need it
	tfiles# = VAL(files$)                   'This is the number to print

10500   'We total up the files and capacity backed up.

	'Later, Charlie!

10600   'Compute megabytes per minute
	mbpermin = 0
	TTIME% = INT((elapsehr% * 60) + elapsemin%)
	IF TTIME% > 0 THEN mbpermin = (totalkbytes! / TTIME%)
	RETURN

10700   'Zilch.  Nada.  You get bupkis!

'       ***  Print Detail Line  ***

11000  'Let's start printing!   Check for duplicate volume = tape change.
	IF server$ = SAVESERV$ AND SAVESERV$ <> " " THEN tape$ = "1"
	PRINT #3, TAB(mrg%); Dstarted$;
	PRINT #3, TAB(mrg% + 7); MID$(shour$, 1, 2) + ":" + MID$(sminute$, 1, 2);
	PRINT #3, TAB(mrg% + 13); MID$(EHOUR$, 1, 2) + ":" + MID$(EMINUTE$, 1, 2);
	PRINT #3, TAB(mrg% + 21); USING "####"; elapsetime%;
	PRINT #3, TAB(mrg% + 27); LEFT$(server$, 20);
	IF savetype$ = "--" THEN
		PRINT #3, TAB(mrg% + 54); "<<<   FAILED!   >>>"
		GOTO 11100
		END IF
	IF note1$ = "Z" THEN
		PRINT #3, TAB(mrg% + 47); USING "###,###.#"; totalkbytes!;
		ELSE PRINT #3, TAB(mrg% + 51); note1$;
		END IF
	PRINT #3, TAB(mrg% + 57); savetype$;
	IF tape$ = "1" THEN               'Look for tape change
		tape$ = "0"
		PRINT #3, "*";
		END IF
	PRINT #3, TAB(mrg% + 61); USING "###,###"; tfiles#;
	PRINT #3, TAB(mrg% + 70); USING "###.#"; mbpermin;
       
11100   IF output$ = "P" THEN PRINT ".";        'Displays . as we work
	IF output$ = "F" THEN PRINT "*";        'Displays . as we work    
	IF output$ <> "S" THEN lncount% = lncount% + 1
	IF output$ = "S" THEN
		scrnlns% = scrnlns% + 1
		GOSUB 12000
		END IF
      
11200

	savetype$ = " "
	Dstarted$ = " "
	Startdate$ = "0"
	SAVESERV$ = server$
	RETURN

12000   'Hold the screen when full
	IF scrnlns% = 16 THEN
		LOCATE 22, 10
		COLOR 14, 1
		INPUT "Press ENTER to continue...   ", dummy$
		COLOR 7, 1
		CLS 2
		scrnlns% = 1
		END IF
	RETURN

14000   'We print the page heading here
	IF page% > 0 AND output$ = "P" THEN PRINT #3, CHR$(12)
	page% = page% + 1
	page$ = LTRIM$(STR$(page%))
       
	'This could be altered to read a title from the #2 file.
	title$ = "DAILY PALINDROME ANALYSIS - " + Systemname$
       
	'LINE 1
	PRINT #3, TAB(mrg% + (LEN(title$) / 2)); title$;
	PRINT #3, TAB(mrg% + 68); "Page: " + page$
	PRINT #3, TAB(mrg%); reportdate$

	'LINE 2
	PRINT #3, TAB(mrg%); "Date";
	PRINT #3, TAB(mrg% + 7); "START  STOP";
	PRINT #3, TAB(mrg% + 19); "ELAPSED";
	PRINT #3, TAB(mrg% + 27); "SERVER / Volume";
	PRINT #3, TAB(mrg% + 51); "Volume MB";
	PRINT #3, TAB(mrg% + 63); "Files";
	PRINT #3, TAB(mrg% + 71); "MB/Min"

	'LINE 3
	PRINT #3, TAB(mrg% + 19); "Minutes";
	PRINT #3, TAB(mrg% + 52); "and Type"
	
	'LINE 4 and end
	PRINT #3,
	lncount% = 9
	IF output$ = "S" THEN VIEW PRINT 6 TO 22
	RETURN

23000   PRINT "  OOOhhhhh nnooooo!  We got to 23000!  "
	'Convert Kbytes to Mbytes and Kbytes; obsolete but let's keep it.
	mbytes% = mbytes% + INT(kbytes% / 1000)
	kbytes% = kbytes% - (INT(kbytes% / 1000) * 1000)
	RETURN

24000   'Convert elapsed time to hours and minutes
	TELAPSEHR% = TELAPSEHR% + INT(TELAPSEMIN% / 60)
	TELAPSEMIN% = TELAPSEMIN% - (INT(elapsemin% / 60) * 60)
	RETURN

53000   'Choose screen or printer; set up printer
	COLOR 7, 1
	CLS
	LOCATE 18, 10
	PRINT "Send report to ";
	COLOR 14, 1: PRINT TAB(27); "S"; : COLOR 7, 1: PRINT "creen  "
	COLOR 14, 1: PRINT TAB(27); "P"; : COLOR 7, 1: PRINT "rinter";
	COLOR 14, 1: PRINT TAB(27); "F"; : COLOR 7, 1: PRINT "ile "; ""
	LOCATE 18, 37
	COLOR 14, 1
	INPUT "  Please choose:  ", output$             'Output Type
	COLOR 7, 1
	CLS
	output$ = UCASE$(output$)
	 
	SELECT CASE output$
	CASE IS = "P"
		OPEN "LPT1:" FOR OUTPUT AS #3
		WIDTH #3, 100
	CASE IS = "S"
		OPEN "SCRN:" FOR OUTPUT AS #3
		scrnlns% = 1
	CASE IS = "F"
		OPEN "LOG.FIL" FOR OUTPUT AS #3
	CASE ELSE
		GOTO 53000
	END SELECT

53100   'Get date to print on report
	IF output$ = "P" OR output$ = "F" THEN
		CLS
		LOCATE 18, 10
		PRINT TAB(10); "Please enter REPORT DATE to be printed.  "
		PRINT TAB(10); "You may enter up to 10 characters.  "
		LOCATE 21, 10
		COLOR 14, 1
		INPUT "Enter the date here:  ", reportdate$
		COLOR 7, 1
		PRINT " ": PRINT "  "
		CLS 2
		LOCATE 21, 10
		COLOR 14, 1
		PRINT "Please wait..."
		PRINT " ": PRINT " "
		END IF
     
53200   'Pagination control, margins, spaces.  Allow 1st page to print.
	lncount% = 80                                   'Let 1st page print
	IF output$ = "S" THEN mrg% = 0 ELSE mrg% = 8    'Set margin
	page% = 0
	sp1$ = " "                                      'One space
	sp2$ = "  "                                     'Two spaces
	sp3$ = "   "
	sp4$ = "    "
	sp5$ = "     "                                  'Oh, you get the idea!
      
53300   'Variables to set type style variables for Laserjet III
	RESETP$ = CHR$(27) + "E"                        'HP Reset
	LINES6$ = CHR$(27) + "&l6D"                     '6 Lines per inch
	LINES8$ = CHR$(27) + "&l8D"                     '8 Lines per inch
	ORIENP$ = CHR$(27) + "&l0O"                     'Portrait
	OrienL$ = CHR$(27) + "&l1O"                     'Landscape
	FONT10$ = CHR$(27) + "(s0P" + CHR$(27) + "&k0S" '10 pitch
	FONT12$ = CHR$(27) + "(s0P" + CHR$(27) + "&k4S" '12 pitch
	Font17$ = CHR$(27) + "(s0P" + CHR$(27) + "&k2S" '17 pitch
	SYMSET$ = CHR$(27) + "(10U"                     'PC-8
	FTCOUR$ = CHR$(27) + "(s3T"                     'Courier fixed
	char01$ = CHR$(27) + "(001X"                    'Font 001 standard

'       Set chosen type style; for now we use 12 pitch portrait, 8 LPI.
'       Some day we could allow the user to customize this during printing.

53400   'Reset the printer and set the HP Laserjet type style if printing.
	IF output$ = "P" THEN
	PRINT #3, RESETP$
	typestyle$ = LINES8$ + ORIENP$ + SYMSET$ + FONT12$ + char01$
	PRINT #3, typestyle$
	END IF
	RETURN

54000   'Clear the variables
	shour$ = " ": sminute$ = " "
	EHOUR$ = " ": EMINUTE$ = " "
	server$ = " "
	elapsehr$ = " ": elapsemin$ = " "
	bytes$ = " ": kbytes$ = " ": mbytes$ = " ": EHOUR% = 0
	EMIN% = 0: shour% = 0: SMIN% = 0
	bigdisk$ = "0"
	mbytes% = 0: kbytes% = 0: mbpermin = 0
	ubytes$ = " ": kbytes$ = " ": mbytes$ = " ": gbytes$ = " "
	totalbytes$ = " ": totalkbytes$ = " ": totalxbytes$ = " "
	volumesize$ = " ": volumebytes$ = " "
	mfiles$ = " ": kfiles$ = " ": ufiles$ = " ": files$ = " "
	tfiles$ = " ": tfiles# = 0
	RETURN

55000   'We get the system name and open the data file.
	OPEN "TMPSTAMP.TMP" FOR INPUT AS #1     'Copy of timestamp log

55100   'You need TAPE3LOG.NAM on your hard drive; see opening remarks.
	'** OR ** un-REMark the next 2 lines and insert the name of
	'your backup system, e.g. "Western Widgets ".  NO spaces allowed!!!

	REM     Systemname$ = "  < Insert your name here >  "
	REM     Goto 55400                      'Bypass name file

55200   OPEN "TAPE3LOG.NAM" FOR INPUT AS #2     'Get system name
      
	'          *******************************************
	'         *********************************************
	'        **                                           **
	'       ***                   OOPS!                   ***
	'      ****  If the system stopped and you are here,  ****
	'      ****  Did you create the TAPE3LOG.NAM file?    ****
	'      ****  OK, so you forgot.  Just check the       ****
	'       ***  instructions at the top of this file.    ***
	'        **                                           **
	'         *********************************************
	'          *******************************************


55300   Systemname$ = " "
	IF output$ = "S" THEN RETURN
	DO WHILE NOT EOF(2)
	LINE INPUT #2, Systemname$
       
55400   CLS
	LOCATE 18, 10
	COLOR 7, 1
	PRINT TAB(18); "Preparing backup report for";
	COLOR 14, 1: PRINT TAB(46); Systemname$
	COLOR 7, 1: PRINT TAB(18); "Report date: ";
	COLOR 14, 1: PRINT TAB(46); reportdate$
	PRINT " ": PRINT " "
	COLOR 7, 1
	LOOP
	RETURN



