;
;NewNode.ASM -- Node finder for NetWare
;
;     December 6, 1987
;
;
;
CSEG          Segment
              Assume  CS:CSEG,DS:CSEG
              Org     100h
Entry:                JMP     Begin
      DB      " NewNode (c) 1987 Jeffrey Diehl "
      DB      "Released to the Public Domain"
      DB      "Syntax: NewNode  "
      DB      "Output: Prints the 12-digit Hexidecimal"
      DB      " address of the workstation, then"
      DB      " converts the last two digits to"
      DB      " decimal."
      DB      "   The DOS IF ERRORLEVEL batch command"
      DB      " can use the return to branch."
CX4   DW      ?
BX4   DW      ?
AX4   DW      ?
PNODE DB      "The Node Address of this workstation"
      DB      " is",0Dh,0Ah,"$"
HEXI  DB      " Hexidecimal, or $"
DECI  DB      " Decimal.  $"
OOPS  DB      "OOPS! The NetWare shell returned a 0,"
      DB      " so you either don't have the shell loaded"
      DB      " or you are at a non-dedicated server,"
      DB      " or you don't have a network card!"
CRLF  DB      0Dh,0Ah,"$"
GETSTN        EQU     0DCh
GETNWAD       EQU     0EEh
PRTCHR        EQU     02h
PRTSTR        EQU     09h
DOS   EQU     21h
;
;
Begin:
;Set up a CRLF to the CRT
;
      MOV     DX,OFFSET CRLF
      MOV     AH,PRTSTR
      INT     DOS
;
;Send the first line to the CRT
;
      MOV     DX,OFFSET PNODE
      MOV     AH,PRTSTR
      INT     DOS
;
;See if the NetWare shell is active
;
      MOV     AH,GETSTN
      INT     DOS
;
      CMP     AL,0
      JA      GET_ADDR
No_NET:       MOV     DX,Offset OOPS
      MOV     AX4,1
      MOV     AH,PRTSTR
      INT     DOS
      JMP     OUT
;
GET_ADDR:
;Get the Address from the NetWare Shell
;
      MOV     AH,GETNWAD
      INT     DOS
;
;Now store off the address before messing with it
;
      MOV     AX4,AX
      MOV     BX4,BX
      MOV     CX4,CX
;
;But First check if NetWare returned ok address.
;If last two chars are 0, then check if last 8
; chars are 0, just to be certain.
;
      CMP     AX,0
      JA      NET_OK
      MOV     AX,BX
      CMP     AX,0
      JA      NET_OK
No_ADDR:
      MOV     DX,Offset OOPS
      MOV     AX4,1
      MOV     AH,PRTSTR
      INT     DOS
      JMP     OUT
;
NET_OK:
;Send the hex chars to the CRT four at a time.
;
      MOV     AX,CX4
      CALL    HEX4PRN
;
      MOV     AX,BX4
      CALL    HEX4PRN
;
      MOV     AX,AX4
      CALL    HEX4PRN
;
;
;Send the Hexi message to the CRT
;
      MOV     DX,OFFSET HEXI
      MOV     AH,PRTSTR
      INT     DOS
;
;
;Convert the last two digits to decimal for message
;
      SUB     AX,AX   ;Clear the accumulator
      MOV     AX,AX4  ;Put the last four hex into AL
      AND     AX,0FFh ; but only keep last two
      MOV     BL,100  ;Byte divisor
      DIV     BL      ;
      MOV     CH,AH   ;Keep remainder from AH
      ADD     AL,'0'  ; convert to ascii
      CALL    PRINTIT ;quotient in AL
;
      MOV     AL,CH   ;Get remainder back
      AND     AX,0FFh ;
      MOV     BL,10   ;
      DIV     BL      ;
      MOV     CH,AH   ;Keep remainder from AH
      ADD     AL,'0'  ;
      CALL    PRINTIT ;
;
      MOV     AL,CH   ;Get remainder back
      ADD     AL,'0'  ;
      CALL    PRINTIT ; and print it
;
;Send the Decimal message to the CRT
;
      MOV     DX,OFFSET DECI
      MOV     AH,PRTSTR
      INT     DOS
;
;Set up a CRLF to the CRT
;
      MOV     DX,OFFSET CRLF
      MOV     AH,PRTSTR
      INT     DOS
;
;Now get out!
;
OUT:  MOV     AX,AX4
;leave the DOS IF ERRORLEVEL
; value intact
      MOV     AH,4Ch
      INT     DOS
;
;
;Sub-Routines follow
;
HEX4PRN:
;Convert Hexi character in AX to ASCII
;
      MOV     BX,AX
      MOV     CL,04
      MOV     CH,04
;
LOOP: ROL     BX,CL
      MOV     AL,BL
      AND     AL,0Fh
      ADD     AL,90h
      DAA
      ADC     AL,40h
      DAA
      CALL PRINTIT
;
      DEC     CH
      JNZ     LOOP
;
      RET
;
PRINTIT:
;Single Character print AL=Char
;
      MOV     DL,AL
      MOV     AH,PRTCHR
      INT     DOS
      RET
;
CSEG  ENDS
      END     Entry
