/****************************************************************************
**      DISCLAIMER  
**  
**   Novell, Inc. makes no representations or warranties with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.  
**
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**   
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
****************************************************************************
**
**   File:   NETADDR.C
**
**   Desc: Program that allows a user to get the internet address i.e. 
**         network and node address of the workstation the program is run on.
**        
**
**   Parameter descriptions:    > input
**                              < output
**
**   Programmers:
**   Ini   Who         Firm
**   ------------------------------------------------------------------
**   ARM   A. Ray Maxwell     Novell Developer Support.
**
**   History:
**       
**   ------------------------------------------------------------------
**   10-07-94   ARM   First code.
*/

/****************************************************************************
** Include Headers, Macros & function Prototypes.
*/
   /*-------------------------------------------------------------------
   ** Borland C.
   */
   #include <stdio.h>
   #include <stdlib.h>
   #include <string.h>
   #include <conio.h>

   #define RETURN '\r'

   /*-------------------------------------------------------------------
   ** NetWare API's
   */
   #define NWDOS
   #include <nwcalls.h>


   typedef struct{
      BYTE network[4];
      BYTE node[6];
      WORD socket;
   }NETWORK_ADDRESS;


/****************************************************************************
** Program start.
*/
void main(void)
{
   NWCONN_HANDLE   connHandle;
   CONNECT_INFO    connInfo;
   NWCONN_NUM      connNumber;
   NWCCODE         ccode;
   NETWORK_ADDRESS netAdd;
   char            server[50];




   ccode = NWCallsInit(NULL, NULL);

   if(ccode){
     printf("ERROR: NWCallsInit failed %X\n",ccode);
      exit(1);
  }

   ccode = NWGetDefaultConnectionID(
           /* < connection Handle */ &connHandle);

   if(ccode){
     printf("ERROR: NWGetConnectionHandle failed %X\n",ccode);
      exit(1);
  }

  ccode = NWGetConnectionNumber(
          /* > NWCONN_HANDLE   */ connHandle,
          /* < NWCONN_NUM      */ &connNumber);
   if(ccode){
     printf("ERROR: NWGetConnectionNumber failed %X\n",ccode);
      exit(1);
  }

  ccode = NWGetInternetAddress(
          /* > NWCONN_HANDLE   */ connHandle,
          /* > NWCONN_NUM      */ connNumber,
          /* < NWNET_ADDR      */ (BYTE *) &netAdd);
   if(ccode){
     printf("ERROR: NWGetInternetAddress failed %X\n",ccode);
      exit(1);

  }

  printf("Network Address= %02X%02X%02X%02X\n",netAdd.network[0],
                                               netAdd.network[1],
                                               netAdd.network[2],
                                               netAdd.network[3]);

  printf("Node Address= %02X%02X%02X%02X%02X%02X\n", netAdd.node[0],
                                                    netAdd.node[1],
                                                    netAdd.node[2],
                                                    netAdd.node[3],
                                                    netAdd.node[4],
                                                    netAdd.node[5]);


}
                                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
