/*********************************************************************/
/*   The techniques contained in this sample program have not been   */
/*   subjected to any formal testing by Novell Inc., and are         */
/*   distributed on an "as is" basis without any warranty expressed  */
/*   or implied.                                                     */
/*   The use of this program, or the modification and use of this    */
/*   program, is the responsibility of the user, and depends on the  */
/*   user's ability to evaluate and integrate it into her, or his,   */
/*   own operational environment.                                    */
/*   While this code has been reviewed for accuracy in a specific    */
/*   situation, there is no guarantee that the same or similar       */
/*   results will be obtained elsewhere.                             */
/*   Customers attempting to adapt these techniques to their         */
/*   environments do so at their own risk.                           */
/*   Author:Geert Lingier                                            */
/*          Novell European Support Centre                           */
/*          Version 1.0 : jan 95                                     */
/*				Version 1.1:mai 96:smaller version for nda + NWCC API's  */
/*                  1.2:june 96:small adjustments to work with win95 */
/*********************************************************************/
/*
This program demonstrates the most used NDS functions + some of the
new Connection Services API's (NWCC...) .

Following operations are implemented:
 -Create and retrieve context information.
 -NDS login + logout
 -Search and List 
 -Create User
 -Read all attributes + values of a given object
 -Demonstrate how some of the new connection services api's work
 
To run  the program , first select option1 , to set a valid context.
If you are not already logged in , use option 2:NDS Login
The rest of the options,  are straightforward.

When doing a search operation , a choise can be made to return all
the attributes of a returned object , or a specific attribute.
Furthermore , only the attribute name ,or name + value can be selected



When reading an object , most syntaxes of the attributes are 
implemented, if not , the program displays the syntax id only .

The following syntaxes are implemented
SYN_BOOLEAN
SYN_COUNTER
SYN_INTEGER
SYN_TIME
SYN_INTERVAL
SYN_CE_STRING
SYN_CI_STRING
SYN_CLASS_NAME
SYN_DIST_NAME 
SYN_NU_STRING
SYN_PO_ADDRESS
SYN_PR_STRING
SYN_TEL_NUMBER
SYN_OCTET_STRING
SYN_OBJECT_ACL
SYN_FAX_NUMBER
SYN_CI_LIST
SYN_STREAM


The following API's are used:
NWDSAddObject
NWDSAddFilterToken
NWDSAllocBuf
NWDSAllocFilter
NWDSAuthenticate
NWDSComputeAttrValSize
NWDSCreateContext
NWDSFreeBuf
NWDSGetAttrCount
NWDSGetAttrName
NWDSGetAttrVal
NWDSGetContext
NWDSGetObjectCount
NWDSGetObjectName
NWDSInitBuf

NWDSList
NWDSLogout
NWDSOpenStream
NWDSPutAttrName
NWDSPutAttrVal
NWDSPutFilter
NWDSRead
NWDSSearch
NWDSSetContext
NWDSWhoAmI


NWCCGetConnRefInfo
NWCCGetAllConnRefInfo
NWCCOpenConnByName
NWCCScanConnRefs

NWGetMaximumConnections
NWGetConnectionList
NWGetConnectionStatus
NWGetFileServerName
NWFreeConnectionSlot
NWSetDefaultNameContext
*/

//#define N_PLAT_DOS 
/* for dos , else activate N_PLAT_MSW4 and N_ARCH_32 for win95*/

#define N_PLAT_MSW4
#define N_ARCH_32

#ifdef N_PLAT_WIN
#include <windows.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <nwnet.h>
#include <nwcalls.h>
#include <nwlocale.h>
#include <nwclxcon.h>
#include <alloc.h>
#include <time.h>
#include <io.h>

#ifdef N_PLAT_DOS
unsigned _stklen = 32 * 1024 ;
#endif

void ListSubordinates();
NWCONN_HANDLE OpenConnectionByname() ;
void GetContext();
int SetContext(void) ;
int InitNDSLogin(NWCONN_HANDLE *) ;
void FreeExit(void) ;
void NDSLogout(void);
int Menu(void) ;
void ReadObject(void);
void search(void) ;
void CreateUser(void) ;
void ReadBuffer(NWDSContextHandle , NWDS_BUFFER *,NWCOUNT,char *);
void HandleACL(NWDSContextHandle , NWDS_BUFFER *,  NWSYNTAX_ID);
void HandleCIList(NWDSContextHandle , NWDS_BUFFER *,  NWSYNTAX_ID);
void HandleOctetString(NWDSContextHandle, NWDS_BUFFER *,NWSYNTAX_ID);
void HandleFaxNr(NWDSContextHandle, NWDS_BUFFER * ,NWSYNTAX_ID);
void ReadStream(NWDSContextHandle,char *,char *);
void ScanConnRefs() ;
void GetAllConnRefInfo() ;

NWDSContextHandle      dContext;

void main()
{
NWCONN_HANDLE         connHandle;
int ans ;
char server[30] ;

if (!Init()) exit(1) ;
while(1)
	 {
	 ans = Menu() ;
	 switch(ans)
		 {
		 case 0:FreeExit() ;
		 case 1:SetContext() ;break ;
		 case 2:InitNDSLogin(&connHandle)  ;break ;
		 case 3:ReadObject(); break ;
		 case 4:search(); break ;
		 case 5:ScanConnRefs() ;break ;
		 case 11:GetContext();break ;
		 case 12:NDSLogout();break ;
		 case 13:CreateUser() ;break ;
		 case 14:ListSubordinates();break ;
		 case 15:GetAllConnRefInfo() ;break ;
		 default:printf("\nIllegal input \n") ;
		 }
	 }
}
/*-------------------------------------------------------------*/
int Menu()
{
int ans ;

printf("\n\n\t0:Exit + Cleanup\n")  ;
printf("\t1:Change/Set Context\t11:Display Current Context\n") ;
printf("\t2:NDSLogin\t\t12:NDSLogout\n") ;
printf("\t3:ReadObject\t\t13:Add User\n") ;
printf("\t4:Search\t\t14:List Subordinates\n") ;
printf("\t5:NWCCScanConnRefs\t15:NWCCGetAllConnRefInfo\n") ;
printf("\n\tChoise > ");
scanf("%d",&ans) ;
return(ans) ;
}

int Init()
{
  //	char far *countryPtr;
  //	LCONV lconvInfo ;
	NWDSCCODE cCode ;

	NWCallsInit(NULL, NULL);/*If not done , see what happens to ScanConnRefs*/

  /*With the 32 bit client , Unicode tables are automaticly initialized by NWcallsInit, 
  So no further need to call NWInitUnicodeTables
  	countryPtr = NWLsetlocale(LC_ALL, "" ) ;
  	NWLlocaleconv(&lconvInfo) ;
  
	cCode = NWInitUnicodeTables(lconvInfo.country_id,lconvInfo.code_page) ;
	if (cCode)
		{
		printf("NWInitUnicodeTables returns %x\n",cCode) ;
		return(0) ;
		}
	*/
	return(1) ;
}


void ListSubordinates()
{
NWDSCCODE  dsCode;
NWDS_ITERATION  it = -1L ;
NWDS_BUFFER *buf ;
NWCOUNT count ,attrCount;
NWOBJECT_INFO objInfo ;
char name[MAX_DN_CHARS] ;
int i ;
char obj[80] ;

dsCode = NWDSAllocBuf(DEFAULT_MESSAGE_LEN,&buf) ;
if (dsCode < 0)
			{
			printf("NWDSAllocBuf returns %d\n",dsCode) ;
			return ;
			}
printf("\nenter object to list subordinates of > ") ;
scanf("%s",obj) ;
/*due to the naming rule , make sure you enter a typed name , like OU=gl.O=ESC,
 else , enter for instance gl.esc and see what error you get */

do
	{
	dsCode = NWDSList(dContext,obj,&it,buf) ;
	if (dsCode < 0)
			{
			printf("NWDSList returns %d\n",dsCode) ;
			return ;
			}
	dsCode = NWDSGetObjectCount(dContext,buf,&count) ;
	if (dsCode < 0)
			{
			printf("NWDSGetObjectCount returns %d\n",dsCode) ;
			return ;
			}
	for (i = 0 ; i < count ; i++)
		{
		dsCode = NWDSGetObjectName(dContext,buf,name,&attrCount,&objInfo) ;
		if (dsCode < 0)
			{
			printf("NWDSGetObjectName returns %d\n",dsCode) ;
			return ;
			}
		else printf("%s\n",name);
		}
	} while (it != -1) ;

	NWDSFreeBuf(buf) ;
}


/*-------------------------------------------------------------*/


void CreateUser()
{
NWDS_BUFFER *inBuf;
NWDSCCODE  dsCode;
char  objName[MAX_DN_CHARS], surname[MAX_DN_CHARS], phone[14];
int               ch;
printf("\nEnter user name: ");
scanf("%s",objName);
printf("\nEnter surname: ");
scanf("%s",surname);
printf("\nEnter telephone number: ");
scanf("%s",phone);
dsCode = NWDSAllocBuf(DEFAULT_MESSAGE_LEN, &inBuf);
dsCode = NWDSInitBuf(dContext, DSV_ADD_ENTRY, inBuf);
dsCode = NWDSPutAttrName(dContext, inBuf, "Object Class");
dsCode = NWDSPutAttrVal(dContext, inBuf, SYN_CLASS_NAME, "User");
dsCode = NWDSPutAttrName(dContext, inBuf, "Surname");
dsCode = NWDSPutAttrVal(dContext, inBuf, SYN_CI_STRING, surname);
dsCode = NWDSPutAttrName(dContext, inBuf, "Telephone Number");
dsCode = NWDSPutAttrVal(dContext, inBuf, SYN_TEL_NUMBER, phone);
dsCode = NWDSAddObject(dContext, objName, NULL, 0, inBuf);
if(dsCode)
printf("\nUnable to create user.");
else
printf("\nUser %s has been added to Directory Services.",objName);
}
/*-------------------------------------------------------------*/

void search()
{
NWDSCCODE  dsCode;
NWDS_BUFFER *Filter,*AttrNamesBuf, *outBuf, *Current;
NWDS_ITERATION IterHandle = -1L;
NWDS_NUM_OBJ count ;
char clas[40] ,name[MAX_DN_CHARS],attrName[MAX_DN_CHARS],
	  baseObjName[MAX_DN_CHARS];
int i , ans , scope ;
NWDS_TYPE infotyp ;
NWDS_SEARCH_SCOPE sscope ;
NWFLAGS allAtrs ;
NWOBJECT_INFO objInfo ;
NWCOUNT totalObj,attrCount ;
NWDS_TOKEN tok;


	 printf("\nEnter class of object to search > ");
	 scanf("%s",clas) ;

	 printf("\nEnter root of subtree to search , cu for current cx > ");
	 scanf("%s",baseObjName);
	 if (strncmp(baseObjName,"cu",2) == 0 )
		 strcpy(baseObjName,"") ;

	 printf("\nName Attribute only : 0 ,All Attributes 1 > ");
	 scanf("%d",&ans) ;
	 allAtrs =  (ans == 0) ? 0x0000 : 0x0001 ;

	 printf("Attribute only : 0 , Attribute + val 1 > ");
	 scanf("%d",&ans) ;
	 infotyp = (ans == 0) ? DS_ATTRIBUTE_NAMES: DS_ATTRIBUTE_VALUES;


	 printf("Enter search scope 0:ENTRY  1:SUBORDINATES  2:SUBTREE > ") ;
	 scanf("%d",&ans) ;
	 switch (ans)
			  {
			  case 0:sscope = DS_SEARCH_ENTRY;break ;
			  case 1:sscope = DS_SEARCH_SUBORDINATES;break ;
			  case 2:sscope = DS_SEARCH_SUBTREE;break ;
			  default:printf("Illegal choise\n") ; return ;
			  }

	 dsCode = NWDSAllocBuf (DEFAULT_MESSAGE_LEN, &Filter);
	 dsCode = NWDSAllocBuf (DEFAULT_MESSAGE_LEN, &outBuf);
	 dsCode = NWDSAllocBuf (DEFAULT_MESSAGE_LEN, &AttrNamesBuf);

	 dsCode = NWDSInitBuf (dContext, DSV_SEARCH_FILTER, Filter);
	 dsCode = NWDSInitBuf (dContext, DSV_SEARCH, AttrNamesBuf);

	 dsCode = NWDSAllocFilter ((NWDS_FILTER_CURSOR NWFAR * NWFAR *) &Current);

	 dsCode = NWDSAddFilterToken ((NWDS_FILTER_CURSOR NWFAR *) Current,
										  FTOK_ANAME, "Object Class",(NWSYNTAX_ID)0);
	 dsCode = NWDSAddFilterToken ((NWDS_FILTER_CURSOR NWFAR *) Current,
										  FTOK_EQ, NULL, (NWSYNTAX_ID) 0);
	 dsCode = NWDSAddFilterToken ((NWDS_FILTER_CURSOR NWFAR *) Current,
									 FTOK_AVAL, clas, SYN_CLASS_NAME);

	 printf("\nDo search on specific attribute (y/n) > ");
	 scanf("%s",name) ;
	 if (name[0] == 'y')
	 {
	 dsCode = NWDSAddFilterToken ((NWDS_FILTER_CURSOR NWFAR *) Current,
										  FTOK_AND, NULL, (NWSYNTAX_ID) 0);
	 printf("\nEnter attribute + name > ") ;
	 scanf("%s %s",attrName,name) ;
	 printf("\nEnter 1:EQ   2:LE   3:APPROX    4:PRESENT  > ");
	 scanf("%d",&ans) ;
	 switch (ans)
			  {
			  case 1:tok = FTOK_EQ;break;
			  case 2:tok = FTOK_LE;break;
			  case 4:tok = FTOK_PRESENT;break;
			  default:tok = FTOK_APPROX;break;
			  }

	 if ( (dsCode = NWDSAddFilterToken ((NWDS_FILTER_CURSOR NWFAR *) Current,
										  FTOK_ANAME, attrName, (NWSYNTAX_ID)0) ) < 0)
		printf("NWDSAddFilterToken with attr %s returns %d\n",attrName,dsCode);

	 dsCode = NWDSAddFilterToken ((NWDS_FILTER_CURSOR NWFAR *) Current,
										  tok, NULL, (NWSYNTAX_ID) 0);
	 dsCode = NWDSAddFilterToken ((NWDS_FILTER_CURSOR NWFAR *) Current,
									 FTOK_AVAL, name, SYN_CI_STRING);
	 }


	 dsCode = NWDSAddFilterToken ((NWDS_FILTER_CURSOR NWFAR *) Current,
										  FTOK_END, NULL, (NWSYNTAX_ID) 0);

	 dsCode = NWDSPutFilter (dContext, Filter, (NWDS_FILTER_CURSOR NWFAR *)
									Current, NULL);

	 dsCode = NWDSPutAttrName (dContext, AttrNamesBuf, "Common Name");

	 printf ("searching NDS...\n");
	 do
		{
		dsCode = NWDSSearch(dContext,baseObjName,sscope, FALSE,Filter,infotyp,
								 allAtrs, AttrNamesBuf,&IterHandle,0,&count,outBuf);
		if (dsCode < 0)
			{
			printf("NWDSSearch returns %d\n",dsCode) ;
			return ;
			}
		dsCode = NWDSGetObjectCount(dContext,outBuf,&totalObj) ;
		if (dsCode < 0)
			{
			printf("NWDSGetObjectCount returns %d\n",dsCode);
			return ;
			}
		printf("NWDSGetObjectName found %d objects\n",totalObj) ;

		for (i= 0 ; i < totalObj ; i++)
			 {
			 dsCode = NWDSGetObjectName(dContext,outBuf,name,\
												 &attrCount,&objInfo) ;
			 if (dsCode < 0)
				 {
				 printf("NWDSGetObjectName  returns %d\n",dsCode) ;
				 return ;
				 }
			 printf("%s\n",name) ;
			 ReadBuffer(dContext,outBuf,attrCount,name) ;
			 }
		}
	 while (IterHandle != NO_MORE_ITERATIONS);
}
/*-------------------------------------------------------------*/

void ReadObject(void)
{
NWDS_ITERATION iterationHandle = -1L;
NWDS_BUFFER  *inBuf, *outBuf;
NWDSCCODE dsCode ;
NWCOUNT attrCount;
char  objName[MAX_DN_CHARS] = "";
char attrName[200] ;

printf("\nEnter object to read > ") ;
scanf("%s",objName) ;

dsCode = NWDSAllocBuf(DEFAULT_MESSAGE_LEN, &outBuf);
if(dsCode < 0)
	  {
//      NWDSFreeBuf(inBuf);
		printf("NWDSAllocBuf returns %d\n",dsCode) ;
		return ;
		}

dsCode = NWDSRead(dContext,objName,DS_ATTRIBUTE_VALUES,TRUE,NULL,\
						&iterationHandle,outBuf);
if(dsCode < 0)
	{
	printf("\nNWDSREAD returns %d", dsCode);
//   NWDSFreeBuf(inBuf);
	NWDSFreeBuf(outBuf);
	return ;
	}

dsCode = NWDSGetAttrCount(dContext, outBuf, &attrCount);
if(dsCode < 0)
	return;

ReadBuffer(dContext,outBuf,attrCount,objName) ;
//NWDSFreeBuf(inBuf);
NWDSFreeBuf(outBuf);
}
/*--------------------------------------------------------------*/


void ReadBuffer(NWDSContextHandle context, NWDS_BUFFER *buf,\
											 NWCOUNT attrCount,char *objName)
{
NWSYNTAX_ID   syntax;
uint8 attrBool ;
uint32 attrULong ;
int32 attrLong ;
NWDSCCODE    dsCode ;
NWCOUNT valCount;
char         attrName[MAX_DN_CHARS + 1],attrVal[MAX_DN_CHARS + 1];
int         i, j;

for(i = 0; i < attrCount; i++)
{
dsCode = NWDSGetAttrName(context, buf, attrName,&valCount, &syntax);
if (dsCode < 0)
	return;
printf("\n%s:\t",attrName) ;
 for (j = 0; j < valCount; j++)
 {
  switch (syntax)
  {
  case SYN_BOOLEAN:dsCode = NWDSGetAttrVal(context, buf, syntax, &attrBool);
		 if(dsCode < 0)
					  return;
		 printf("%d", attrBool);break;
  case SYN_COUNTER:dsCode = NWDSGetAttrVal(context, buf, syntax, &attrULong);
		 if(dsCode < 0)
					  return;
		 printf("%uld", &attrULong);break;
  case SYN_INTEGER:
  case SYN_TIME:
  case SYN_INTERVAL:
		 dsCode = NWDSGetAttrVal(context, buf, syntax, &attrLong);
		 if(dsCode < 0)
			 return;
		 else printf("%ld",attrLong);break;
  case SYN_CE_STRING:
  case SYN_CI_STRING:
  case SYN_CLASS_NAME:
  case SYN_DIST_NAME :
  case SYN_NU_STRING:
  case SYN_PO_ADDRESS:
  case SYN_PR_STRING:
  case SYN_TEL_NUMBER:
		 dsCode = NWDSGetAttrVal(context, buf, syntax, attrVal);
		 if(dsCode < 0)
					  return;
		 printf("%s", attrVal);break;
  case SYN_OCTET_STRING:HandleOctetString(context,buf,syntax);break ;
  case SYN_OBJECT_ACL:HandleACL(context,buf,syntax); break;
  case SYN_FAX_NUMBER:HandleFaxNr(context,buf,syntax); break;
  case SYN_CI_LIST:HandleCIList(context,buf,syntax); break;
  //case SYN_STREAM:ReadStream(context,objName,attrName); break;
  default:
		 dsCode = NWDSGetAttrVal(context, buf, syntax, NULL);
		 if (dsCode < 0)
			 return ;
		 printf("\t:syntax id = %d",syntax);
  }
 }
}
printf("\nEnter a char to continue > ") ;
scanf("%s",attrVal) ;

}

/*-------------------------------------------------------------*/
void HandleOctetString(NWDSContextHandle context, NWDS_BUFFER *buf,\
											NWSYNTAX_ID   syntax)
{
Octet_String_T *str;
NWSIZE size;
NWDSCCODE    dsCode ;
int i ;

if (NWDSComputeAttrValSize(context,buf,syntax,&size) < 0)
	 return;

str =  malloc(size) ;

dsCode = NWDSGetAttrVal(context, buf, syntax, (void NWFAR *)str);
if(dsCode < 0)
	 return;
//for (i = 0 ; i < str->length ; i++)
//    printf("%o ",str->data[i]);
printf("%d octets found ",str->length);
}
/*-------------------------------------------------------------*/
void ReadStream(NWDSContextHandle context,char *objName,char *attrName)
{
NWDSCCODE    dsCode ;
NWDS_LOGIN_FILE fh ;
char outp[80] ;
int n ;

//if (NWDSComputeAttrValSize(context,buf,syntax,&size) < 0)
	  dsCode = NWDSOpenStream(context,objName,attrName,1,&fh) ;
	  if (dsCode < 0)
		  {
		  printf("NWDSOpenStream returns %d\n",dsCode) ;
		  return ;
		  }
	  printf("\n");
	  while( (n = read(fh,outp,80) ) > 0 )
		printf("%d bytes %s",n,outp);

	  close(fh);
}
/*-------------------------------------------------------------*/
void HandleFaxNr(NWDSContextHandle context, NWDS_BUFFER *buf,\
											NWSYNTAX_ID   syntax)
{
Fax_Number_T *str;
NWSIZE size;
NWDSCCODE    dsCode ;
int i ;

if (NWDSComputeAttrValSize(context,buf,syntax,&size) < 0)
	 return;

str =  malloc(size) ;

dsCode = NWDSGetAttrVal(context, buf, syntax, (void NWFAR *)str);
if(dsCode < 0)
	 return;

printf("%.12s",str->telephoneNumber);
}
/*-------------------------------------------------------------*/
void HandleACL(NWDSContextHandle context, NWDS_BUFFER *buf,\
											NWSYNTAX_ID   syntax)
{
Object_ACL_T *attrACL ;
NWSIZE size;
NWDSCCODE    dsCode ;
char str[7] ;
if (NWDSComputeAttrValSize(context,buf,syntax,&size) < 0)
	 return;

attrACL =  malloc(size) ;

dsCode = NWDSGetAttrVal(context, buf, syntax, (void NWFAR *)attrACL);
if(dsCode < 0)
	 return;
strcpy(str,"     ");
if(attrACL->privileges & DS_ATTR_SUPERVISOR) str[0] = 'S' ;
if(attrACL->privileges & DS_ATTR_COMPARE) str[1] = 'C' ;
if(attrACL->privileges & DS_ATTR_READ) str[2] = 'R' ;
if(attrACL->privileges & DS_ATTR_WRITE) str[3] = 'W' ;
if(attrACL->privileges & DS_ATTR_SELF) str[4] = 'A' ;
str[5] = '\0';

printf("\n\t%s %s [%s]", attrACL->protectedAttrName,attrACL->subjectName,str);
free(attrACL);
}

/*-------------------------------------------------------------*/
void HandleCIList(NWDSContextHandle context, NWDS_BUFFER *buf,\
											NWSYNTAX_ID   syntax)
{
CI_List_T *l ;
NWSIZE size;
NWDSCCODE    dsCode ;
char str[6] ;

if (NWDSComputeAttrValSize(context,buf,syntax,&size) < 0)
	 return;

l =  malloc(size) ;

dsCode = NWDSGetAttrVal(context, buf, syntax, (void NWFAR *)l);
if(dsCode < 0)
	 return;
while(l != NULL)
		  {
		  printf("%s ",l->s);
		  l = l->next ;
		  }
free(l);  /*not realy ok, add second pointer to scan list*/
}
/*-------------------------------------------------------------*/
void FreeExit()
{
NWDSFreeContext(dContext);
NWFreeUnicodeTables( );
exit(1) ;
}
/*------------------------------------------------------------------*/
void NDSLogout()
{
NWCONN_HANDLE      *connList;
CONNECT_INFO      connInfo;
NWNUMBER            maxConns, numConns;
NWCCODE            dsCode;
char               serverName[50] , ans[3] ;
int                i;

dsCode = NWDSLogout(dContext);
if(dsCode)
    printf("NWDSLogout returns %d\n",dsCode) ;

printf("\nClear connections > (y/n) > ") ;
scanf("%s",ans);
if (ans[0] == 'n')
   return ;
/*the folloing code should be replaced with the new NWCC functions */
NWGetMaximumConnections(&maxConns);
connList = malloc(maxConns * 2);
dsCode = NWGetConnectionList(0, connList, maxConns, &numConns);
if(dsCode)
	 {
	 printf("NWGetConnectionList returns %d\n",dsCode) ;
	 return ;
	 }

for(i = 0; i < numConns; i++)
		{
		NWGetFileServerName(connList[i], serverName);
		dsCode = NWGetConnectionStatus(connList[i], &connInfo,sizeof(CONNECT_INFO));
		if(dsCode)
			 continue ;
		if(connInfo.connectFlags & CONNECTION_NDS)
			 {
			 dsCode = NWFreeConnectionSlot(connList[i],SYSTEM_DISCONNECT);
			 if(dsCode)
				  printf("Error logging out from %s: %X\n", serverName,dsCode);
			 else
				  printf("Freed connection to %s.\n", serverName);
			 }
		}
}



NWCONN_HANDLE OpenConnectionByname()
{
	nuint8	buffer[MAX_RDN_CHARS + 1];
	nuint8	connType;
	nuint nameFormat ;
	NWCONN_HANDLE	connHandle,start;
	NWRCODE code ;
	int ans ;
   /*Enter 0 for the start connection Handle */
	printf("\nEnter start conn Handle > ") ;
	scanf("%d",&start) ;
	printf("\n\t1:FORMAT_BIND\t2:FORMAT_NDS_TREE > ") ;
	scanf("%d",&ans) ;
	switch (ans)
		{
		case 1:nameFormat = NWCC_NAME_FORMAT_BIND; printf("\nServer name > ");break ;
		case 2:nameFormat = NWCC_NAME_FORMAT_NDS_TREE; printf("\nTree name > ") ;break ;
		default :printf("Illegal choise\n"); return(-1) ;
		}

	scanf("%s",buffer) ;

	code = NWCCOpenConnByName(start,buffer,nameFormat,NWCC_OPEN_UNLICENSED,
		NWCC_RESERVED,&connHandle);

	if (code)
		{
		printf("NWCCOpenConnByName returns %x\n",code) ;
		return(-1) ;
		}
	printf("open connHandle %d to %s \n",connHandle,buffer) ;
	return(connHandle) ;

}
/*------------------------------------------------------------------*/
int InitNDSLogin(NWCONN_HANDLE *connHandle)
{
NWDSCCODE dsCode ;
NWCCODE Code ;

char tree[128] , password[128], objName[48] , ans[3];
NWDS_Session_Key_T sessionKey;
NWCONN_TYPE  connType;
NWOBJ_ID  objID;
BYTE serverName[48];
NWDS_FLAGS flag = 0 ;
NWDS_VALIDITY val = 420 ;

if ( (connHandle = OpenConnectionByname()) == -1)
	return(-1) ;

printf("\nEnter Object name + password > " ) ;
scanf("%s %s",objName,password) ;

dsCode = NWDSLogin(dContext,flag,(char NWFAR*)objName,(char NWFAR *)password,val);
if(dsCode)
	 {
	 printf("NWDSLogin returns %d\n",dsCode) ;
	 return(0) ;
	 }
dsCode = NWDSWhoAmI(dContext, objName);
if(!dsCode)
			 printf("You are logged into NDS as %s\n", objName);

/*Here , authenticating is not needed , as it was done already by NWDSLogin */
printf("\nAuthenticate y/n > ") ;
scanf("%s",ans) ;
if (ans[0] == 'n')
	return(1) ;
dsCode = NWDSAuthenticate(*connHandle, 0L, &sessionKey);
if(dsCode)
	 {
	 printf("NWDSAuthenticate returns %d %x\n",dsCode,dsCode) ;
	 return(0) ;
	 }

return(1) ;
}

/*-------------------------------------------------------------------*/
void GetContext()
{
	NWDSCCODE cCode ;
	char cx[MAX_DN_CHARS + 1] = "" ;

	cCode = NWDSGetContext(dContext,DCK_NAME_CONTEXT,cx) ;
	 if (cCode)
		 {
		 printf("NWDSGetContext returns %x %d\n",cCode,cCode) ;
		 return ;
		 }

	 printf("Context = %s\n",cx) ;
}
/*-------------------------------------------------------------------*/
int SetContext()
{
	NWDSCCODE cCode ;
	char ans[3];
	uint32 value ;
	char cx[MAX_DN_CHARS + 1] = "" ;



	 dContext = NWDSCreateContext() ;
	 if (dContext == ERR_CONTEXT_CREATION)
		 {
		 printf("WDSCreateContext fails\n") ;
		 return(0) ;
		 }

	 printf("\nEnter context to set > ")  ;
	 scanf("%s",cx ) ;

	 cCode = NWDSSetContext(dContext,DCK_NAME_CONTEXT,cx) ;
	 if (cCode)
		 {
		 printf("NWDSSetContext returns %x %d\n",cCode,cCode) ;
		 return(0) ;
		 }
	 printf("\nuse this as default context (y/n)  > ");
	 scanf("%s",ans);
	 if (ans[0] == 'y')
	 {
	 cCode = NWSetDefaultNameContext(strlen(cx),cx) ;
	 if (cCode)
		 printf("NWSetDefaultNameContext returns %x %d\n",cCode,cCode) ;
	 }

	 return(1) ;
}


/*-----------------------------------------------------------------------*/

void ScanConnRefs()
{
nuint32	connIterator = 0;
unsigned long connRef;
char	serverName[NW_MAX_SERVER_NAME_LEN];
NWCCODE	ccode;
int		preferred = 0;


printf("ScanConnRefs ..\n") ;
		do	{
			if(!(ccode = NWCCScanConnRefs(&connIterator, &connRef)))
				if(!(NWCCGetConnRefInfo(connRef,NWCC_INFO_SERVER_NAME,NW_MAX_SERVER_NAME_LEN,serverName)))
				{
				printf("Server %s:conn %lu \n",serverName,connRef) ;
				//GetAllConnRefInfo(connRef) ;
				}
		}	while(!ccode);
}



/*---------------------------------------------------------------------*/

void GetAllConnRefInfo(nuint32  connRef)
{

char choise[3] ;

NWRCODE code ;
NWCCConnInfo buf;

	printf("\nEnter conn ref > ") ;
	scanf("%lu",&connRef) ;

	code = NWCCGetAllConnRefInfo(connRef,NWCC_INFO_VERSION,&buf) ;

	if (code)
		{
		printf("NWCCGetAllConnRefInfo returns %x\n",code);
		return ;
		}
	printf("\nAuthentication State\t:");
	switch(buf.authenticationState)
		{
		case NWCC_AUTHENT_STATE_NONE:printf("NWCC_AUTHENT_STATE_NONE\n");break;
		case NWCC_AUTHENT_STATE_BIND:printf("NWCC_AUTHENT_STATE_BIND\n");break;
		case NWCC_AUTHENT_STATE_NDS:printf("NWCC_AUTHENT_STATE_NDS\n");break;
		default:printf("unknown state\n");
		}
	printf("broadcast State\t:");
	switch(buf.broadcastState)
		{
		case NWCC_BCAST_PERMIT_ALL:printf("NWCC_BCAST_PERMIT_ALL\n");break ;
		case NWCC_BCAST_PERMIT_SYSTEM:printf("NWCC_BCAST_PERMIT_SYSTEM\n");break ;
		case NWCC_BCAST_PERMIT_NONE:printf("NWCC_BCAST_PERMIT_NONE\n");break ;
		case NWCC_BCAST_PERMIT_POLL:printf("NWCC_BCAST_PERMIT_POLL\n");break ;
		default:printf("unknown state\n");
		}
	printf("connRef\t:%lu\n",buf.connRef);
	printf("Tree\t:%s\n",buf.treeName);
	printf("Connection Number\t:%u\n",buf.connNum);
	printf("User Id\t:",buf.userID);
	printf("Server\t:%s\n",buf.serverName);
	printf("NDS STATE\t:");
	if (buf.NDSState == NWCC_NDS_NOT_CAPABLE)
		printf("NWCC_NDS_NOT_CAPABLE");
	else printf("NWCC_NDS_CAPABLE");
	printf("maxPacketSize\t:%u\n",buf.maxPacketSize);
	printf("license State:\t");
	switch(buf.licenseState)
		{
		case NWCC_NOT_LICENSED :printf("NWCC_NOT_LICENSED\n");break;
		case NWCC_CONNECTION_LICENSED :printf("NWCC_CONNECTION_LICENSED\n");break;
		case NWCC_HANDLE_LICENSED :printf("NWCC_HANDLE_LICENSED\n");break;
		default :printf("unknown state\n");
		}
	printf("\nDistance\t:%d",buf.distance)  ;
	printf("\nEnter a key to continue > ");
	scanf("%s",&choise) ;
}


