/*************************************************************************
 *  LOGSTAT v1.01 - Log statistics                                       *
 *  Public Domain software from Rutgers University                       *
 *  By Scott Cousens and Mark Medici                                     *
 *                                                                       *
 *  Last modified : 29 September 1992                                    *
 *                                                                       *
 *  This routine checks for a previous LOGIN record for the user and     *
 *  displays it if it exists. Otherwise, a canned LOGSTAT.DAT info file  *
 *  is displayed.  This routine also saves the current login info for    *
 *  display the next time this user logs in, and maintains a history of  *
 *  all logins for all users in LOGSTAT.ALL.                             *
 *                                                                       *
 *   Received Parameters:                                                *
 *                       %1 = LOGIN_NAME                                 *
 *                       %2 = HOUR24 (current time)                      *
 *                       %3 = MINUTE (current time)                      *
 *                       %4 = DAY_OF_WEEK                                *
 *                       %5 = DAY                                        *
 *                       %6 = MONTH                                      *
 *                       %7 = YEAR                                       *
 *                       %8 = MACHINE (Model)                            *
 *                       %9 = NETWORK_ADDRESS:P_STATION                  *
 *                            (NetWare network address, ":", and the     *
 *                             physical node address)                    *
 *                                                                       *
 *                This routine checks for a previous LOGIN record for    *
 *                the user and displays it if it exists.  Otherwise, a   *
 *                canned NEWUSER info file is displayed.  This routine   *
 *                also saves the current login info for display the      *
 *                next time this user logs in.                           *
 *                                                                       *
 *                This version also maintains a history of all logins    *
 *                for this user in username.ALL, and for all users in    *
 *                ALLUSERS.LOG.                                          *
 *                                                                       *
 *************************************************************************/

#include <stdio.h>
#include <string.h>

void bell ();
void filenotfound (char*);
void error (char*, char*);
void pause ();
void crash ();
main (int argc, char *argv[])
{
  FILE *fp;
  char logfile[15], str[128], *newuser="LOGSTAT.DAT\0";
  int line=0;

  if (argc<9)
    crash ();
  strncpy (logfile, argv[1], 8);
  strcat (logfile, ".LOG");
  printf ("\nLogFile is %s.\n", logfile);
  fp = fopen (logfile, "r");
  if (fp)                              /* fp != NULL  */
  {                                    /* Name has a log file */
    fgets (str, 128, fp);              /* Display its contents */
    printf ("%s", str);
  }
  else                                 /* fp = NULL */
  {                                    /* Name does not have a logfile.  */
    fclose (fp);                       /* Do the newuser routine */
    fp = fopen (newuser,"r");
    if (fp)                            /* does the logstat.dat file exist */
    {
      while (!feof (fp))               /* Yes, copy to stdout */
      {
        fgets (str, 128, fp);
        printf ("%s", str);
        if ((++line%21)==0)
          pause ();
      }
      pause ();
    }
    else
      filenotfound (newuser);          /* No - error, file not found */
  }
  fclose (fp);
  fp = fopen (logfile, "w");
  if (!fp)
    error (logfile, "Unable to write to ");
  else
    fprintf (fp, "Last on: %s:%s on %s, %s-%s-%s, from %s @%s.\n",
                  argv[2], argv[3], argv[4], argv[5], argv[6],
                  argv[7], argv[8], argv[9]);
  fclose (fp);
  fp = fopen ("LOGSTAT.ALL","a");
  if (!fp) 
    error ("LOGSTAT.ALL", "Unable to write to ");
  else
    fprintf (fp, "%s on %s-%s-%s @ %s:%s from %s @%s\n",
                  argv[1], argv[5], argv[6], argv[7], argv[2],
                  argv[3], argv[8], argv[9]);
  fclose (fp);
}

void pause ()
{
  fprintf (stderr, "\nPress any key to Continue");
  while (!kbhit ());
  getch ();
  fprintf (stderr, "\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b"
                   "                         "
                   "\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b");
}

void filenotfound (char *filename)
{
  fprintf (stderr, "%s not found.  Program aborted.%c\n", filename, 7);
  exit (-1);
}

void error (char *filename, char *errormsg)
{
  fprintf (stderr, "%s %s.%c\n", errormsg, filename, 7);
}

void crash ()
{
  char *message =
  {
    "LOGSTAT v1.01 - Log statistics\n"
    "Public Domain software from Rutgers University\n"
    "By Scott Cousens and Mark Medici\n\n"
    "This routine checks for a previous LOGIN record for the user and\n"
    "displays it if it exists. Otherwise, a canned NEWUSER info file is\n"
    "displayed. This routine also saves the current login info for display\n"
    "the next time this user logs in.\n\n"
    "This version also maintains a history of all logins for this user in\n"
    "username.ALL, and for all users in ALLUSERS.LOG.\n\n"
    " Received Parameters:\n"
    "                       %1 = LOGIN_NAME\n"
    "                       %2 = HOUR24 (current time)\n"
    "                       %3 = MINUTE (current time)\n"
    "                       %4 = DAY_OF_WEEK\n"
    "                       %5 = DAY\n"
    "                       %6 = MONTH\n"
    "                       %7 = YEAR\n"
    "                       %8 = MACHINE (Model)\n"
    "                       %9 = P_STATION (Station Address)\n"
  } ;

  fprintf (stderr, "%s", message);
  exit (-1);
}
