/****************************************************************************
**   DISCLAIMER  
**
**   Novell, Inc. makes no representations or warranties with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.  
**   
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**   
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
****************************************************************************
**
**   File:    ISOBJIN.c
**   
**   Desc:    Allows the user to scan the bindery for an object in a set.
**   
**
**   Parameter descriptions:    > input
**                              < output
**
**        
**   Programmers:
**   Init   Who               Firm
**   ------------------------------------------------------------------
**   ARM    A. Ray Maxwell    Novell Developer Support.
**   
**   History:
**       
**   ------------------------------------------------------------------
**   11-10-94    ARM      First code.
*/

/****************************************************************************
**   Include headers, macros, function prototypes, etc.
*/

/*------------------------------------------------------------------------
**   ANSI
*/
  #include <stdio.h>
  #include <stdlib.h>
  #include <string.h>     /* strupr() strcpy() */
  #include <conio.h>      /* clrscr()            */
  
  /*------------------------------------------------------------------------
  **   NetWare
  */
  #include <nwcalls.h>
  
  /*------------------------------------------------------------------------
  **   Defines
  */
  #define NWDOS
  #define SIZEOFOBJNAME  48
  #define SIZEOFPROPNAME 48



/****************************************************************************
**   Main program start
*/
void main(int argc,char *argv[])
{
NWCONN_HANDLE   conn;

  NWOBJ_TYPE      objectType,
                  memberType;
    
  NWOBJ_ID        objectID;
  NWCCODE         ccode;
  CONNECT_INFO    connInfo;
  NWSTRUCT_SIZE   connInfoSize;
  char            objectName[SIZEOFOBJNAME];
  char              servername[SIZEOFOBJNAME];
  char            memberName[SIZEOFOBJNAME];
  char            propertyName[SIZEOFPROPNAME];


  ccode=NWCallsInit(NULL,NULL);
  if (ccode)
    exit(1);
  
  if (argc > 1){
    argv++;
    strcpy(servername,strupr(*argv));
    if (argc > 2){
    argv++;
    strcpy(objectName,strupr(*argv));
    }
  
    if (argc > 3) {
       ++argv;
       objectType = (NWWordSwap)(atoi(*argv));
    }
    if (argc > 4) {
       argv++;
       strcpy(propertyName,strupr(*argv));
    }
    if (argc > 5) {
       argv++;
       strcpy (memberName,strupr(*argv));
    }
    if (argc > 6) {
       argv++;
       memberType = (NWWordSwap)(atoi(*argv));
    }
  
  }
  else {
    clrscr();
    printf ("USAGE: ISOBJIN <server name><object name><object type>\n");
    printf ("       <property name><member Name><member Type>\n");
    printf ("       servername=name of the NetWare server.\n");
    printf ("       object name= like EVERYONE etc\n");
    printf ("       object type= 2 for OT_USER_GROUP 1,2,3, etc.\n");
    printf ("       property Name= GROUP_MEMBERS etc.\n");
    printf ("       member Name= The member of property <username>.\n");
    printf ("       member type= 1,2,3, bindery object type.\n");
    printf ("EXAMPLE: isobjin moiraine EVERYONE 2 GROUP_MEMBERS RAY 1 \n");

  exit(1);
}

  ccode=NWCallsInit(NULL,NULL);

  ccode = NWGetConnectionHandle(
           /* > servername        */ servername,
           /*   Novell Reserved1  */ 0,
           /* < connection Handle */ &conn,
           /*   Novell Reserved2  */ NULL);


  ccode = NWGetConnectionStatus(
           /* > connection Handle        */ conn,
           /* < pointer to CONNECT_INFO  */ &connInfo,
           /* > size of connStatusBuffer */ connInfoSize);

  if (ccode)
      exit(1);

  ccode = NWIsObjectInSet(
           /* > connection Handle     */ conn,
           /* > Object Name           */ objectName,
           /* > Object Type           */ objectType,
           /* > Property Name         */ propertyName,
           /* > Member Name           */ memberName,
           /* > Member Type           */ memberType);

  if (ccode){
     printf("NWIsObjectInSet failed error: %X\n",ccode);
     exit(1);
  }
  else
     printf("NWIsObjectInSet worked with %X\n",ccode);
}
                                                                                                                               
