/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* FullyPth : Get fully path of file.                                       */
/* Author   : Marc Chauffour                                                */
/* Written      : 02/16/90 09:24am                                          */
/* Last_updated :                                                           */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* Use INT 21 - Function 60h                                                */
/* Rem : Letters are uppercased, forward slashes converted to backslashes,  */
/*       aterisks converted to appropriate number of question marks, and    */
/*       file an directory names are truncated to 8.3 if necessary          */
/*       '.' and '..' in the path are resolved                              */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
#include <dos.h>			/* DOS interrupt                    */
#include <dir.h>
#include <string.h>
#include "fullypth.h"
#define CAVAMAL -1			/* if problem */




/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* int getfullypath(char *,char *)                                          */
/* returns : 0  - Ok                                                        */
/*           02 - Invalid source name                                       */
/*           03 - Invalid drive or malformed path                           */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
int getfullypath
    (
    char *fulypth,			/* resolved path                    */
    char *pathin			/* path to resolve                  */
    )
{
char drive[MAXDRIVE];			/* drive letter                     */
char dir[MAXDIR];			/* Directory                        */
char filename[MAXDIR];			/* Filename without extension       */
char ext[MAXEXT];			/* Extension                        */
char path[255];				/* working area                     */
int drivenb;				/* drive number 		    */
int driveprov;				/* Temporary drive */

union REGS regs;			/* Register                         */
struct SREGS sregs;			/* segment register                 */
int ret;				/* Return code                      */
  strcpy(path,pathin);			/* save copy of path                */
  fnsplit(path,drive,dir,filename,ext); /* look for drive and dir           */
  drivenb = getdisk();		/* drive in use                     */
  if (drive[0] != '\0')			/* no drive ?	   		    */
    {
    driveprov = drive[0] - 'A';		/* drive NOW in use                 */
    setdisk(driveprov);			/* set new drive                    */
    }
  fnmerge(path,drive,dir,filename,ext);
  regs.h.ah = 0x60;			/* resolve path string              */
  sregs.ds = FP_SEG(path);		/* source path Segment              */
  regs.x.si = FP_OFF(path);		/* source path Offset               */
  sregs.es = FP_SEG(fulypth);		/* target path Segment              */
  regs.x.di = FP_OFF(fulypth);		/* target path Offset               */
  ret=intdosx(&regs,&regs,&sregs);      /* DOS interrupt with 60h           */
  setdisk(drivenb);			/* Retrun correct drive             */
  return( (regs.x.cflag!=0) ? ret : 0); /* Return code                      */
}





/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* int getnovellpath(char *,char *)                                         */
/* returns : 0  - Ok                                                        */
/*	     01 - Not a novell drive                                        */
/*           02 - Invalid source name                                       */
/*           03 - Invalid drive or malformed path                           */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
int getnovellpath
    (
    char *fulypth,			/* resolved path                    */
    char *path				/* path to resolve                  */
    )
{
int ret;				/* return code                      */
int i,j;				/* counter                          */
   ret=getfullypath(fulypth,path);	/* standard path                    */
   if (ret!=0) return(ret);		/* problem                          */
   if (fulypth[1]!='\\') return(1);	/* if "\\servername\volume\path\.." */
   for(i=0,j=2;fulypth[j]!='\\';)
     fulypth[i++]=fulypth[j++];         /* copy Server name                 */
   fulypth[i++]='/';			/* separator */
   for(j++;fulypth[j]!='\\';)
     fulypth[i++]=fulypth[j++];         /* copy volume name                 */
   fulypth[i++]=':';			/* separator                        */
   for(j++;fulypth[j]!='\0';)
     fulypth[i++]=fulypth[j++];         /* copy path                        */
   fulypth[i]='\0';
   return(0);				/* no problem                       */
}





/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
/* int getdrivepath(char *,char *)                                          */
/* returns : 0  - Ok                                                        */
/*           02 - Invalid source name                                       */
/*           03 - Invalid drive or malformed path                           */
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- */
int getdrivepath
    (
    char *fulypth,			/* resolved path                    */
    char *pathin			/* path to resolve                  */
    )
{
char drive[MAXDRIVE];			/* drive letter                     */
char dir[MAXDIR];			/* Directory                        */
char filename[MAXDIR];			/* Filename without extension       */
char ext[MAXEXT];			/* Extension                        */
char path[255];

int drivenb;				/* drive number 		    */
int driveprov;				/* drive provisoire                 */
int i,j;

union REGS regs;			/* Register                         */
struct SREGS sregs;			/* segment register                 */
int ret;				/* Return code                      */

  strcpy(path,strupr(pathin));
  fnsplit(path,drive,dir,filename,ext); /* look for drive and dir           */
  drivenb = getdisk();		/* drive in use                     */
  if (drive[0] != '\0')			/* no drive ?	   		    */
    {
    driveprov = drive[0] - 'A';		/* drive NOW in use                 */
    setdisk(driveprov);			/* set new drive                    */
    }
  else
    {
    drive[0]=drivenb + 'A';
    drive[1]=':';
    drive[2]='\0';
    }
  fnmerge(path,drive,dir,filename,ext);
  regs.h.ah = 0x60;			/* resolve path string              */
  sregs.ds = FP_SEG(path);		/* source path Segment              */
  regs.x.si = FP_OFF(path);		/* source path Offset               */
  sregs.es = FP_SEG(fulypth);		/* target path Segment              */
  regs.x.di = FP_OFF(fulypth);		/* target path Offset               */
  ret=intdosx(&regs,&regs,&sregs);      /* DOS interrupt with 60h           */
  setdisk(drivenb);			/* Old drive number                 */
  if (regs.x.cflag!=0) return(ret);	/* Return code                      */
  if (fulypth[1]!='\\') return(0);	/* if "\\servername\volume\path\.." */
  for(i=0,j=2;fulypth[j]!='\\';j++);
  for(j++;fulypth[j]!='\\';j++);
  fulypth[i++]=drive[0]; 		/* Drive letter                     */
  fulypth[i++]=':';			/* Colon                            */
  fulypth[i++]='\\';			/* Backslash                        */
  for(j++;fulypth[j]!='\0';)
    fulypth[i++]=fulypth[j++];          /* copy path                        */
  fulypth[i]='\0';
  return(0);				/* no problem                       */
}
