unit U_getres;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    ButtonUndef: TButton;
    ButtonDef: TButton;
    RadioGroupResourceType: TRadioGroup;
    EditResource: TEdit;
    ListBoxResources: TListBox;
    procedure FormActivate(Sender: TObject);
    procedure ListBoxResourcesClick(Sender: TObject);
    procedure RadioGroupResourceTypeClick(Sender: TObject);
    procedure ReadResources(Sender: TObject);
    procedure ButtonDefClick(Sender: TObject);
    procedure GetLocalAndRemoteName(Sender: TObject; S: String);
    procedure EditResourceChange(Sender: TObject);
    procedure FormSizes(Sender: TObject);
    procedure ButtonUndefClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

Const
   unmapped = '<unmapped>';

VAR
   LocalName, RemoteName  : PChar;
   MaxLen                 : WORD;
   cCode                  : WORD;

procedure TForm1.ReadResources(Sender: TObject);
VAR drvLetter   : Char;
begin
   MaxLen  := 255;
   ListBoxResources.Items.Clear;

   Case RadioGroupResourceType.ItemIndex of
      0: for drvLetter := 'A' to 'Z' do begin        { retrieve the defined mappings }
             StrPCopy(LocalName, drvLetter+':');
             MaxLen  := 255;
             cCode := WNetGetConnection(LocalName, RemoteName, @MaxLen);
             if (cCode=0)
                then ListBoxResources.Items.Add(StrPas(LocalName) + '=' +  StrPas(RemoteName))
                else ListBoxResources.Items.Add(StrPas(LocalName) + '=' + unmapped);
             end;
      1: for drvLetter := '1' to '9' do begin        { retrieve the network printers }
             StrPCopy(LocalName, 'LPT'+drvLetter+':');
             MaxLen  := 255;
             cCode := WNetGetConnection(LocalName, RemoteName, @MaxLen);
             if (cCode=0)
                then ListBoxResources.Items.Add(StrPas(LocalName) + '=' +  StrPas(RemoteName))
                else ListBoxResources.Items.Add(StrPas(LocalName) + '=' + unmapped);
             end;
      end;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
   MaxLen  := 255;
   GetMem(RemoteName, MaxLen);
   GetMem(LocalName,  MaxLen);
   ReadResources(Sender);
end;

procedure TForm1.ListBoxResourcesClick(Sender: TObject);
begin
   With ListBoxResources do                   { show the selected device }
        EditResource.Text := Items[ItemIndex];
   ButtonUndef.Enabled := (Pos(unmapped, EditResource.Text)=0);
   ButtonDef.Enabled   := False;
end;

procedure TForm1.RadioGroupResourceTypeClick(Sender: TObject);
begin                                         { select printers or drives }
   Case RadioGroupResourceType.ItemIndex of
      0: ButtonDef.Caption := '&Map';
      1: ButtonDef.Caption := '&Capture';
      end;
   ReadResources(Sender);
end;


Function UpperString(S: String): String;
VAR i : WORD;
begin
   for i := 1 to Length(S) do S[i] := upCase(S[i]);
   UpperString := S;
end;

procedure TForm1.GetLocalAndRemoteName(Sender: TObject; S: String);
VAR
   P: Word;
begin
   StrPCopy(localName,  '');
   StrPCopy(remoteName, '');
   S := UpperString(S);
   P := Pos(':', S);
   if     not ( (RadioGroupResourceType.ItemIndex = 0) and (P=2) )   {x:}
      and not ( (RadioGroupResourceType.ItemIndex = 1) and (P=5) and (Copy(S, 1, 3)='LPT') )  {LPTx:}
      then exit;
   StrPCopy(localName,  Copy(EditResource.Text, 1, P));
   StrPCopy(remoteName, Copy(EditResource.Text, P+2, 255));
end;

procedure TForm1.ButtonUndefClick(Sender: TObject);
begin                                         { remove a redirected device }
   GetLocalAndRemoteName(Sender, EditResource.Text);
   if (StrLen(localName)=0) then exit;
   cCode := WNetCancelConnection(LocalName, TRUE);
   if cCode=0 then ReadResources(Sender);
end;

procedure TForm1.ButtonDefClick(Sender: TObject);
begin                                         { add a redirected device }
   ButtonUndefClick(Sender);
   cCode := WNetAddConnection(remoteName, '', LocalName);
   if cCode=0 then ReadResources(Sender);
end;

procedure TForm1.EditResourceChange(Sender: TObject);
begin
   ButtonDef.Enabled   := true;
end;

procedure TForm1.FormSizes(Sender: TObject);
begin
   ListBoxResources.Width  := Panel1.Width -10;
   EditResource.Width      := ListBoxResources.Width;
   ListBoxResources.Height := Panel1.Height - EditResource.Height -10;
   EditResource.Top        := ListBoxResources.Height + 6;
end;

end.
