unit U_getmsg;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, SysUtils, IniFiles, Spin,
  CALCON16, CALMIS16, CALMSG16, NETCON16,
  U_Vars, Delphi_U;

type
  TBtnRightDlg = class(TForm)
    BtnStop: TBitBtn;
    BtnMinimize: TBitBtn;
    Bevel1: TBevel;
    MemoMessages: TMemo;
    TimerPoll: TTimer;
    SpinEdit1: TSpinEdit;
    LabelPollInterval: TLabel;
    ButtonClear: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Init(Sender: TObject);
    procedure BtnStopClick(Sender: TObject);
    procedure BtnMinimizeClick(Sender: TObject);
    procedure GetNewMessages(Sender: TObject);
    procedure SetNewMode(Sender: TObject; mode: WORD);
    procedure FormDestroy(Sender: TObject);
    procedure ButtonClearClick(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

CONST
   MaxMsg  = 100;
   Polling = 1000;
   MaxConn = 15;

TYPE
    TConnInfo =  Record
                 connID:  NWCONN_HANDLE;
                 srvName: String[48];
                 end;

    TConnTable = Record
                 max:     nuint16;
                 C:       Array[0..MaxConn-1] of TConnInfo;
                 END;

    TNWConnHandleList = Array[0..MaxConn] of NWCONN_HANDLE;

var
  BtnRightDlg: TBtnRightDlg;
  BrdcMode:    WORD;
  ConnTable:   TConnTable;
  connID:      NWCONN_HANDLE;
  conn:        BYTE;
  oldMode:     WORD;
  Timer:       WORD;
  MyWindow:    HWnd;
  MsgWaiting:  Boolean;
  MsgBuffer:   Array[0..300] of char;
  Msg:         String absolute MsgBuffer;
  Info:        Array[1..2] of String;
  InfoSelect:  BYTE;
  DT:          String;

implementation

{$R *.DFM}

procedure TBtnRightDlg.FormCreate(Sender: TObject);
begin
   Init(Sender);
end;

Procedure GetCurrentConnections(Var ConnTable: TConnTable);
VAR connInfo:       CONNECT_INFO;
    conn:           BYTE;
    connectionList: TNWConnHandleList;
begin
   FillChar(ConnTable, SizeOf(ConnTable), 0);
   cCode := NWGetNumConnections(@ConnTable.max); {max configured}
   if cCode<>0 THEN ConnTable.max := 8;
   if ConnTable.max>MaxConn THEN ConnTable.max := MaxConn;
   cCode := NWGetConnectionList(0, connectionList[0], ConnTable.max, @ConnTable.max); {max conn used}
   for conn  := 0 to ConnTable.max-1 do begin
       cCode := NWGetConnectionStatus(connectionList[conn], connInfo, sizeOf(connInfo));
       if cCode=0 THEN BEGIN
          ConnTable.C[conn].connId  := connectionList[conn];
          ConnTable.C[conn].srvName := StrPas(@connInfo.serverName);
          END;
         end;
end;

procedure TBtnRightDlg.Init(Sender: TObject);
var
   MsgIni: TIniFile;
begin
   MsgIni := TIniFile.Create('GETMSG.INI');
   SpinEdit1.Value := MsgIni.ReadInteger('Polling', 'Rate', 3);
   MsgIni.Free;

   GetCurrentConnections(ConnTable);
   cCode    := NWGetBroadcastMode(ConnTable.C[0].connID, @BrdcMode);
   oldMode  := BrdcMode;
   SetNewMode(Sender, 3);  { process msgs }
   Timer    := 0;
   InfoSelect := 1;


end;

procedure TBtnRightDlg.BtnStopClick(Sender: TObject);
begin
   Close;
end;

procedure TBtnRightDlg.BtnMinimizeClick(Sender: TObject);
begin
   MsgWaiting := False;
   BtnRightDlg.WindowState := wsMinimized;
end;

procedure TBtnRightDlg.GetNewMessages(Sender: TObject);
VAR MsgThere : Boolean;

   Function GetMessage(connID: NWCONN_HANDLE; VAR Msg, Info1, Info2: String): Boolean;
   Var MsgThere: Boolean;
       P:        BYTE;
   begin
      cCode    := NWGetBroadcastMessage(connID, @msg[1]);
      Msg[0]   := char(StrLen(@msg[1]));
      MsgThere := ((cCode=0) and (Length(msg)>0));
      If not MsgThere
         then Msg := ''
         else begin
              P := Pos(':', Msg);
              IF P>1 then Info1 := Copy(Msg, 1,   P-1)  else Info1 := 'Message';
              IF P>1 then Info2 := Copy(Msg, P+1, 255)  else Info2 := 'Waiting';
              end;
      GetMessage := MsgThere;
   end;

begin
   TimerPoll.Interval := Polling;   { reset to default }
   Inc(Timer);
   If Timer<=SpinEdit1.Value then exit
                             else Timer := 0;
   msg := '';
   if not MsgWaiting then begin
      Info[1] := 'Get Messages';
      Info[2] := Info[1];
      end;

  try

   for conn := 0 to ConnTable.max-1 do
       repeat
         MsgThere := GetMessage(ConnTable.C[conn].connID, Msg, Info[1], Info[2]);
         if MsgThere then begin
            with MemoMessages do begin
                 Lines.Add('['+DateTimeToStr(Now) + ' - ' +ConnTable.C[conn].srvName+'] '+ msg + CRLF);
                 if Lines.Count > (MaxMsg*2) then begin Lines.Delete(0); Lines.Delete(0); end;
                 end;
            with BtnRightDlg do begin
                 MsgWaiting := True;
                 MessageBeep($FFFF);
                 BringToFront;
                 SetFocus;
                 Show;
                 TimerPoll.Interval := 1000; Timer := SpinEdit1.Value;  { immediately check again }
                 end;
            end;
         until not MsgThere;
   InfoSelect := 3 - InfoSelect;
   BtnRightDlg.Caption := Info[InfoSelect];
  except
    on EGPFault do
       MyShowMessage('GPF - Urghh!');
  end;
end;

procedure TBtnRightDlg.SetNewMode(Sender: TObject; mode: WORD);
begin
   for conn := 0 to ConnTable.max-1 do
       cCode := NWSetBroadcastMode(ConnTable.C[conn].connID, mode);
   BrdcMode := mode;
end;

procedure TBtnRightDlg.FormDestroy(Sender: TObject);
begin
   SetNewMode(Sender, oldMode);
end;

procedure TBtnRightDlg.ButtonClearClick(Sender: TObject);
begin
   MemoMessages.Clear;
   BtnMinimizeClick(Sender);
end;

procedure TBtnRightDlg.SpinEdit1Change(Sender: TObject);
var
   MsgIni: TIniFile;
begin
   MsgIni := TIniFile.Create('GETMSG.INI');
   MsgIni.WriteInteger('Polling', 'Rate', SpinEdit1.Value);
   MsgIni.Free;
end;

end.
