unit Delphi_u;
{  general variables/functions/procedures for Delphi }

interface

uses
    Forms, Controls, StdCtrls, Dialogs, SysUtils;


TYPE
     Str2                      = String[2];
     Str4                      = String[4];
     Str8                      = String[8];

     NWCCODE                   = WORD;


{ general }
{
FUNCTION  hex2(Number: BYTE): Str2;
FUNCTION  hex4(Number: Word): Str4;
FUNCTION  hex8(nr: LongInt): Str8;
}
procedure PushCursor;
procedure PopCursor;
procedure Hourglass;
procedure WaitCursor;
procedure NormalCursor;

Procedure NotYet(Sender: TObject);
Procedure ErrorMessage(Error: NWCCODE; Msg: String);
Procedure MyShowMessage(Msg: String);

{ list boxes }
procedure SelectDefaultListItem(Sender: TObject; VAR SelectedListbox: TListBox; VAR pos: Integer);
procedure ChangeCurrentListboxEntry(VAR NewName: String; VAR SelectedListbox: TListBox);
procedure ClearList(VAR SelectedListbox: TListBox);
procedure AddListEntry(Sender: TObject; VAR SelectedListbox: TListBox; VAR NewEntry: String);
procedure DeleteListEntry(Sender: TObject; VAR SelectedListbox: TListBox; VAR Pos: Integer);

VAR
   PushedCursor :    TCursor;


implementation

FUNCTION hex2(Number: BYTE): Str2;
CONST  hexa : Array[0..15] of Char = '0123456789ABCDEF';
BEGIN
     hex2[0] := #2;
     hex2[1] := hexa[Number SHR 4];
     hex2[2] := hexa[Number AND $0F];
END;

FUNCTION  hex4(Number: Word): Str4;
BEGIN
     hex4 :=  hex2(hi(Number)) + hex2(lo(Number));
END;

FUNCTION  hex8(nr: LongInt): Str8;
VAR DW : Record
         WHi, WLo : Word
         END absolute nr;
BEGIN
   hex8 := hex4(Swap(DW.WHi)) + hex4(Swap(DW.WLo))
END;

procedure PushCursor;
begin
   PushedCursor  := Screen.Cursor;
end;

procedure PopCursor;
begin
   Screen.Cursor := PushedCursor;
end;

procedure Hourglass;
begin
   Screen.Cursor := crHourGlass;
end;

procedure WaitCursor;
begin
   if Screen.Cursor = crHourGlass then Exit;
   PushedCursor  := Screen.Cursor;
   Screen.Cursor := crHourGlass;
end;

procedure NormalCursor;
begin
   Screen.Cursor := PushedCursor;
end;

Procedure NotYet(Sender: TObject);
begin
   MyShowMessage('This Function is not Implemented');
end;

Procedure MyShowMessage(Msg: String);
VAR SaveCursor : TCursor;
begin
   SaveCursor    := Screen.Cursor;
   Screen.Cursor := crArrow;
   ShowMessage(Msg);
   Screen.Cursor := SaveCursor;
end;

Procedure ErrorMessage(Error: NWCCODE; Msg: String);
begin
   if Error<>0 then MyShowMessage('Error '+IntToHex(Error, 4)+': '+Msg);
end;

procedure SelectDefaultListItem(Sender: TObject; VAR SelectedListbox: TListBox; VAR pos: Integer);
begin
   if (SelectedListbox=nil) then exit;
   if (SelectedListbox.ItemIndex >= 0)                      { override pos if valid position }
      then pos := SelectedListbox.ItemIndex          else
   if ((Pos <= -1) and (SelectedListbox.Items.Count > 0))   { if none selected, select first }
      then Pos := 0                                  else
   if ( Pos >= SelectedListbox.Items.Count)                 { too big }
      then Pos := Pred(SelectedListbox.Items.Count);
   SelectedListbox.ItemIndex := pos;
end;

procedure ChangeCurrentListboxEntry(VAR NewName: String; VAR SelectedListbox: TListBox);
{  Delete current entry and insert new entry - e.g. renaming }
{  NewName must be #0 terminated }
VAR Pos, NewPos:       Integer;
begin
   if (SelectedListbox=nil) then exit;
   Pos    := SelectedListbox.ItemIndex;
   SelectedListbox.Items.Delete(Pos);
   NewPos := SelectedListbox.Items.Add(NewName);
   SelectedListbox.ItemIndex := NewPos;
end;

procedure ClearList(VAR SelectedListbox: TListBox);
begin
   if (SelectedListbox=nil) then exit;
   While SelectedListbox.Items.Count > 0
         DO SelectedListbox.Items.Delete(0);
end;

procedure AddListEntry(Sender: TObject; VAR SelectedListbox: TListBox; VAR NewEntry: String);
{   add entry if not existing    }
VAR NewPos    : Integer;
begin
   if (SelectedListbox=nil) then exit;
   if (SelectedListbox.GetTextLen>32000) then exit;
   NewPos := SelectedListbox.Items.IndexOf(NewEntry);
   IF (NewPos=-1) THEN begin
      NewPos := SelectedListbox.Items.Add(NewEntry);
      SelectedListbox.ItemIndex := NewPos;
      end;
end;


procedure DeleteListEntry(Sender: TObject; VAR SelectedListbox: TListBox; VAR Pos: Integer);
begin
   if (SelectedListbox=nil) then exit;
   SelectedListbox.Items.Delete(Pos);
   IF Pos <> SelectedListbox.ItemIndex THEN BEGIN {change current index}
         IF Pos>=SelectedListbox.Items.Count THEN Pos := Pred(SelectedListbox.Items.Count);
      END;
   SelectedListBox.ItemIndex := Pos;
end;


end.

