unit U_selsrv;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, SysUtils,
  CLXWIN16, CALBND16, CALMIS16, NETNDS16,
  U_Vars, Delphi_U;

type
  TSelectServer = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    Bevel1: TBevel;
    ServerList: TRadioGroup;
    EditUser: TEdit;
    EditSrv: TEdit;
    User: TLabel;
    NetWare: TLabel;

    procedure FormActivate(Sender: TObject);
    procedure ServerListClick(Sender: TObject);
  private
    { Private declarations }
    connRefList : Array[0..20] of nuint32;
  public
    { Public declarations }
  end;

CONST MaxSize = 255;

var
  SelectServer: TSelectServer;

implementation

{$R *.DFM}

function GetBinderyObjectName(objID: nuint32; VAR Name: String): NWCCODE;
VAR
   objType : nuint16;
   objName : String;
   cCode :      NWCCODE;
begin
   cCode   := NWGetObjectName(connHandle, objID, @objName[1], @objType);
   if cCode<>0 then objName := #0;
   Name := StrPas(@objName[1]);
   GetBinderyObjectName := cCode;
end;

function GetNDSObjectName(objID: nuint32; VAR Name: String): NWCCODE;
VAR
   context :    NWDSContextHandle;
   conn :       NWCONN_HANDLE;
   objName :    String;
   cCode :      NWCCODE;
begin
   context := NWDSCreateContext;
   cCode := NWDSMapIDToName(context, connHandle, objID, @objName[1]);
   if cCode<>0 then objName := #0;
   Name := StrPas(@objName[1]);
   GetNDSObjectName := cCode;
   if cCode >= 0 then cCode := NWDSFreeContext(context);
end;

Procedure GetServerNameFromConnRef(Ref: nuint32; Srv: pChar);
VAR Server : pChar;
begin
   Server   := StrAlloc(MaxSize);
   Server   := '';
   cCode    := NWCCGetConnRefInfo(Ref, NWCC_INFO_SERVER_NAME, MaxSize, Server);
   ErrorMessage(cCode, 'NWCCGetConnRefInfo');
   StrCopy(Srv, Server);
   StrDispose(Server);
end;

function GetUserNameFromConnRef(Ref: nuint32; usr: pChar): NWCCODE;
VAR
   User     : String;
   UserID   : nuint32;
   cCode2   : NWCCODE;
begin
   { Get User ID }
   User     := #0;
   cCode    := NWCCGetConnRefInfo(Ref, NWCC_INFO_USER_ID, SizeOf(UserID), @UserID);
   ErrorMessage(cCode, 'NWCCGetConnRefInfo');

   { Now Get User Name }
   if cCode=0 then begin
      cCode2 := GetNDSObjectName(UserID, User);                           { NDS object ? }
      if cCode2<>0 then cCode2 := GetBinderyObjectName(UserID, User);     { bindery object ? }
      if cCode2<>0 then cCode  := cCode2;
      end;
   StrPCopy(usr, User);
   GetUserNameFromConnRef := cCode;
end;

function GetServerVersionFromConnRef(Ref: nuint32; VAR NWVer:  NWCCVersion): NWCCODE;
begin
   { Get NetWare Version }
   cCode    := NWCCGetConnRefInfo(Ref, NWCC_INFO_SERVER_VERSION, SizeOf(NWVer), @NWVer);
   ErrorMessage(cCode, 'NWCCGetConnRefInfo');
   GetServerVersionFromConnRef := cCode;
end;


Procedure TSelectServer.FormActivate(Sender: TObject);
VAR
   scanIterator  : nuint32;
   connRef       : nuint32;
   Server        : pChar;
begin
   While (ServerList.Items.Count>0) DO ServerList.Items.Delete(0);  { First Clean Up }

   Server       := StrAlloc(MaxSize);
   scanIterator := 0;
   Repeat  { Scan all existing Connections }
      cCode := NWCCScanConnRefs(@scanIterator, @connRef);
      if cCode=0 then begin
         connRefList[Pred(scanIterator)]  := connRef;
         GetServerNameFromConnRef(connRef, Server);
         if StrLen(Server)>0 then ServerList.Items.Add(StrPas(Server));
         end;
      Until cCode<>0;
   StrDispose(Server);
   if (ServerList.ItemIndex=-1) then ServerList.ItemIndex := 0;  { select a server }

end;

procedure TSelectServer.ServerListClick(Sender: TObject);
VAR
   reserved:   nuint;
   User:       pChar;
   connRef:    nuint32;
   NWVer:      NWCCVersion;
begin
   { A server was selected - now get the Connection Handle }
   connRef     := ConnRefList[ServerList.ItemIndex];
   cCode       := NWCCOpenConnByRef(connRef, NWCC_OPEN_LICENSED, reserved, @connHandle);
   ErrorMessage(cCode, 'NWCCOpenConnByRef');

   { retrieve some info about connection }
   if cCode=0 then begin
      cCode := GetServerVersionFromConnRef(connRef, NWVer);
      if cCode = 0
         then EditSrv.Text := IntToStr(NWVer.major) + '.' + IntToStr(NWVer.minor)
         else EditSrv.Text := '';

      User := StrAlloc(MaxSize);
      GetUserNameFromConnRef(connRef, User);
      EditUser.Text := StrPas(User);
      StrDispose(User);
      end;
end;

end.
