/****************************************************************************
**      DISCLAIMER  
**  
**   Novell, Inc. makes no representations or warranties with respect to
**   any NetWare software, and specifically disclaims any express or
**   implied warranties of merchantability, title, or fitness for a
**   particular purpose.  
**
**   Distribution of any NetWare software is forbidden without the
**   express written consent of Novell, Inc.  Further, Novell reserves
**   the right to discontinue distribution of any NetWare software.
**   
**   Novell is not responsible for lost profits or revenue, loss of use
**   of the software, loss of data, costs of re-creating lost data, the
**   cost of any substitute equipment or program, or claims by any party
**   other than you.  Novell strongly recommends a backup be made before
**   any software is installed.   Technical support for this software
**   may be provided at the discretion of Novell.
****************************************************************************
**
**   File: GETID.C
**
**   Desc: Gets a users objectID. It is then printed it to the screen,
**           in a long and also converts it to a character string.
**         This code is written to help programers understand how to
**         read the objectID from the bindery and put it into the format
**         they would need to say: create a mail directory.
**
**   Programmers:
**   Ini   Who                Firm
**   ------------------------------------------------------------------
**   ARM   A. Ray Maxwell     Novell Developer Support.
**
**   History:
**
**   ------------------------------------------------------------------
**   08-07-95   ARM   First code.
*/

/***************************************************************************
**   Include headers, macros, function prototypes, etc.
*/

   /*------------------------------------------------------------------
   **   ANSI
   */
   #include <stdlib.h>          /* exit(), atol()        */
   #include <stdio.h>           /* printf()              */
   #include <string.h>          /* strcpy()              */
   #include <conio.h>           /* clrscr()              */
   /*------------------------------------------------------------------
   **   NetWare
   */
   #include <nwcalls.h>



/****************************************************************************
**   Program Start
*/
void main(int argc, char *argv[])
{
   NWCONN_HANDLE   connHandle;
   DWORD           swapID;
   NWOBJ_ID        objectID;
   NWCCODE         ccode;
   char            server[50];
   char            objectName[48];
   char             object[48];

   if(argc <= 2) 
   {
      printf("Usage: GETID <server> <object Name>\n\n");
      exit(1);
   }

   strcpy(server,    strupr(argv[1]));
   strcpy(objectName,strupr(argv[2]));

   ccode = NWCallsInit(NULL, NULL);

   if(ccode)
      exit(1);

   ccode = NWGetConnectionHandle(
           /* > servername        */ server,
           /*   Novell Reserved1  */ 0,
           /* < connection Handle */ &connHandle,
           /*   Novell Reserved2  */ NULL);
   if(ccode)
   {
      printf("NWGetConnectionHandle failed %X\n",ccode);
      exit(1);
   }

   ccode=NWGetObjectID(
         /* > connection Handle        */ connHandle,
         /* > object Name              */ objectName,
         /* > objectType               */ OT_USER,
         /* < object ID                */ &objectID);
   if(ccode)
   {
      printf("NWGetObjectID failed %X\n",ccode);
      exit(1);
   }
   
   swapID=NWLongSwap(objectID);
   ltoa(swapID,object,16);
   clrscr();
   printf("This is the objectID in String form %s\n\n",strupr(object));

   printf("Object Name= %s   Object ID = %08lX\n",
         objectName,
         NWLongSwap(objectID));
}
